/*
 * Decompiled with CFR 0.152.
 */
package assets.levelup;

import assets.levelup.ClassBonus;
import assets.levelup.LevelUp;
import assets.levelup.PlayerExtendedProperties;
import assets.levelup.SkillPacketHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockRedstoneOre;
import net.minecraft.block.BlockStem;
import net.minecraft.block.BlockStone;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ContainerFurnace;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;

public class PlayerEventHandler {
    public static int xpPerLevel = 3;
    public static final UUID speedID = UUID.randomUUID();
    public static final UUID sneakID = UUID.randomUUID();
    private static Map<UUID, int[]> deathNote = new HashMap<UUID, int[]>();
    private static ItemStack[] lootList = new ItemStack[]{new ItemStack(Items.field_151103_aS), new ItemStack(Items.field_151120_aE), new ItemStack(Items.field_151032_g), new ItemStack(Items.field_151034_e), new ItemStack(Items.field_151133_ar), new ItemStack(Items.field_151124_az), new ItemStack(Items.field_151079_bi), new ItemStack((Item)Items.field_151112_aM), new ItemStack((Item)Items.field_151023_V), new ItemStack(Items.field_151042_j)};
    public static Map<Block, Integer> blockToCounter = new HashMap<Block, Integer>();
    private static ItemStack[] digLoot;
    private static ItemStack[] digLoot1;
    private static ItemStack[] digLoot2;
    private static ItemStack[] digLoot3;

    @SubscribeEvent
    public void onBreak(PlayerEvent.BreakSpeed event) {
        ItemStack itemstack = event.entityPlayer.func_71045_bC();
        if (itemstack != null) {
            if (itemstack.func_77973_b() instanceof ItemSpade) {
                if (event.block instanceof BlockDirt || event.block instanceof BlockGravel) {
                    event.newSpeed = event.originalSpeed * itemstack.func_150997_a(Blocks.field_150346_d) / 0.5f;
                }
            } else if (itemstack.func_77973_b() instanceof ItemPickaxe && event.block instanceof BlockRedstoneOre) {
                event.newSpeed = event.originalSpeed * itemstack.func_150997_a(Blocks.field_150450_ax) / 3.0f;
            }
        }
        if (event.block instanceof BlockStone || event.block == Blocks.field_150347_e || event.block == Blocks.field_150343_Z || event.block instanceof BlockOre) {
            event.newSpeed = event.originalSpeed + (float)(PlayerEventHandler.getSkill(event.entityPlayer, 0) / 5) * 0.2f;
        } else if (event.block.func_149688_o() == Material.field_151575_d) {
            event.newSpeed = event.originalSpeed + (float)(PlayerEventHandler.getSkill(event.entityPlayer, 3) / 5) * 0.2f;
        }
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        LevelUp.takenFromCrafting(event.player, event.crafting, event.craftMatrix);
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        if (event.entityLiving instanceof EntityPlayerMP) {
            deathNote.put(event.entityLiving.func_110124_au(), PlayerExtendedProperties.getPlayerData((EntityPlayer)event.entityLiving, true));
        } else if (event.entityLiving instanceof EntityMob && event.source.func_76346_g() instanceof EntityPlayer) {
            PlayerEventHandler.giveBonusFightingXP((EntityPlayer)event.source.func_76346_g());
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onInteract(PlayerInteractEvent event) {
        if (event.useItem != Event.Result.DENY && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR && event.entityPlayer.field_71104_cf != null) {
            EntityFishHook hook = event.entityPlayer.field_71104_cf;
            int loot = PlayerEventHandler.getFishingLoot(event.entityPlayer);
            if (loot >= 0) {
                ItemStack stack = event.entityPlayer.field_71071_by.func_70448_g();
                int i = stack.field_77994_a;
                int j = stack.func_77960_j();
                stack.func_77972_a(loot, (EntityLivingBase)event.entityPlayer);
                event.entityPlayer.func_71038_i();
                event.entityPlayer.field_71071_by.field_70462_a[event.entityPlayer.field_71071_by.field_70461_c] = stack;
                if (event.entityPlayer.field_71075_bZ.field_75098_d) {
                    stack.field_77994_a = i;
                    if (stack.func_77984_f()) {
                        stack.func_77964_b(j);
                    }
                }
                if (stack.field_77994_a == 0) {
                    event.entityPlayer.field_71071_by.field_70462_a[event.entityPlayer.field_71071_by.field_70461_c] = null;
                    MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(event.entityPlayer, stack));
                }
                if (!event.entityPlayer.func_71039_bw() && event.entityPlayer instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)event.entityPlayer).func_71120_a(event.entityPlayer.field_71069_bz);
                }
                event.useItem = Event.Result.DENY;
                if (!hook.field_70170_p.field_72995_K) {
                    EntityItem entityitem = new EntityItem(hook.field_70170_p, hook.field_70165_t, hook.field_70163_u, hook.field_70161_v, lootList[loot]);
                    double d5 = hook.field_146042_b.field_70165_t - hook.field_70165_t;
                    double d6 = hook.field_146042_b.field_70163_u - hook.field_70163_u;
                    double d7 = hook.field_146042_b.field_70161_v - hook.field_70161_v;
                    double d8 = MathHelper.func_76133_a((double)(d5 * d5 + d6 * d6 + d7 * d7));
                    double d9 = 0.1;
                    entityitem.field_70159_w = d5 * d9;
                    entityitem.field_70181_x = d6 * d9 + (double)MathHelper.func_76133_a((double)d8) * 0.08;
                    entityitem.field_70179_y = d7 * d9;
                    hook.field_70170_p.func_72838_d((Entity)entityitem);
                    hook.field_146042_b.field_70170_p.func_72838_d((Entity)new EntityXPOrb(hook.field_146042_b.field_70170_p, hook.field_146042_b.field_70165_t, hook.field_146042_b.field_70163_u + 0.5, hook.field_146042_b.field_70161_v + 0.5, new Random().nextInt(6) + 1));
                }
            }
        }
    }

    @SubscribeEvent
    public void onBlockBroken(BlockEvent.BreakEvent event) {
        if (!event.world.field_72995_K && event.getPlayer() != null && event.block != null) {
            Random random = new Random();
            if (event.block.func_149688_o() == Material.field_151578_c) {
                int skill = PlayerEventHandler.getSkill(event.getPlayer(), 11);
                if (random.nextFloat() <= (float)skill / 200.0f) {
                    ItemStack[] aitemstack4 = digLoot;
                    float f = random.nextFloat();
                    if (f <= 0.1f) {
                        aitemstack4 = digLoot2;
                    }
                    if (f <= 0.4f) {
                        aitemstack4 = digLoot1;
                    }
                    if (random.nextInt(500) == 0) {
                        aitemstack4 = digLoot3;
                    }
                    ItemStack itemstack = aitemstack4[random.nextInt(aitemstack4.length)];
                    ItemStack itemstack1 = itemstack.func_77946_l();
                    itemstack1.field_77994_a = 1;
                    if (aitemstack4 == digLoot1) {
                        itemstack1.func_77964_b(random.nextInt(80) + 20);
                    }
                    event.world.func_72838_d((Entity)new EntityItem(event.world, (double)event.x, (double)event.y, (double)event.z, itemstack1));
                    for (int i1 = 0; i1 < itemstack.field_77994_a - 1; ++i1) {
                        if (!(random.nextFloat() < 0.5f)) continue;
                        event.world.func_72838_d((Entity)new EntityItem(event.world, (double)event.x, (double)event.y, (double)event.z, itemstack1.func_77946_l()));
                    }
                }
            } else if (event.block instanceof BlockGravel) {
                int skill = PlayerEventHandler.getSkill(event.getPlayer(), 11);
                if (random.nextInt(10) < skill / 5) {
                    event.world.func_72838_d((Entity)new EntityItem(event.world, (double)event.x, (double)event.y, (double)event.z, new ItemStack(Items.field_151145_ak)));
                }
            } else if (event.block instanceof BlockLog) {
                int skill = PlayerEventHandler.getSkill(event.getPlayer(), 3);
                if (random.nextDouble() <= (double)skill / 150.0) {
                    event.world.func_72838_d((Entity)new EntityItem(event.world, (double)event.x, (double)event.y, (double)event.z, new ItemStack(Items.field_151055_y, 2)));
                }
                if (random.nextDouble() <= (double)skill / 150.0) {
                    event.world.func_72838_d((Entity)new EntityItem(event.world, (double)event.x, (double)event.y, (double)event.z, PlayerEventHandler.getPlanks(event.getPlayer(), event.block, event.blockMetadata)));
                }
            } else if (event.block instanceof BlockOre || event.block instanceof BlockRedstoneOre) {
                int skill = PlayerEventHandler.getSkill(event.getPlayer(), 0);
                if (!blockToCounter.containsKey(event.block)) {
                    blockToCounter.put(event.block, blockToCounter.size());
                }
                LevelUp.incrementOreCounter(event.getPlayer(), blockToCounter.get(event.block));
                if (random.nextDouble() <= (double)skill / 200.0) {
                    event.world.func_72838_d((Entity)new EntityItem(event.world, (double)event.x, (double)event.y, (double)event.z, new ItemStack(event.block.func_149650_a(event.blockMetadata, random, 1), event.block.quantityDropped(event.blockMetadata, 0, random), event.block.func_149692_a(event.blockMetadata))));
                }
            } else if (event.block instanceof BlockCrops || event.block instanceof BlockStem) {
                int skill = PlayerEventHandler.getSkill(event.getPlayer(), 9);
                if (random.nextInt(10) < skill / 5) {
                    Item ID = event.block.func_149650_a(event.blockMetadata, random, 0);
                    event.world.func_72838_d((Entity)new EntityItem(event.world, (double)event.x, (double)event.y, (double)event.z, new ItemStack(ID, 1, event.block.func_149692_a(event.blockMetadata))));
                }
            }
        }
    }

    private static ItemStack getPlanks(EntityPlayer player, Block block, int meta) {
        if (block != Blocks.field_150364_r) {
            InventoryCrafting craft = new ContainerPlayer((InventoryPlayer)player.field_71071_by, (boolean)(!player.field_70170_p.field_72995_K ? true : false), (EntityPlayer)player).field_75181_e;
            craft.func_70299_a(1, new ItemStack(block, 1, meta));
            ItemStack planks = CraftingManager.func_77594_a().func_82787_a(craft, player.field_70170_p);
            if (planks != null) {
                planks.field_77994_a = 2;
                return planks;
            }
        }
        return new ItemStack(Blocks.field_150344_f, 2, meta & 3);
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        PlayerEventHandler.loadPlayer(event.player);
    }

    @SubscribeEvent
    public void onPlayerConstruction(EntityEvent.EntityConstructing event) {
        IExtendedEntityProperties skills;
        if (event.entity instanceof EntityPlayer && (skills = event.entity.getExtendedProperties("LevelUpSkills")) == null) {
            skills = new PlayerExtendedProperties();
            event.entity.registerExtendedProperties("LevelUpSkills", skills);
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEventHandler.loadPlayer(event.player);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (deathNote.containsKey(event.player.func_110124_au())) {
            PlayerExtendedProperties.setPlayerData(event.player, deathNote.get(event.player.func_110124_au()));
            deathNote.remove(event.player.func_110124_au());
        }
        PlayerEventHandler.loadPlayer(event.player);
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.entityLiving instanceof EntityPlayer) {
            AttributeModifier mod;
            int skill;
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            try {
                TileEntityFurnace furnace;
                if (!player.field_70170_p.field_72995_K && player.field_71070_bA instanceof ContainerFurnace && (furnace = ((ContainerFurnace)player.field_71070_bA).field_75158_e) != null && furnace.func_145950_i() && furnace.func_145948_k()) {
                    ItemStack stack = furnace.func_70301_a(0);
                    if (stack != null && furnace.field_145961_j < 199) {
                        Random rand = new Random();
                        if (stack.func_77973_b().func_77661_b(stack) == EnumAction.eat) {
                            int cook = PlayerEventHandler.getSkill(player, 7);
                            if (cook > 10) {
                                furnace.field_145961_j += rand.nextInt(cook / 10);
                            }
                        } else {
                            int smelt = PlayerEventHandler.getSkill(player, 4);
                            if (smelt > 10) {
                                furnace.field_145961_j += rand.nextInt(smelt / 10);
                            }
                        }
                    }
                    if (furnace.field_145961_j > 200) {
                        furnace.field_145961_j = 199;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (PlayerExtendedProperties.getPlayerClass(player) != 0 && PlayerExtendedProperties.getSkillPoints(player) < xpPerLevel * (player.field_71068_ca - 4) + 20) {
                ClassBonus.addBonusToSkill(player, "XP", xpPerLevel, true);
            }
            if ((skill = PlayerEventHandler.getSkill(player, 9)) != 0) {
                Random random = new Random();
                if (random.nextFloat() <= (float)skill / 2500.0f) {
                    PlayerEventHandler.growCropsAround(player.field_70170_p, skill / 4, player);
                }
            }
            IAttributeInstance atinst = player.func_110148_a(SharedMonsterAttributes.field_111263_d);
            skill = PlayerEventHandler.getSkill(player, 6);
            if (skill != 0) {
                mod = new AttributeModifier(speedID, "SprintingSkillSpeed", (double)((float)skill / 100.0f), 2);
                if (player.func_70051_ag()) {
                    if (atinst.func_111127_a(speedID) == null) {
                        atinst.func_111121_a(mod);
                    }
                } else if (atinst.func_111127_a(speedID) != null) {
                    atinst.func_111124_b(mod);
                }
                if (player.field_70143_R > 0.0f) {
                    player.field_70143_R *= 1.0f - (float)(skill / 5) / 100.0f;
                }
            }
            if ((skill = PlayerEventHandler.getSkill(player, 8)) != 0) {
                mod = new AttributeModifier(sneakID, "SneakingSkillSpeed", (double)((float)(2 * skill) / 100.0f), 2);
                if (player.func_70093_af()) {
                    if (atinst.func_111127_a(sneakID) == null) {
                        atinst.func_111121_a(mod);
                    }
                } else if (atinst.func_111127_a(sneakID) != null) {
                    atinst.func_111124_b(mod);
                }
            }
        }
    }

    @SubscribeEvent
    public void onSmelting(PlayerEvent.ItemSmeltedEvent event) {
        Random random = new Random();
        if (event.smelting.func_77973_b().func_77661_b(event.smelting) == EnumAction.eat) {
            if (random.nextFloat() <= (float)PlayerEventHandler.getSkill(event.player, 7) / 200.0f) {
                ++event.smelting.field_77994_a;
            }
        } else if (random.nextFloat() <= (float)PlayerEventHandler.getSkill(event.player, 4) / 200.0f) {
            ++event.smelting.field_77994_a;
        }
    }

    public static int getFishingLoot(EntityPlayer player) {
        Random random = new Random();
        if (random.nextDouble() > (double)(PlayerEventHandler.getSkill(player, 10) / 5) * 0.05) {
            return -1;
        }
        return new Random().nextInt(lootList.length);
    }

    public static int getSkill(EntityPlayer player, int id) {
        return PlayerExtendedProperties.getSkillFromIndex(player, id);
    }

    public static void giveBonusFightingXP(EntityPlayer player) {
        byte pClass = PlayerExtendedProperties.getPlayerClass(player);
        if (pClass == 2 || pClass == 5 || pClass == 8 || pClass == 11) {
            player.func_71023_q(2);
        }
    }

    public static void loadPlayer(EntityPlayer player) {
        byte cl = PlayerExtendedProperties.getPlayerClass(player);
        int[] data = PlayerExtendedProperties.getPlayerData(player, false);
        LevelUp.initChannel.sendTo(SkillPacketHandler.getPacket(Side.CLIENT, "LEVELUPINIT", player.func_145782_y(), cl, data), (EntityPlayerMP)player);
    }

    private static void growCropsAround(World world, int range, EntityPlayer player) {
        int posX = (int)player.field_70165_t;
        int posY = (int)player.field_70163_u;
        int posZ = (int)player.field_70161_v;
        int dist = range / 2 + 2;
        for (int x = posX - dist; x < posX + dist + 1; ++x) {
            block1: for (int z = posZ - dist; z < posZ + dist + 1; ++z) {
                for (int y = posY - dist; y < posY + dist + 1; ++y) {
                    Block soil;
                    if (!world.func_147437_c(x, y + 1, z)) continue;
                    Block block = world.func_147439_a(x, y, z);
                    if (!(block instanceof IPlantable) || (soil = world.func_147439_a(x, y - 1, z)) == null || !soil.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)block)) continue block1;
                    ItemDye.applyBonemeal((ItemStack)new ItemStack(Items.field_151100_aR), (World)world, (int)x, (int)y, (int)z, (EntityPlayer)player);
                    continue block1;
                }
            }
        }
    }

    static {
        blockToCounter.put(Blocks.field_150365_q, 0);
        blockToCounter.put(Blocks.field_150369_x, 1);
        blockToCounter.put(Blocks.field_150450_ax, 2);
        blockToCounter.put(Blocks.field_150366_p, 3);
        blockToCounter.put(Blocks.field_150352_o, 4);
        blockToCounter.put(Blocks.field_150412_bA, 5);
        blockToCounter.put(Blocks.field_150482_ag, 6);
        blockToCounter.put(Blocks.field_150449_bY, 7);
        digLoot = new ItemStack[]{new ItemStack(Items.field_151119_aD, 8), new ItemStack(Items.field_151054_z, 2), new ItemStack(Items.field_151044_h, 4), new ItemStack(Items.field_151159_an), new ItemStack(Items.field_151055_y, 4), new ItemStack(Items.field_151007_F, 2)};
        digLoot1 = new ItemStack[]{new ItemStack(Items.field_151052_q), new ItemStack(Items.field_151051_r), new ItemStack(Items.field_151050_s), new ItemStack(Items.field_151049_t)};
        digLoot2 = new ItemStack[]{new ItemStack(Items.field_151123_aH, 2), new ItemStack(Items.field_151137_ax, 8), new ItemStack(Items.field_151042_j), new ItemStack(Items.field_151043_k)};
        digLoot3 = new ItemStack[]{new ItemStack(Items.field_151045_i)};
    }
}

