/*
 * Decompiled with CFR 0.152.
 */
package assets.levelup;

import assets.levelup.BowEventHandler;
import assets.levelup.PlayerExtendedProperties;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;

public class FightEventHandler {
    @SubscribeEvent
    public void onHurting(LivingHurtEvent event) {
        int j;
        DamageSource damagesource = event.source;
        float i = event.ammount;
        if (damagesource.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)damagesource.func_76346_g();
            if (damagesource instanceof EntityDamageSourceIndirect) {
                if (!damagesource.field_76373_n.equals("arrow")) {
                    i *= 1.0f + (float)BowEventHandler.getArcherSkill(entityplayer) / 100.0f;
                }
                if (FightEventHandler.getDistance(event.entityLiving, (EntityLivingBase)entityplayer) < 256.0f && entityplayer.func_70093_af() && !FightEventHandler.canSeePlayer(event.entityLiving) && !FightEventHandler.entityIsFacing(event.entityLiving, (EntityLivingBase)entityplayer)) {
                    i *= 1.5f;
                    entityplayer.func_146105_b((IChatComponent)new ChatComponentText("Sneak attack for 1.5x damage!"));
                }
            } else {
                if (entityplayer.func_71045_bC() != null) {
                    j = this.getSwordSkill(entityplayer);
                    Random rand = new Random();
                    if (rand.nextDouble() <= (double)j / 200.0) {
                        i *= 2.0f;
                    }
                    i *= 1.0f + (float)(j / 5) / 20.0f;
                }
                if (entityplayer.func_70093_af() && !FightEventHandler.canSeePlayer(event.entityLiving) && !FightEventHandler.entityIsFacing(event.entityLiving, (EntityLivingBase)entityplayer)) {
                    i *= 2.0f;
                    entityplayer.func_146105_b((IChatComponent)new ChatComponentText("Sneak attack for 2x damage!"));
                }
            }
        }
        if (event.entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            j = this.getDefenseSkill(player);
            if (!damagesource.func_76363_c()) {
                i *= 1.0f - (float)(j / 5) / 20.0f;
            }
            if (player.func_70632_aY()) {
                Random random = new Random();
                if (random.nextFloat() < (float)j / 100.0f) {
                    i *= 0.0f;
                }
            }
        }
        event.ammount = i;
    }

    @SubscribeEvent
    public void onTargetSet(LivingSetAttackTargetEvent event) {
        if (event.target instanceof EntityPlayer && event.entityLiving instanceof EntityMob && event.target.func_70093_af() && !FightEventHandler.entityHasVisionOf(event.entityLiving, (EntityPlayer)event.target) && event.entityLiving.func_142015_aE() != event.entityLiving.field_70173_aa) {
            ((EntityMob)event.entityLiving).func_70624_b(null);
        }
    }

    private int getDefenseSkill(EntityPlayer player) {
        return PlayerExtendedProperties.getSkillFromIndex(player, 2);
    }

    private int getSwordSkill(EntityPlayer player) {
        return PlayerExtendedProperties.getSkillFromIndex(player, 1);
    }

    public static boolean canSeePlayer(EntityLivingBase entityLiving) {
        EntityPlayer entityplayer = entityLiving.field_70170_p.func_72856_b((Entity)entityLiving, 16.0);
        if (entityplayer != null && entityLiving.func_70685_l((Entity)entityplayer)) {
            return !entityplayer.func_70093_af() || FightEventHandler.entityHasVisionOf(entityLiving, entityplayer);
        }
        return false;
    }

    public static float getDistance(EntityLivingBase entityLiving, EntityLivingBase entityliving1) {
        return MathHelper.func_76124_d((double)((entityliving1.field_70165_t - entityLiving.field_70165_t) * (entityliving1.field_70165_t - entityLiving.field_70165_t) + (entityliving1.field_70161_v - entityLiving.field_70161_v) * (entityliving1.field_70161_v - entityLiving.field_70161_v)));
    }

    public static float getPointDistance(double d, double d1, double d2, double d3) {
        return MathHelper.func_76124_d((double)((d2 - d) * (d2 - d) + (d3 - d1) * (d3 - d1)));
    }

    public static boolean compareAngles(float f, float f1, float f2) {
        if (MathHelper.func_76135_e((float)(f - f1)) < f2) {
            return true;
        }
        if (f + f2 >= 360.0f && f + f2 - 360.0f > f1) {
            return true;
        }
        return f1 + f2 >= 360.0f && f1 + f2 - 360.0f > f;
    }

    public static boolean entityHasVisionOf(EntityLivingBase entityLiving, EntityPlayer player) {
        if (entityLiving == null || player == null) {
            return false;
        }
        if (FightEventHandler.getDistance(entityLiving, (EntityLivingBase)player) > 256.0f - (float)(PlayerExtendedProperties.getSkillFromIndex(player, "Sneaking") / 5) * 12.8f) {
            return false;
        }
        return entityLiving.func_70685_l((Entity)player) && FightEventHandler.entityIsFacing((EntityLivingBase)player, entityLiving);
    }

    public static boolean entityIsFacing(EntityLivingBase entityLiving, EntityLivingBase entityliving1) {
        if (entityLiving == null || entityliving1 == null) {
            return false;
        }
        float f = -((float)(entityliving1.field_70165_t - entityLiving.field_70165_t));
        float f1 = (float)(entityliving1.field_70161_v - entityLiving.field_70161_v);
        float f2 = entityLiving.field_70177_z;
        if (f2 < 0.0f) {
            float f3 = ((float)MathHelper.func_76141_d((float)(MathHelper.func_76135_e((float)f2) / 360.0f)) + 1.0f) * 360.0f;
            f2 = f3 + f2;
        } else {
            while (f2 > 360.0f) {
                f2 -= 360.0f;
            }
        }
        float f4 = (float)(Math.atan2(f, f1) * 180.0 / Math.PI);
        if (f < 0.0f) {
            f4 = 360.0f + f4;
        }
        return FightEventHandler.compareAngles(f2, f4, 22.5f);
    }
}

