/*
 * Decompiled with CFR 0.152.
 */
package assets.levelup;

import assets.levelup.ClassBonus;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class PlayerExtendedProperties
implements IExtendedEntityProperties {
    private byte playerClass;
    private Map<String, Integer> skillMap = new HashMap<String, Integer>();
    private Map<String, int[]> counterMap = new HashMap<String, int[]>();
    public static final String[] counters = new String[]{"ore", "craft", "bonus"};

    public PlayerExtendedProperties() {
        for (String name : ClassBonus.skillNames) {
            this.skillMap.put(name, 0);
        }
        this.counterMap.put(counters[0], new int[]{0, 0, 0, 0});
        this.counterMap.put(counters[1], new int[]{0, 0, 0, 0});
        this.counterMap.put(counters[2], new int[]{0, 0, 0});
    }

    public void saveNBTData(NBTTagCompound compound) {
        compound.func_74774_a("Class", this.playerClass);
        for (String name : ClassBonus.skillNames) {
            compound.func_74768_a(name, this.skillMap.get(name).intValue());
        }
        for (String cat : counters) {
            compound.func_74783_a(cat, this.counterMap.get(cat));
        }
    }

    public void loadNBTData(NBTTagCompound compound) {
        this.playerClass = compound.func_74771_c("Class");
        for (String name : ClassBonus.skillNames) {
            this.skillMap.put(name, compound.func_74762_e(name));
        }
        for (String cat : counters) {
            this.counterMap.put(cat, compound.func_74759_k(cat));
        }
    }

    public void init(Entity entity, World world) {
    }

    public static Map<String, Integer> getSkillMap(EntityPlayer player) {
        return ((PlayerExtendedProperties)player.getExtendedProperties((String)"LevelUpSkills")).skillMap;
    }

    public static int getSkillFromIndex(EntityPlayer player, String name) {
        return PlayerExtendedProperties.getSkillMap(player).get(name);
    }

    public static int getSkillFromIndex(EntityPlayer player, int id) {
        return PlayerExtendedProperties.getSkillFromIndex(player, ClassBonus.skillNames[id]);
    }

    public static int getSkillPoints(EntityPlayer player) {
        int total = 0;
        for (String skill : ClassBonus.skillNames) {
            total += PlayerExtendedProperties.getSkillFromIndex(player, skill);
        }
        return total;
    }

    public static byte getPlayerClass(EntityPlayer player) {
        return ((PlayerExtendedProperties)player.getExtendedProperties((String)"LevelUpSkills")).playerClass;
    }

    public static void setPlayerClass(EntityPlayer player, byte newClass) {
        if (newClass != PlayerExtendedProperties.getPlayerClass(player)) {
            ClassBonus.applyBonus(player, PlayerExtendedProperties.getPlayerClass(player), newClass);
            PlayerExtendedProperties.capSkills(player);
            ((PlayerExtendedProperties)player.getExtendedProperties((String)"LevelUpSkills")).playerClass = newClass;
        }
    }

    public static Map<String, int[]> getCounterMap(EntityPlayer player) {
        return ((PlayerExtendedProperties)player.getExtendedProperties((String)"LevelUpSkills")).counterMap;
    }

    public static int[] getCounterByName(EntityPlayer player, String name) {
        return PlayerExtendedProperties.getCounterMap(player).get(name);
    }

    public static void capSkills(EntityPlayer player) {
        for (String name : ClassBonus.skillNames) {
            if (name.equals("XP")) break;
            int j = PlayerExtendedProperties.getSkillFromIndex(player, name);
            if (j <= 50) continue;
            PlayerExtendedProperties.getSkillMap(player).put(name, 50);
        }
    }

    public static void resetSkills(EntityPlayer player) {
        for (String name : ClassBonus.skillNames) {
            if (name.equals("XP")) break;
            PlayerExtendedProperties.getSkillMap(player).put(name, 0);
        }
    }

    public static void setPlayerData(EntityPlayer player, int[] data) {
        PlayerExtendedProperties.setPlayerClass(player, (byte)data[data.length - 1]);
        for (int i = 0; i < ClassBonus.skillNames.length; ++i) {
            PlayerExtendedProperties.getSkillMap(player).put(ClassBonus.skillNames[i], data[i]);
        }
    }

    public static int[] getPlayerData(EntityPlayer player, boolean withClass) {
        int[] data = new int[ClassBonus.skillNames.length + (withClass ? 1 : 0)];
        for (int i = 0; i < ClassBonus.skillNames.length; ++i) {
            data[i] = PlayerExtendedProperties.getSkillFromIndex(player, i);
        }
        if (withClass) {
            data[data.length - 1] = PlayerExtendedProperties.getPlayerClass(player);
        }
        return data;
    }
}

