/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.network;

import buildcraft.builders.TileArchitect;
import buildcraft.builders.TileBlueprintLibrary;
import buildcraft.builders.network.PacketLibraryAction;
import buildcraft.core.network.BuildCraftChannelHandler;
import buildcraft.core.network.BuildCraftPacket;
import buildcraft.core.network.PacketPayloadArrays;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.utils.Utils;
import cpw.mods.fml.common.network.NetworkRegistry;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetHandler;
import net.minecraft.tileentity.TileEntity;

public class PacketHandlerBuilders
extends BuildCraftChannelHandler {
    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf data, BuildCraftPacket packet) {
        super.decodeInto(ctx, data, packet);
        try {
            INetHandler netHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
            EntityPlayer player = Utils.getPlayerFromNetHandler(netHandler);
            int packetID = packet.getID();
            switch (packetID) {
                case 60: {
                    this.onArchitectName(player, (PacketUpdate)packet);
                    break;
                }
                case 61: {
                    this.onLibraryAction(player, (PacketLibraryAction)packet);
                    break;
                }
                case 62: {
                    this.onLibrarySelect(player, (PacketLibraryAction)packet);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void onArchitectName(EntityPlayer player, PacketUpdate packet) {
        TileEntity te = player.field_70170_p.func_147438_o(packet.posX, packet.posY, packet.posZ);
        if (te instanceof TileArchitect) {
            ((TileArchitect)te).handleClientInput((char)((PacketPayloadArrays)packet.payload).intPayload[0]);
        }
    }

    private void onLibraryAction(EntityPlayer player, PacketLibraryAction packet) {
        TileEntity te = player.field_70170_p.func_147438_o(packet.posX, packet.posY, packet.posZ);
        if (te instanceof TileBlueprintLibrary) {
            TileBlueprintLibrary tbl = (TileBlueprintLibrary)te;
            switch (packet.actionId) {
                case 4: {
                    tbl.deleteSelectedBpt();
                    break;
                }
                case 3: {
                    tbl.locked = !tbl.locked;
                    tbl.sendNetworkUpdate();
                    break;
                }
                case 1: {
                    tbl.setCurrentPage(true);
                    break;
                }
                case 2: {
                    tbl.setCurrentPage(false);
                }
            }
        }
    }

    private void onLibrarySelect(EntityPlayer player, PacketLibraryAction packet) {
        TileEntity te = player.field_70170_p.func_147438_o(packet.posX, packet.posY, packet.posZ);
        if (te instanceof TileBlueprintLibrary) {
            int ySlot = packet.actionId;
            TileBlueprintLibrary tbl = (TileBlueprintLibrary)te;
            if (ySlot < tbl.getCurrentPage().size()) {
                tbl.selected = ySlot;
            }
            tbl.sendNetworkUpdate();
        }
    }
}

