/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.inventory;

import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class StackHelper {
    private static StackHelper instance;

    public static StackHelper instance() {
        if (instance == null) {
            instance = new StackHelper();
        }
        return instance;
    }

    public static void setInstance(StackHelper inst) {
        instance = inst;
    }

    protected StackHelper() {
    }

    public boolean canStacksMerge(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        if (!stack1.func_77969_a(stack2)) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public int mergeStacks(ItemStack mergeSource, ItemStack mergeTarget, boolean doMerge) {
        if (!this.canStacksMerge(mergeSource, mergeTarget)) {
            return 0;
        }
        int mergeCount = Math.min(mergeTarget.func_77976_d() - mergeTarget.field_77994_a, mergeSource.field_77994_a);
        if (mergeCount < 1) {
            return 0;
        }
        if (doMerge) {
            mergeTarget.field_77994_a += mergeCount;
        }
        return mergeCount;
    }

    public boolean isCraftingEquivalent(ItemStack base, ItemStack comparison, boolean oreDictionary) {
        int idBase;
        if (this.isMatchingItem(base, comparison, true, false)) {
            return true;
        }
        if (oreDictionary && (idBase = OreDictionary.getOreID((ItemStack)base)) >= 0) {
            for (ItemStack itemstack : OreDictionary.getOres((Integer)idBase)) {
                if (comparison.func_77973_b() != itemstack.func_77973_b() || itemstack.func_77960_j() != Short.MAX_VALUE && comparison.func_77960_j() != itemstack.func_77960_j()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isCraftingEquivalent(int oreID, ItemStack comparison) {
        if (oreID >= 0) {
            for (ItemStack itemstack : OreDictionary.getOres((Integer)oreID)) {
                if (comparison.func_77973_b() != itemstack.func_77973_b() || itemstack.func_77960_j() != Short.MAX_VALUE && comparison.func_77960_j() != itemstack.func_77960_j()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isMatchingItem(ItemStack base, ItemStack comparison) {
        return this.isMatchingItem(base, comparison, true, true);
    }

    public boolean isMatchingItem(ItemStack a, ItemStack b, boolean matchDamage, boolean matchNBT) {
        if (a == null || b == null) {
            return false;
        }
        if (a.func_77973_b() != b.func_77973_b()) {
            return false;
        }
        if (matchDamage && a.func_77981_g() && !this.isWildcard(a) && !this.isWildcard(b) && a.func_77960_j() != b.func_77960_j()) {
            return false;
        }
        return !matchNBT || a.field_77990_d == null || a.field_77990_d.equals((Object)b.field_77990_d);
    }

    public boolean isWildcard(ItemStack stack) {
        return this.isWildcard(stack.func_77960_j());
    }

    public boolean isWildcard(int damage) {
        return damage == -1 || damage == Short.MAX_VALUE;
    }
}

