/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.triggers;

import buildcraft.api.gates.ITileTrigger;
import buildcraft.api.gates.ITriggerParameter;
import buildcraft.core.inventory.InventoryIterator;
import buildcraft.core.inventory.StackHelper;
import buildcraft.core.triggers.BCTrigger;
import buildcraft.core.utils.StringUtils;
import java.util.Locale;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TriggerInventoryLevel
extends BCTrigger
implements ITileTrigger {
    public TriggerType type;

    public TriggerInventoryLevel(TriggerType type) {
        super("buildcraft:inventorylevel." + type.name().toLowerCase(Locale.ENGLISH), "buildcraft.inventorylevel." + type.name().toLowerCase(Locale.ENGLISH), "buildcraft.filteredBuffer." + type.name().toLowerCase(Locale.ENGLISH));
        this.type = type;
    }

    @Override
    public boolean hasParameter() {
        return true;
    }

    @Override
    public boolean requiresParameter() {
        return true;
    }

    @Override
    public String getDescription() {
        return String.format(StringUtils.localize("gate.trigger.inventorylevel.below"), (int)(this.type.level * 100.0f));
    }

    @Override
    public boolean isTriggerActive(ForgeDirection side, TileEntity tile, ITriggerParameter parameter) {
        if (parameter == null) {
            return false;
        }
        if (tile instanceof IInventory) {
            ItemStack searchStack = parameter.getItemStack();
            int stackSpace = 0;
            int foundItems = 0;
            for (InventoryIterator.IInvSlot slot : InventoryIterator.getIterable((IInventory)tile, side)) {
                ItemStack stackInSlot;
                if (!slot.canPutStackInSlot(searchStack) || (stackInSlot = slot.getStackInSlot()) != null && !StackHelper.instance().canStacksMerge(stackInSlot, searchStack)) continue;
                ++stackSpace;
                foundItems += stackInSlot == null ? 0 : stackInSlot.field_77994_a;
            }
            if (stackSpace > 0) {
                float percentage = (float)foundItems / ((float)stackSpace * (float)searchStack.func_77976_d());
                return percentage < this.type.level;
            }
        }
        return false;
    }

    @Override
    public int getIconIndex() {
        switch (this.type) {
            case BELOW_25: {
                return 33;
            }
            case BELOW_50: {
                return 34;
            }
        }
        return 35;
    }

    public static enum TriggerType {
        BELOW_25(0.25f),
        BELOW_50(0.5f),
        BELOW_75(0.75f);

        public final float level;

        private TriggerType(float level) {
            this.level = level;
        }
    }
}

