/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.triggers;

import buildcraft.api.gates.ITriggerParameter;
import buildcraft.core.triggers.BCTrigger;
import buildcraft.core.utils.StringUtils;
import buildcraft.transport.IPipeTrigger;
import buildcraft.transport.Pipe;

public class TriggerRedstoneInput
extends BCTrigger
implements IPipeTrigger {
    boolean active;

    public TriggerRedstoneInput(boolean active) {
        super("buildcraft:redstone.input." + (active ? "active" : "inactive"), active ? "buildcraft.redtone.input.active" : "buildcraft.redtone.input.inactive");
        this.active = active;
    }

    @Override
    public String getDescription() {
        return StringUtils.localize("gate.trigger.redstone.input." + (this.active ? "active" : "inactive"));
    }

    @Override
    public boolean isTriggerActive(Pipe pipe, ITriggerParameter parameter) {
        if (this.active) {
            return this.isBeingPowered(pipe);
        }
        return !this.isBeingPowered(pipe);
    }

    private boolean isBeingPowered(Pipe pipe) {
        return pipe.container.redstoneInput > 0;
    }

    @Override
    public int getIconIndex() {
        return this.active ? 29 : 30;
    }
}

