/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.utils;

import buildcraft.core.utils.BCLog;
import java.util.logging.Level;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ConfigUtils {
    private static final String COMMENT_PREFIX = "";
    private static final String COMMENT_SUFFIX = "";
    private final Configuration config;
    private final String cat;

    public ConfigUtils(Configuration config, String cat) {
        this.config = config;
        this.cat = cat;
    }

    public boolean get(String tag, boolean defaultValue, String comment) {
        return this.get(tag, defaultValue, false, comment);
    }

    public boolean get(String tag, boolean defaultValue, boolean reset, String comment) {
        comment = "" + comment.replace("{t}", tag) + "";
        Property prop = this.config.get(this.cat, tag, defaultValue);
        prop.comment = comment;
        boolean ret = this.parseBoolean(prop, defaultValue);
        if (reset) {
            prop.set(defaultValue);
        }
        return ret;
    }

    public int get(String tag, int defaultValue, String comment) {
        comment = "" + comment.replace("{t}", tag) + "";
        Property prop = this.config.get(this.cat, tag, defaultValue);
        prop.comment = comment;
        return this.parseInteger(prop, defaultValue);
    }

    public int get(String tag, int min, int defaultValue, int max, String comment) {
        comment = "" + comment.replace("{t}", tag) + "";
        Property prop = this.config.get(this.cat, tag, defaultValue);
        prop.comment = comment;
        int parsed = this.parseInteger(prop, defaultValue);
        int clamped = Math.max(parsed, min);
        if ((clamped = Math.min(clamped, max)) != parsed) {
            prop.set(clamped);
        }
        return clamped;
    }

    public float get(String tag, float min, float defaultValue, float max, String comment) {
        comment = "" + comment.replace("{t}", tag) + "";
        Property prop = this.config.get(this.cat, tag, (double)defaultValue);
        prop.comment = comment;
        double parsed = this.parseDouble(prop, defaultValue);
        double clamped = Math.max(parsed, (double)min);
        if ((clamped = Math.min(clamped, (double)max)) != parsed) {
            prop.set(clamped);
        }
        return (float)clamped;
    }

    private boolean parseBoolean(Property prop, boolean defaultValue) {
        boolean parsed;
        String value = prop.getString();
        try {
            parsed = Boolean.parseBoolean(value);
        }
        catch (NumberFormatException ex) {
            BCLog.logger.log(Level.WARNING, "Failed to parse config tag, reseting to default: " + prop.getName(), ex);
            prop.set(defaultValue);
            return defaultValue;
        }
        return parsed;
    }

    private int parseInteger(Property prop, int defaultValue) {
        int parsed;
        String value = prop.getString();
        try {
            parsed = Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            BCLog.logger.log(Level.WARNING, "Failed to parse config tag, reseting to default: " + prop.getName(), ex);
            prop.set(defaultValue);
            return defaultValue;
        }
        return parsed;
    }

    private double parseDouble(Property prop, double defaultValue) {
        double parsed;
        String value = prop.getString();
        try {
            parsed = Double.parseDouble(value);
        }
        catch (NumberFormatException ex) {
            BCLog.logger.log(Level.WARNING, "Failed to parse config tag, reseting to default: " + prop.getName(), ex);
            prop.set(defaultValue);
            return defaultValue;
        }
        return parsed;
    }
}

