/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftFactory;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.gates.IAction;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import buildcraft.core.BlockIndex;
import buildcraft.core.EntityBlock;
import buildcraft.core.IMachine;
import buildcraft.core.TileBuffer;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.fluids.FluidUtils;
import buildcraft.core.fluids.SingleUseTank;
import buildcraft.core.network.PacketPayload;
import buildcraft.core.network.PacketPayloadStream;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.BlockUtil;
import buildcraft.core.utils.Utils;
import buildcraft.factory.FactoryProxy;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TilePump
extends TileBuildCraft
implements IMachine,
IPowerReceptor,
IFluidHandler {
    public static final int REBUID_DELAY = 512;
    public static int MAX_LIQUID = 16000;
    EntityBlock tube;
    private TreeMap<Integer, Deque<BlockIndex>> pumpLayerQueues = new TreeMap();
    SingleUseTank tank = new SingleUseTank("tank", MAX_LIQUID, this);
    double tubeY = Double.NaN;
    int aimY = 0;
    private PowerHandler powerHandler;
    private TileBuffer[] tileBuffer = null;
    private SafeTimeTracker timer = new SafeTimeTracker(512L);
    private int tick = Utils.RANDOM.nextInt();
    private int numFluidBlocksFound = 0;
    private boolean powered = false;

    public TilePump() {
        this.powerHandler = new PowerHandler(this, PowerHandler.Type.MACHINE);
        this.initPowerProvider();
    }

    private void initPowerProvider() {
        this.powerHandler.configure(1.0, 15.0, 10.0, 100.0);
        this.powerHandler.configurePowerPerdition(1, 100);
    }

    @Override
    public void func_145845_h() {
        FluidStack fluidToPump;
        super.func_145845_h();
        if (this.powered) {
            this.pumpLayerQueues.clear();
            this.destroyTube();
        } else {
            this.createTube();
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.pushToConsumers();
        if (this.powered) {
            return;
        }
        if (this.tube == null) {
            return;
        }
        if (this.tube.field_70163_u - (double)this.aimY > 0.01) {
            this.tubeY = this.tube.field_70163_u - 0.01;
            this.setTubePosition();
            this.sendNetworkUpdate();
            return;
        }
        ++this.tick;
        if (this.tick % 16 != 0) {
            return;
        }
        BlockIndex index = this.getNextIndexToPump(false);
        FluidStack fluidStack = fluidToPump = index != null ? BlockUtil.drainBlock(this.field_145850_b, index.x, index.y, index.z, false) : null;
        if (fluidToPump != null) {
            if (this.isFluidAllowed(fluidToPump.getFluid()) && this.tank.fill(fluidToPump, false) == fluidToPump.amount && this.powerHandler.useEnergy(10.0, 10.0, true) == 10.0) {
                if (fluidToPump.getFluid() != FluidRegistry.WATER || BuildCraftCore.consumeWaterSources || this.numFluidBlocksFound < 9) {
                    index = this.getNextIndexToPump(true);
                    BlockUtil.drainBlock(this.field_145850_b, index.x, index.y, index.z, true);
                }
                this.tank.fill(fluidToPump, true);
            }
        } else if (this.tick % 128 == 0) {
            this.rebuildQueue();
            if (this.getNextIndexToPump(false) == null) {
                for (int y = this.field_145848_d - 1; y > 0; --y) {
                    if (this.isPumpableFluid(this.field_145851_c, y, this.field_145849_e)) {
                        this.aimY = y;
                        return;
                    }
                    if (!this.isBlocked(this.field_145851_c, y, this.field_145849_e)) continue;
                    return;
                }
            }
        }
    }

    public void onNeighborBlockChange(Block block) {
        boolean p = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (this.powered != p) {
            this.powered = p;
            if (!this.field_145850_b.field_72995_K) {
                this.sendNetworkUpdate();
            }
        }
    }

    private boolean isBlocked(int x, int y, int z) {
        Material mat = this.field_145850_b.func_147439_a(x, y, z).func_149688_o();
        return mat.func_76230_c();
    }

    private void pushToConsumers() {
        if (this.tileBuffer == null) {
            this.tileBuffer = TileBuffer.makeBuffer(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
        }
        FluidUtils.pushFluidToConsumers((IFluidTank)this.tank, 400, this.tileBuffer);
    }

    private TileEntity getTile(ForgeDirection side) {
        if (this.tileBuffer == null) {
            this.tileBuffer = TileBuffer.makeBuffer(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
        }
        return this.tileBuffer[side.ordinal()].getTile();
    }

    private void createTube() {
        if (this.tube == null) {
            this.tube = FactoryProxy.proxy.newPumpTube(this.field_145850_b);
            this.tube.field_70163_u = !Double.isNaN(this.tubeY) ? this.tubeY : (double)this.field_145848_d;
            this.tubeY = this.tube.field_70163_u;
            if (this.aimY == 0) {
                this.aimY = this.field_145848_d;
            }
            this.setTubePosition();
            this.field_145850_b.func_72838_d((Entity)this.tube);
            if (!this.field_145850_b.field_72995_K) {
                this.sendNetworkUpdate();
            }
        }
    }

    private void destroyTube() {
        if (this.tube != null) {
            CoreProxy.proxy.removeEntity(this.tube);
            this.tube = null;
            this.tubeY = Double.NaN;
            this.aimY = 0;
        }
    }

    private BlockIndex getNextIndexToPump(boolean remove) {
        if (this.pumpLayerQueues.isEmpty()) {
            if (this.timer.markTimeIfDelay(this.field_145850_b)) {
                this.rebuildQueue();
            }
            return null;
        }
        Deque<BlockIndex> topLayer = this.pumpLayerQueues.lastEntry().getValue();
        if (topLayer != null) {
            if (topLayer.isEmpty()) {
                this.pumpLayerQueues.pollLastEntry();
            }
            if (remove) {
                BlockIndex index = topLayer.pollLast();
                return index;
            }
            return topLayer.peekLast();
        }
        return null;
    }

    private Deque<BlockIndex> getLayerQueue(int layer) {
        Deque<BlockIndex> pumpQueue = this.pumpLayerQueues.get(layer);
        if (pumpQueue == null) {
            pumpQueue = new LinkedList<BlockIndex>();
            this.pumpLayerQueues.put(layer, pumpQueue);
        }
        return pumpQueue;
    }

    public void rebuildQueue() {
        this.numFluidBlocksFound = 0;
        this.pumpLayerQueues.clear();
        int x = this.field_145851_c;
        int y = this.aimY;
        int z = this.field_145849_e;
        Fluid pumpingFluid = BlockUtil.getFluid(this.field_145850_b.func_147439_a(x, y, z));
        if (pumpingFluid == null) {
            return;
        }
        if (pumpingFluid != this.tank.getAcceptedFluid() && this.tank.getAcceptedFluid() != null) {
            return;
        }
        HashSet<BlockIndex> visitedBlocks = new HashSet<BlockIndex>();
        LinkedList<BlockIndex> fluidsFound = new LinkedList<BlockIndex>();
        this.queueForPumping(x, y, z, visitedBlocks, fluidsFound, pumpingFluid);
        while (!fluidsFound.isEmpty()) {
            LinkedList<BlockIndex> fluidsToExpand = fluidsFound;
            fluidsFound = new LinkedList();
            for (BlockIndex index : fluidsToExpand) {
                this.queueForPumping(index.x, index.y + 1, index.z, visitedBlocks, fluidsFound, pumpingFluid);
                this.queueForPumping(index.x + 1, index.y, index.z, visitedBlocks, fluidsFound, pumpingFluid);
                this.queueForPumping(index.x - 1, index.y, index.z, visitedBlocks, fluidsFound, pumpingFluid);
                this.queueForPumping(index.x, index.y, index.z + 1, visitedBlocks, fluidsFound, pumpingFluid);
                this.queueForPumping(index.x, index.y, index.z - 1, visitedBlocks, fluidsFound, pumpingFluid);
                if (pumpingFluid != FluidRegistry.WATER || BuildCraftCore.consumeWaterSources || this.numFluidBlocksFound < 9) continue;
                return;
            }
        }
    }

    public void queueForPumping(int x, int y, int z, Set<BlockIndex> visitedBlocks, Deque<BlockIndex> fluidsFound, Fluid pumpingFluid) {
        BlockIndex index = new BlockIndex(x, y, z);
        if (visitedBlocks.add(index)) {
            if ((x - this.field_145851_c) * (x - this.field_145851_c) + (z - this.field_145849_e) * (z - this.field_145849_e) > 4096) {
                return;
            }
            Block block = this.field_145850_b.func_147439_a(x, y, z);
            if (BlockUtil.getFluid(block) == pumpingFluid) {
                fluidsFound.add(index);
            }
            if (this.canDrainBlock(block, x, y, z, pumpingFluid)) {
                this.getLayerQueue(y).add(index);
                ++this.numFluidBlocksFound;
            }
        }
    }

    private boolean isPumpableFluid(int x, int y, int z) {
        Fluid fluid = BlockUtil.getFluid(this.field_145850_b.func_147439_a(x, y, z));
        if (fluid == null) {
            return false;
        }
        if (!this.isFluidAllowed(fluid)) {
            return false;
        }
        return this.tank.getAcceptedFluid() == null || this.tank.getAcceptedFluid() == fluid;
    }

    private boolean canDrainBlock(Block block, int x, int y, int z, Fluid fluid) {
        if (!this.isFluidAllowed(fluid)) {
            return false;
        }
        FluidStack fluidStack = BlockUtil.drainBlock(block, this.field_145850_b, x, y, z, false);
        if (fluidStack == null || fluidStack.amount <= 0) {
            return false;
        }
        return fluidStack.getFluid() == fluid;
    }

    private boolean isFluidAllowed(Fluid fluid) {
        return BuildCraftFactory.pumpDimensionList.isFluidAllowed(fluid, this.field_145850_b.field_73011_w.field_76574_g);
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.powerHandler.readFromNBT(data);
        this.tank.readFromNBT(data);
        this.powered = data.func_74767_n("powered");
        this.aimY = data.func_74762_e("aimY");
        this.tubeY = data.func_74760_g("tubeY");
        this.initPowerProvider();
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.powerHandler.writeToNBT(data);
        this.tank.writeToNBT(data);
        data.func_74757_a("powered", this.powered);
        data.func_74768_a("aimY", this.aimY);
        if (this.tube != null) {
            data.func_74776_a("tubeY", (float)this.tube.field_70163_u);
        } else {
            data.func_74776_a("tubeY", (float)this.field_145848_d);
        }
    }

    @Override
    public boolean isActive() {
        BlockIndex next = this.getNextIndexToPump(false);
        if (next != null) {
            return this.isPumpableFluid(next.x, next.y, next.z);
        }
        return false;
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return this.powerHandler.getPowerReceiver();
    }

    @Override
    public void doWork(PowerHandler workProvider) {
    }

    @Override
    public PacketPayload getPacketPayload() {
        PacketPayloadStream payload = new PacketPayloadStream(new PacketPayloadStream.StreamWriter(){

            @Override
            public void writeData(ByteBuf buf) {
                buf.writeInt(TilePump.this.aimY);
                buf.writeFloat((float)TilePump.this.tubeY);
                buf.writeBoolean(TilePump.this.powered);
            }
        });
        return payload;
    }

    @Override
    public void handleUpdatePacket(PacketUpdate packet) throws IOException {
        PacketPayloadStream payload = (PacketPayloadStream)packet.payload;
        ByteBuf data = payload.stream;
        this.aimY = data.readInt();
        this.tubeY = data.readFloat();
        this.powered = data.readBoolean();
        this.setTubePosition();
    }

    @Override
    public void handleDescriptionPacket(PacketUpdate packet) throws IOException {
        this.handleUpdatePacket(packet);
    }

    private void setTubePosition() {
        if (this.tube != null) {
            this.tube.iSize = 0.5;
            this.tube.kSize = 0.5;
            this.tube.jSize = (double)this.field_145848_d - this.tube.field_70163_u;
            this.tube.func_70107_b((float)this.field_145851_c + 0.25f, this.tubeY, (float)this.field_145849_e + 0.25f);
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.destroy();
    }

    public void func_145829_t() {
        this.tileBuffer = null;
        super.func_145829_t();
    }

    @Override
    public void destroy() {
        this.tileBuffer = null;
        this.pumpLayerQueues.clear();
        this.destroyTube();
    }

    @Override
    public boolean manageFluids() {
        return true;
    }

    @Override
    public boolean manageSolids() {
        return false;
    }

    @Override
    public boolean allowAction(IAction action) {
        return false;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        if (!resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }
}

