/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.Position;
import buildcraft.api.recipes.BuildcraftRecipes;
import buildcraft.core.CreativeTabBuildCraft;
import buildcraft.core.ItemBuildCraft;
import buildcraft.transport.TileGenericPipe;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemFacade
extends ItemBuildCraft {
    public static final LinkedList<ItemStack> allFacades = new LinkedList();
    private static final Block NULL_BLOCK = null;
    private static final ItemStack NO_MATCH = new ItemStack(NULL_BLOCK, 0, 0);

    public ItemFacade() {
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77637_a(CreativeTabBuildCraft.FACADES.get());
    }

    public String func_77667_c(ItemStack itemstack) {
        return "item.Facade";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        for (ItemStack stack : allFacades) {
            itemList.add(stack.func_77946_l());
        }
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World worldObj, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (worldObj.field_72995_K) {
            return false;
        }
        Position pos = new Position(x, y, z, ForgeDirection.getOrientation((int)side));
        pos.moveForwards(1.0);
        TileEntity tile = worldObj.func_147438_o((int)pos.x, (int)pos.y, (int)pos.z);
        if (!(tile instanceof TileGenericPipe)) {
            return false;
        }
        TileGenericPipe pipeTile = (TileGenericPipe)tile;
        if (pipeTile.addFacade(ForgeDirection.getOrientation((int)side).getOpposite(), ItemFacade.getBlock(stack), ItemFacade.getMetaData(stack))) {
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            return true;
        }
        return false;
    }

    public static void initialize() {
        for (Object o : Block.field_149771_c) {
            Item item;
            Block b = (Block)o;
            if (b != Blocks.field_150359_w && (b == Blocks.field_150357_h || b == Blocks.field_150349_c || b == Blocks.field_150362_t || b == Blocks.field_150360_v || b == Blocks.field_150486_ae || b == Blocks.field_150379_bu || b == Blocks.field_150374_bv || b == Blocks.field_150428_aP || !b.func_149662_c() || b.hasTileEntity(0) || !b.func_149686_d() || b.func_149645_b() != 0) || (item = Item.func_150898_a((Block)b)) == null) continue;
            ItemStack base = new ItemStack(item, 1);
            if (base.func_77981_g()) {
                HashSet names = Sets.newHashSet();
                for (int meta = 0; meta <= 15; ++meta) {
                    ItemStack is = new ItemStack(item, 1, meta);
                    if (Strings.isNullOrEmpty((String)is.func_77977_a()) || !names.add(is.func_77977_a())) continue;
                    ItemFacade.addFacade(is);
                }
                continue;
            }
            ItemFacade.addFacade(base);
        }
    }

    public static int getMetaData(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("meta")) {
            return stack.func_77978_p().func_74762_e("meta");
        }
        return stack.func_77960_j() & 0xF;
    }

    public static Block getBlock(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("id")) {
            return (Block)Block.field_149771_c.func_148754_a(stack.func_77978_p().func_74762_e("id"));
        }
        return (Block)Block.field_149771_c.func_148754_a((stack.func_77960_j() & 0xFFF0) >>> 4);
    }

    @Override
    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return true;
    }

    public static void addFacade(ItemStack itemStack) {
        ItemStack facade = ItemFacade.getStack(Block.func_149634_a((Item)itemStack.func_77973_b()), itemStack.func_77960_j());
        allFacades.add(facade);
        ItemStack facade6 = facade.func_77946_l();
        facade6.field_77994_a = 6;
        BuildcraftRecipes.assemblyTable.addRecipe(8000.0, facade6, new ItemStack(BuildCraftTransport.pipeStructureCobblestone, 3), itemStack);
        Block bl = Block.func_149634_a((Item)itemStack.func_77973_b());
        if (bl != null && bl.func_149645_b() == 31) {
            ItemStack rotLog1 = ItemFacade.getStack(Block.func_149634_a((Item)itemStack.func_77973_b()), itemStack.func_77960_j() | 4);
            ItemStack rotLog2 = ItemFacade.getStack(Block.func_149634_a((Item)itemStack.func_77973_b()), itemStack.func_77960_j() | 8);
            allFacades.add(rotLog1);
            allFacades.add(rotLog2);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
    }

    @SideOnly(value=Side.CLIENT)
    public int func_94901_k() {
        return 0;
    }

    public static ItemStack getStack(Block block, int metadata) {
        ItemStack stack = new ItemStack((Item)BuildCraftTransport.facadeItem, 1, 0);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("meta", metadata);
        nbt.func_74768_a("id", Block.field_149771_c.func_148757_b((Object)block));
        stack.func_77982_d(nbt);
        return stack;
    }

    public class FacadeRecipe
    implements IRecipe {
        public boolean func_77569_a(InventoryCrafting inventorycrafting, World world) {
            ItemStack slotmatch = null;
            for (int i = 0; i < inventorycrafting.func_70302_i_(); ++i) {
                ItemStack slot = inventorycrafting.func_70301_a(i);
                if (slot != null && slot.func_77973_b() == ItemFacade.this && slotmatch == null) {
                    slotmatch = slot;
                    continue;
                }
                if (slot == null) continue;
                slotmatch = NO_MATCH;
            }
            if (slotmatch != null && slotmatch != NO_MATCH) {
                Block block = ItemFacade.getBlock(slotmatch);
                return block != null && block.func_149645_b() == 31;
            }
            return false;
        }

        public ItemStack func_77572_b(InventoryCrafting inventorycrafting) {
            ItemStack slotmatch = null;
            for (int i = 0; i < inventorycrafting.func_70302_i_(); ++i) {
                ItemStack slot = inventorycrafting.func_70301_a(i);
                if (slot != null && slot.func_77973_b() == ItemFacade.this && slotmatch == null) {
                    slotmatch = slot;
                    continue;
                }
                if (slot == null) continue;
                slotmatch = NO_MATCH;
            }
            if (slotmatch != null && slotmatch != NO_MATCH) {
                Block block = ItemFacade.getBlock(slotmatch);
                int blockMeta = ItemFacade.getMetaData(slotmatch);
                if (block != null && block.func_149645_b() == 31 && (blockMeta & 0xC) == 0) {
                    return ItemFacade.getStack(block, blockMeta & 3 | 4);
                }
                if (block != null && block.func_149645_b() == 31 && (blockMeta & 8) == 0) {
                    return ItemFacade.getStack(block, blockMeta & 3 | 8);
                }
                if (block != null && block.func_149645_b() == 31 && (blockMeta & 4) == 0) {
                    return ItemFacade.getStack(block, blockMeta & 3);
                }
            }
            return null;
        }

        public int func_77570_a() {
            return 1;
        }

        public ItemStack func_77571_b() {
            return null;
        }
    }
}

