/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.Position;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.inventory.ISpecialInventory;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.DefaultProps;
import buildcraft.core.IMachine;
import buildcraft.core.inventory.Transactor;
import buildcraft.core.utils.BCLog;
import buildcraft.core.utils.BlockUtil;
import buildcraft.core.utils.MathUtils;
import buildcraft.core.utils.Utils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.IItemTravelingHook;
import buildcraft.transport.IPipeTransportItemsHook;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.TravelerSet;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.network.PacketPipeTransportItemStackRequest;
import buildcraft.transport.network.PacketPipeTransportTraveler;
import buildcraft.transport.pipes.events.PipeEventItem;
import buildcraft.transport.utils.TransportUtils;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeTransportItems
extends PipeTransport {
    public static final int MAX_PIPE_STACKS = 64;
    public static final int MAX_PIPE_ITEMS = 1024;
    public boolean allowBouncing = false;
    public IItemTravelingHook travelHook;
    public final TravelerSet items = new TravelerSet(this);

    @Override
    public IPipeTile.PipeType getPipeType() {
        return IPipeTile.PipeType.ITEM;
    }

    public void readjustSpeed(TravelingItem item) {
        if (this.container.pipe instanceof IPipeTransportItemsHook) {
            ((IPipeTransportItemsHook)((Object)this.container.pipe)).readjustSpeed(item);
            return;
        }
        PipeEventItem.AdjustSpeed event = new PipeEventItem.AdjustSpeed(item);
        this.container.pipe.handlePipeEvent(event);
        if (!event.handled) {
            this.defaultReajustSpeed(item);
        }
    }

    public void defaultReajustSpeed(TravelingItem item) {
        float speed = item.getSpeed();
        if (speed > 0.01f) {
            speed -= 0.01f;
        }
        if (speed < 0.01f) {
            speed = 0.01f;
        }
        item.setSpeed(speed);
    }

    private void readjustPosition(TravelingItem item) {
        double x = MathUtils.clamp(item.xCoord, (double)this.container.field_145851_c + 0.01, (double)this.container.field_145851_c + 0.99);
        double y = MathUtils.clamp(item.yCoord, (double)this.container.field_145848_d + 0.01, (double)this.container.field_145848_d + 0.99);
        double z = MathUtils.clamp(item.zCoord, (double)this.container.field_145849_e + 0.01, (double)this.container.field_145849_e + 0.99);
        if (item.input != ForgeDirection.UP && item.input != ForgeDirection.DOWN) {
            y = (float)this.container.field_145848_d + TransportUtils.getPipeFloorOf(item.getItemStack());
        }
        item.setPosition(x, y, z);
    }

    public void injectItem(TravelingItem item, ForgeDirection inputOrientation) {
        if (item.isCorrupted()) {
            return;
        }
        item.reset();
        item.input = inputOrientation;
        this.readjustSpeed(item);
        this.readjustPosition(item);
        if (!this.container.func_145831_w().field_72995_K) {
            item.output = this.resolveDestination(item);
        }
        if (this.container.pipe instanceof IPipeTransportItemsHook) {
            ((IPipeTransportItemsHook)((Object)this.container.pipe)).entityEntered(item, inputOrientation);
        }
        PipeEventItem.Entered event = new PipeEventItem.Entered(item);
        this.container.pipe.handlePipeEvent(event);
        if (event.cancelled) {
            return;
        }
        this.items.add(item);
        if (!this.container.func_145831_w().field_72995_K) {
            this.sendTravelerPacket(item, false);
            if (this.items.size() > BuildCraftTransport.groupItemsTrigger) {
                this.groupEntities();
            }
            if (this.items.size() > 64) {
                BCLog.logger.log(Level.WARNING, String.format("Pipe exploded at %d,%d,%d because it had too many stacks: %d", this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e, this.items.size()));
                this.destroyPipe();
                return;
            }
            int numItems = 0;
            Iterator<TravelingItem> i$ = this.items.iterator();
            while (i$.hasNext()) {
                TravelingItem travellingItem = i$.next();
                ItemStack stack = travellingItem.getItemStack();
                if (stack == null || stack.field_77994_a <= 0) continue;
                numItems += stack.field_77994_a;
            }
            if (numItems > 1024) {
                BCLog.logger.log(Level.WARNING, String.format("Pipe exploded at %d,%d,%d because it had too many items: %d", this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e, numItems));
                this.destroyPipe();
            }
        }
    }

    private void destroyPipe() {
        BlockUtil.explodeBlock(this.container.func_145831_w(), this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e);
        this.container.func_145831_w().func_147468_f(this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e);
    }

    protected void reverseItem(TravelingItem item) {
        if (item.isCorrupted()) {
            return;
        }
        item.toCenter = true;
        item.input = item.output.getOpposite();
        this.readjustSpeed(item);
        this.readjustPosition(item);
        if (!this.container.func_145831_w().field_72995_K) {
            item.output = this.resolveDestination(item);
        }
        if (this.container.pipe instanceof IPipeTransportItemsHook) {
            ((IPipeTransportItemsHook)((Object)this.container.pipe)).entityEntered(item, item.input);
        }
        PipeEventItem.Entered event = new PipeEventItem.Entered(item);
        this.container.pipe.handlePipeEvent(event);
        if (event.cancelled) {
            return;
        }
        this.items.unscheduleRemoval(item);
        if (!this.container.func_145831_w().field_72995_K) {
            this.sendTravelerPacket(item, true);
        }
    }

    public ForgeDirection resolveDestination(TravelingItem data) {
        List<ForgeDirection> validDestinations = this.getPossibleMovements(data);
        if (validDestinations.isEmpty()) {
            return ForgeDirection.UNKNOWN;
        }
        return validDestinations.get(0);
    }

    public List<ForgeDirection> getPossibleMovements(TravelingItem item) {
        LinkedList<ForgeDirection> result = new LinkedList<ForgeDirection>();
        item.blacklist.add(item.input.getOpposite());
        EnumSet<ForgeDirection> sides = EnumSet.complementOf(item.blacklist);
        sides.remove(ForgeDirection.UNKNOWN);
        for (ForgeDirection o : sides) {
            if (!this.container.pipe.outputOpen(o) || !this.canReceivePipeObjects(o, item)) continue;
            result.add(o);
        }
        if (this.container.pipe instanceof IPipeTransportItemsHook) {
            Position pos = new Position(this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e, item.input);
            result = ((IPipeTransportItemsHook)((Object)this.container.pipe)).filterPossibleMovements(result, pos, item);
        }
        PipeEventItem.FindDest event = new PipeEventItem.FindDest(item, result);
        this.container.pipe.handlePipeEvent(event);
        if (this.allowBouncing && result.isEmpty() && this.canReceivePipeObjects(item.input.getOpposite(), item)) {
            result.add(item.input.getOpposite());
        }
        Collections.shuffle(result);
        return result;
    }

    public boolean canReceivePipeObjects(ForgeDirection o, TravelingItem item) {
        TileEntity entity = this.container.getTile(o);
        if (!this.container.isPipeConnected(o)) {
            return false;
        }
        if (entity instanceof TileGenericPipe) {
            TileGenericPipe pipe = (TileGenericPipe)entity;
            return pipe.pipe.transport instanceof PipeTransportItems;
        }
        return entity instanceof IInventory && item.getInsertionHandler().canInsertItem(item, (IInventory)entity) && Transactor.getTransactorFor((Object)entity).add((ItemStack)item.getItemStack(), (ForgeDirection)o.getOpposite(), (boolean)false).field_77994_a > 0;
    }

    @Override
    public void updateEntity() {
        this.moveSolids();
    }

    private void moveSolids() {
        this.items.flush();
        if (!this.container.func_145831_w().field_72995_K) {
            this.items.purgeCorruptedItems();
        }
        this.items.iterating = true;
        Iterator<TravelingItem> i$ = this.items.iterator();
        while (i$.hasNext()) {
            boolean handleItem;
            TravelingItem item = i$.next();
            if (item.getContainer() != this.container) {
                this.items.scheduleRemoval(item);
                continue;
            }
            Position motion = new Position(0.0, 0.0, 0.0, item.toCenter ? item.input : item.output);
            motion.moveForwards(item.getSpeed());
            item.movePosition(motion.x, motion.y, motion.z);
            if (item.toCenter && this.middleReached(item) || this.outOfBounds(item)) {
                item.toCenter = false;
                item.setPosition((double)this.container.field_145851_c + 0.5, (float)this.container.field_145848_d + TransportUtils.getPipeFloorOf(item.getItemStack()), (double)this.container.field_145849_e + 0.5);
                if (item.output == ForgeDirection.UNKNOWN) {
                    if (!this.items.scheduleRemoval(item)) continue;
                    this.dropItem(item);
                    continue;
                }
                if (this.travelHook != null) {
                    this.travelHook.centerReached(this, item);
                }
                PipeEventItem.ReachedCenter event = new PipeEventItem.ReachedCenter(item);
                this.container.pipe.handlePipeEvent(event);
                continue;
            }
            if (item.toCenter || !this.endReached(item)) continue;
            TileEntity tile = this.container.getTile(item.output);
            PipeEventItem.ReachedEnd event = new PipeEventItem.ReachedEnd(item, tile);
            this.container.pipe.handlePipeEvent(event);
            boolean bl = handleItem = !event.handled;
            if (this.travelHook != null) {
                boolean bl2 = handleItem = !this.travelHook.endReached(this, item, tile);
            }
            if (!handleItem || !this.items.scheduleRemoval(item)) continue;
            this.handleTileReached(item, tile);
        }
        this.items.iterating = false;
        this.items.flush();
    }

    private boolean passToNextPipe(TravelingItem item, TileEntity tile) {
        if (tile instanceof TileGenericPipe) {
            TileGenericPipe pipe = (TileGenericPipe)tile;
            if (BlockGenericPipe.isValid(pipe.pipe) && pipe.pipe.transport instanceof PipeTransportItems) {
                ((PipeTransportItems)pipe.pipe.transport).injectItem(item, item.output);
                return true;
            }
        }
        return false;
    }

    private void handleTileReached(TravelingItem item, TileEntity tile) {
        if (!this.passToNextPipe(item, tile)) {
            if (tile instanceof IInventory) {
                if (!this.container.func_145831_w().field_72995_K) {
                    if (item.getInsertionHandler().canInsertItem(item, (IInventory)tile)) {
                        ItemStack added = Transactor.getTransactorFor(tile).add(item.getItemStack(), item.output.getOpposite(), true);
                        item.getItemStack().field_77994_a -= added.field_77994_a;
                    }
                    if (item.getItemStack().field_77994_a > 0) {
                        this.reverseItem(item);
                    }
                }
            } else {
                this.dropItem(item);
            }
        }
    }

    private void dropItem(TravelingItem item) {
        if (this.container.func_145831_w().field_72995_K) {
            return;
        }
        if (this.travelHook != null) {
            this.travelHook.drop(this, item);
        }
        PipeEventItem.DropItem event = new PipeEventItem.DropItem(item, item.toEntityItem());
        this.container.pipe.handlePipeEvent(event);
        if (event.entity == null) {
            return;
        }
        this.container.func_145831_w().func_72838_d((Entity)event.entity);
    }

    protected boolean middleReached(TravelingItem item) {
        float middleLimit = item.getSpeed() * 1.01f;
        return Math.abs((double)this.container.field_145851_c + 0.5 - item.xCoord) < (double)middleLimit && Math.abs((double)((float)this.container.field_145848_d + TransportUtils.getPipeFloorOf(item.getItemStack())) - item.yCoord) < (double)middleLimit && Math.abs((double)this.container.field_145849_e + 0.5 - item.zCoord) < (double)middleLimit;
    }

    protected boolean endReached(TravelingItem item) {
        return item.xCoord > (double)(this.container.field_145851_c + 1) || item.xCoord < (double)this.container.field_145851_c || item.yCoord > (double)(this.container.field_145848_d + 1) || item.yCoord < (double)this.container.field_145848_d || item.zCoord > (double)(this.container.field_145849_e + 1) || item.zCoord < (double)this.container.field_145849_e;
    }

    protected boolean outOfBounds(TravelingItem item) {
        return item.xCoord > (double)(this.container.field_145851_c + 2) || item.xCoord < (double)(this.container.field_145851_c - 1) || item.yCoord > (double)(this.container.field_145848_d + 2) || item.yCoord < (double)(this.container.field_145848_d - 1) || item.zCoord > (double)(this.container.field_145849_e + 2) || item.zCoord < (double)(this.container.field_145849_e - 1);
    }

    public Position getPosition() {
        return new Position(this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        NBTTagList nbttaglist = nbt.func_150295_c("travelingEntities", Utils.NBTTag_Types.NBTTagCompound.ordinal());
        for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
            try {
                NBTTagCompound dataTag = nbttaglist.func_150305_b(j);
                TravelingItem item = TravelingItem.make(dataTag);
                if (item.isCorrupted()) continue;
                this.items.scheduleLoad(item);
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        NBTTagList nbttaglist = new NBTTagList();
        Iterator<TravelingItem> i$ = this.items.iterator();
        while (i$.hasNext()) {
            TravelingItem item = i$.next();
            NBTTagCompound dataTag = new NBTTagCompound();
            nbttaglist.func_74742_a((NBTBase)dataTag);
            item.writeToNBT(dataTag);
        }
        nbt.func_74782_a("travelingEntities", (NBTBase)nbttaglist);
    }

    protected void doWork() {
    }

    public void handleTravelerPacket(PacketPipeTransportTraveler packet) {
        TravelingItem item = TravelingItem.clientCache.get(packet.getTravelingEntityId());
        if (item == null) {
            item = TravelingItem.make(packet.getTravelingEntityId());
        }
        if (item.getContainer() != this.container) {
            this.items.add(item);
        }
        if (packet.forceStackRefresh() || item.getItemStack() == null) {
            BuildCraftTransport.instance.sendToServer(new PacketPipeTransportItemStackRequest(packet.getTravelingEntityId()));
        }
        item.setPosition(packet.getItemX(), packet.getItemY(), packet.getItemZ());
        item.setSpeed(packet.getSpeed());
        item.toCenter = true;
        item.input = packet.getInputOrientation();
        item.output = packet.getOutputOrientation();
        item.color = packet.getColor();
    }

    private void sendTravelerPacket(TravelingItem data, boolean forceStackRefresh) {
        PacketPipeTransportTraveler packet = new PacketPipeTransportTraveler(data, forceStackRefresh);
        BuildCraftTransport.instance.sendToPlayers(packet, this.container.func_145831_w(), this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e, DefaultProps.PIPE_CONTENTS_RENDER_DIST);
    }

    public int getNumberOfStacks() {
        return this.items.size();
    }

    public int getNumberOfItems() {
        int num = 0;
        Iterator<TravelingItem> i$ = this.items.iterator();
        while (i$.hasNext()) {
            TravelingItem item = i$.next();
            if (item.getItemStack() == null) continue;
            num += item.getItemStack().field_77994_a;
        }
        return num;
    }

    protected void neighborChange() {
    }

    @Override
    public boolean canPipeConnect(TileEntity tile, ForgeDirection side) {
        Pipe pipe2;
        if (tile instanceof TileGenericPipe && BlockGenericPipe.isValid(pipe2 = ((TileGenericPipe)tile).pipe) && !(pipe2.transport instanceof PipeTransportItems)) {
            return false;
        }
        if (tile instanceof ISidedInventory) {
            int[] slots = ((ISidedInventory)tile).func_94128_d(side.getOpposite().ordinal());
            return slots != null && slots.length > 0;
        }
        return tile instanceof TileGenericPipe || tile instanceof ISpecialInventory || tile instanceof IInventory && ((IInventory)tile).func_70302_i_() > 0 || tile instanceof IMachine && ((IMachine)tile).manageSolids();
    }

    public boolean isTriggerActive(ITrigger trigger) {
        return false;
    }

    public void groupEntities() {
        Iterator<TravelingItem> i$ = this.items.iterator();
        while (i$.hasNext()) {
            TravelingItem otherItem;
            TravelingItem item = i$.next();
            if (item.isCorrupted()) continue;
            Iterator<TravelingItem> i$2 = this.items.iterator();
            while (i$2.hasNext() && !item.tryMergeInto(otherItem = i$2.next())) {
            }
        }
    }

    @Override
    public void dropContents() {
        this.groupEntities();
        Iterator<TravelingItem> i$ = this.items.iterator();
        while (i$.hasNext()) {
            TravelingItem item = i$.next();
            if (item.isCorrupted()) continue;
            this.container.pipe.dropItem(item.getItemStack());
        }
        this.items.clear();
    }

    @Override
    public boolean delveIntoUnloadedChunks() {
        return true;
    }
}

