/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.network;

import buildcraft.api.gates.GateExpansions;
import buildcraft.core.network.BuildCraftPacket;
import buildcraft.core.utils.Utils;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.netty.buffer.ByteBuf;
import java.util.Map;

public class PacketGateExpansionMap
extends BuildCraftPacket {
    @Override
    public void writeData(ByteBuf data) {
        BiMap<Byte, String> map = GateExpansions.getServerMap();
        data.writeByte(map.size());
        for (Map.Entry entry : map.entrySet()) {
            data.writeByte((int)((Byte)entry.getKey()).byteValue());
            Utils.writeUTF(data, (String)entry.getValue());
        }
    }

    @Override
    public void readData(ByteBuf data) {
        int numEntries = data.readByte();
        HashBiMap map = HashBiMap.create((int)numEntries);
        for (int i = 0; i < numEntries; ++i) {
            byte id = data.readByte();
            String identifier = Utils.readUTF(data);
            map.put((Object)id, (Object)identifier);
        }
        GateExpansions.setClientMap((BiMap<Byte, String>)map);
    }

    @Override
    public int getID() {
        return 7;
    }
}

