/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.gates.IAction;
import buildcraft.api.tools.IToolWrench;
import buildcraft.core.utils.StringUtils;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportPower;
import buildcraft.transport.triggers.ActionPowerLimiter;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;

public class PipePowerIron
extends Pipe<PipeTransportPower> {
    public PipePowerIron(Item item) {
        super(new PipeTransportPower(), item);
        ((PipeTransportPower)this.transport).initFromPipe(this.getClass());
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        if (this.container == null) {
            return PipeIconProvider.TYPE.PipePowerIronM128.ordinal();
        }
        return PipeIconProvider.TYPE.PipePowerIronM2.ordinal() + this.container.func_145832_p();
    }

    @Override
    public boolean blockActivated(EntityPlayer player) {
        Item equipped;
        Item item = equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
        if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(player, this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e)) {
            if (player.func_70093_af()) {
                this.setMode(this.getMode().getPrevious());
            } else {
                this.setMode(this.getMode().getNext());
            }
            if (this.getWorld().field_72995_K) {
                player.func_145747_a((IChatComponent)new ChatComponentText(String.format(StringUtils.localize("chat.pipe.power.iron.mode"), this.getMode().maxPower)));
            }
            ((IToolWrench)equipped).wrenchUsed(player, this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e);
            return true;
        }
        return false;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        ((PipeTransportPower)this.transport).maxPower = this.getMode().maxPower;
    }

    public PowerMode getMode() {
        return PowerMode.fromId(this.container.func_145832_p());
    }

    public void setMode(PowerMode mode) {
        if (mode.ordinal() != this.container.func_145832_p()) {
            this.container.func_145831_w().func_72921_c(this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e, mode.ordinal(), 3);
            this.container.scheduleRenderUpdate();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    protected void actionsActivated(Map<IAction, Boolean> actions) {
        super.actionsActivated(actions);
        for (Map.Entry<IAction, Boolean> action : actions.entrySet()) {
            if (!(action.getKey() instanceof ActionPowerLimiter) || action.getValue() != Boolean.TRUE) continue;
            this.setMode(((ActionPowerLimiter)action.getKey()).limit);
            break;
        }
    }

    @Override
    public LinkedList<IAction> getActions() {
        LinkedList<IAction> action = super.getActions();
        for (PowerMode mode : PowerMode.VALUES) {
            action.add(BuildCraftTransport.actionPowerLimiter[mode.ordinal()]);
        }
        return action;
    }

    public static enum PowerMode {
        M2(2),
        M4(4),
        M8(8),
        M16(16),
        M32(32),
        M64(64),
        M128(128);

        public static final PowerMode[] VALUES;
        public final int maxPower;

        private PowerMode(int max) {
            this.maxPower = max;
        }

        public PowerMode getNext() {
            PowerMode next = VALUES[(this.ordinal() + 1) % VALUES.length];
            return next;
        }

        public PowerMode getPrevious() {
            PowerMode previous = VALUES[(this.ordinal() + VALUES.length - 1) % VALUES.length];
            return previous;
        }

        public static PowerMode fromId(int id) {
            if (id < 0 || id >= VALUES.length) {
                return M128;
            }
            return VALUES[id];
        }

        static {
            VALUES = PowerMode.values();
        }
    }
}

