/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.core.Position;
import buildcraft.core.DefaultProps;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public abstract class EntityLaser
extends Entity {
    public static final ResourceLocation[] LASER_TEXTURES = new ResourceLocation[]{new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_ENTITIES + "/laser_1.png"), new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_ENTITIES + "/laser_2.png"), new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_ENTITIES + "/laser_3.png"), new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_ENTITIES + "/laser_4.png")};
    protected Position head;
    protected Position tail;
    public double renderSize = 0.0;
    public double angleY = 0.0;
    public double angleZ = 0.0;
    private boolean isVisible = false;
    protected boolean needsUpdate = true;

    public EntityLaser(World world) {
        super(world);
        this.head = new Position(0.0, 0.0, 0.0);
        this.tail = new Position(0.0, 0.0, 0.0);
    }

    public EntityLaser(World world, Position head, Position tail) {
        super(world);
        this.head = head;
        this.tail = tail;
        this.func_70080_a(head.x, head.y, head.z, 0.0f, 0.0f);
        this.func_70105_a(10.0f, 10.0f);
    }

    protected void func_70088_a() {
        this.field_70156_m = false;
        this.field_70145_X = true;
        this.field_70178_ae = true;
        this.field_70180_af.func_75682_a(8, (Object)0);
        this.field_70180_af.func_75682_a(9, (Object)0);
        this.field_70180_af.func_75682_a(10, (Object)0);
        this.field_70180_af.func_75682_a(11, (Object)0);
        this.field_70180_af.func_75682_a(12, (Object)0);
        this.field_70180_af.func_75682_a(13, (Object)0);
        this.field_70180_af.func_75682_a(14, (Object)0);
    }

    public void func_70071_h_() {
        if (this.head == null || this.tail == null) {
            return;
        }
        if (!this.field_70170_p.field_72995_K && this.needsUpdate) {
            this.updateDataServer();
            this.needsUpdate = false;
        }
        if (this.field_70170_p.field_72995_K) {
            this.updateDataClient();
        }
        this.field_70121_D.field_72340_a = Math.min(this.head.x, this.tail.x);
        this.field_70121_D.field_72338_b = Math.min(this.head.y, this.tail.y);
        this.field_70121_D.field_72339_c = Math.min(this.head.z, this.tail.z);
        this.field_70121_D.field_72336_d = Math.max(this.head.x, this.tail.x);
        this.field_70121_D.field_72337_e = Math.max(this.head.y, this.tail.y);
        this.field_70121_D.field_72334_f = Math.max(this.head.z, this.tail.z);
        this.field_70121_D.field_72340_a -= 1.0;
        this.field_70121_D.field_72338_b -= 1.0;
        this.field_70121_D.field_72339_c -= 1.0;
        this.field_70121_D.field_72336_d += 1.0;
        this.field_70121_D.field_72337_e += 1.0;
        this.field_70121_D.field_72334_f += 1.0;
        double dx = this.head.x - this.tail.x;
        double dy = this.head.y - this.tail.y;
        double dz = this.head.z - this.tail.z;
        this.renderSize = Math.sqrt(dx * dx + dy * dy + dz * dz);
        this.angleZ = 360.0 - (Math.atan2(dz, dx) * 180.0 / Math.PI + 180.0);
        dx = Math.sqrt(this.renderSize * this.renderSize - dy * dy);
        this.angleY = -Math.atan2(dy, dx) * 180.0 / Math.PI;
    }

    protected void updateDataClient() {
        this.head.x = this.decodeDouble(this.field_70180_af.func_75679_c(8));
        this.head.y = this.decodeDouble(this.field_70180_af.func_75679_c(9));
        this.head.z = this.decodeDouble(this.field_70180_af.func_75679_c(10));
        this.tail.x = this.decodeDouble(this.field_70180_af.func_75679_c(11));
        this.tail.y = this.decodeDouble(this.field_70180_af.func_75679_c(12));
        this.tail.z = this.decodeDouble(this.field_70180_af.func_75679_c(13));
        this.isVisible = this.field_70180_af.func_75683_a(14) == 1;
    }

    protected void updateDataServer() {
        this.field_70180_af.func_75692_b(8, (Object)this.encodeDouble(this.head.x));
        this.field_70180_af.func_75692_b(9, (Object)this.encodeDouble(this.head.y));
        this.field_70180_af.func_75692_b(10, (Object)this.encodeDouble(this.head.z));
        this.field_70180_af.func_75692_b(11, (Object)this.encodeDouble(this.tail.x));
        this.field_70180_af.func_75692_b(12, (Object)this.encodeDouble(this.tail.y));
        this.field_70180_af.func_75692_b(13, (Object)this.encodeDouble(this.tail.z));
        this.field_70180_af.func_75692_b(14, (Object)((byte)(this.isVisible ? 1 : 0)));
    }

    public void setPositions(Position head, Position tail) {
        this.head = head;
        this.tail = tail;
        this.func_70080_a(head.x, head.y, head.z, 0.0f, 0.0f);
        this.needsUpdate = true;
    }

    public void show() {
        this.isVisible = true;
        this.needsUpdate = true;
    }

    public void hide() {
        this.isVisible = false;
        this.needsUpdate = true;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public abstract ResourceLocation getTexture();

    protected int encodeDouble(double d) {
        return (int)(d * 8192.0);
    }

    protected double decodeDouble(int i) {
        return (double)i / 8192.0;
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        double headX = nbt.func_74769_h("headX");
        double headY = nbt.func_74769_h("headZ");
        double headZ = nbt.func_74769_h("headY");
        this.head = new Position(headX, headY, headZ);
        double tailX = nbt.func_74769_h("tailX");
        double tailY = nbt.func_74769_h("tailZ");
        double tailZ = nbt.func_74769_h("tailY");
        this.tail = new Position(tailX, tailY, tailZ);
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74780_a("headX", this.head.x);
        nbt.func_74780_a("headY", this.head.y);
        nbt.func_74780_a("headZ", this.head.z);
        nbt.func_74780_a("tailX", this.tail.x);
        nbt.func_74780_a("tailY", this.tail.y);
        nbt.func_74780_a("tailZ", this.tail.z);
    }

    public Position renderOffset() {
        return new Position(this.head.x - this.field_70165_t, this.head.y - this.field_70163_u, this.head.z - this.field_70161_v);
    }

    public int func_70070_b(float par1) {
        return 210;
    }
}

