/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.energy.worldgen.OilPopulate;
import buildcraft.transport.ItemFacade;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import cpw.mods.fml.common.event.FMLInterModComms;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.BiomeGenBase;

public class InterModComms {
    public static void processIMC(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage m : event.getMessages()) {
            if ("add-facade".equals(m.key)) {
                InterModComms.processFacadeIMC(event, m);
                continue;
            }
            if (m.key.equals("oil-lake-biome")) {
                InterModComms.processOilLakeBiomeIMC(event, m);
                continue;
            }
            if (!m.key.equals("oil-gen-exclude")) continue;
            InterModComms.processOilGenExcludeIMC(event, m);
        }
    }

    public static void processFacadeIMC(FMLInterModComms.IMCEvent event, FMLInterModComms.IMCMessage m) {
        try {
            if (m.isStringMessage()) {
                Splitter splitter = Splitter.on((String)"@").trimResults();
                String[] array = (String[])Iterables.toArray((Iterable)splitter.split((CharSequence)m.getStringValue()), String.class);
                if (array.length != 2) {
                    Logger.getLogger("Buildcraft").log(Level.INFO, String.format("Received an invalid add-facade request %s from mod %s", m.getStringValue(), m.getSender()));
                } else {
                    Integer blId = Ints.tryParse((String)array[0]);
                    Integer metaId = Ints.tryParse((String)array[1]);
                    if (blId == null || metaId == null) {
                        Logger.getLogger("Buildcraft").log(Level.INFO, String.format("Received an invalid add-facade request %s from mod %s", m.getStringValue(), m.getSender()));
                    } else {
                        Block block = (Block)Block.field_149771_c.func_148754_a(blId.intValue());
                        ItemFacade.addFacade(new ItemStack(block, 1, metaId.intValue()));
                    }
                }
            } else if (m.isItemStackMessage()) {
                ItemFacade.addFacade(m.getItemStackValue());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void processOilLakeBiomeIMC(FMLInterModComms.IMCEvent event, FMLInterModComms.IMCMessage m) {
        try {
            String biomeID = m.getStringValue().trim();
            int id = Integer.valueOf(biomeID);
            if (id >= BiomeGenBase.func_150565_n().length) {
                throw new IllegalArgumentException("Biome ID must be less than " + BiomeGenBase.func_150565_n().length);
            }
            OilPopulate.INSTANCE.surfaceDepositBiomes.add(id);
        }
        catch (Exception ex) {
            Logger.getLogger("Buildcraft").log(Level.WARNING, String.format("Received an invalid oil-lake-biome request %s from mod %s", m.getStringValue(), m.getSender()));
        }
        Logger.getLogger("Buildcraft").log(Level.INFO, String.format("Received an successfull oil-lake-biome request %s from mod %s", m.getStringValue(), m.getSender()));
    }

    public static void processOilGenExcludeIMC(FMLInterModComms.IMCEvent event, FMLInterModComms.IMCMessage m) {
        try {
            String biomeID = m.getStringValue().trim();
            int id = Integer.valueOf(biomeID);
            if (id >= BiomeGenBase.func_150565_n().length) {
                throw new IllegalArgumentException("Biome ID must be less than " + BiomeGenBase.func_150565_n().length);
            }
            OilPopulate.INSTANCE.excludedBiomes.add(id);
        }
        catch (Exception ex) {
            Logger.getLogger("Buildcraft").log(Level.WARNING, String.format("Received an invalid oil-gen-exclude request %s from mod %s", m.getStringValue(), m.getSender()));
        }
        Logger.getLogger("Buildcraft").log(Level.INFO, String.format("Received an successfull oil-gen-exclude request %s from mod %s", m.getStringValue(), m.getSender()));
    }
}

