/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.BuildCraftCore;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.BCLog;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import net.minecraftforge.common.config.Property;

public class Version
implements Runnable {
    private static Version instance = new Version();
    public static final String VERSION = "5.0.0";
    public static final String BUILD_NUMBER = "58";
    private static final String REMOTE_VERSION_FILE = "http://bit.ly/buildcraftversion";
    private static final String REMOTE_CHANGELOG_ROOT = "https://dl.dropboxusercontent.com/u/38558957/Minecraft/Buildcraft/changelogs/";
    public static EnumUpdateState currentVersion = EnumUpdateState.CURRENT;
    public static final int FORGE_VERSION_MAJOR = 4;
    public static final int FORGE_VERSION_MINOR = 0;
    public static final int FORGE_VERSION_PATCH = 0;
    private static String recommendedVersion;
    private static String[] cachedChangelog;

    public static String getVersion() {
        return "5.0.0 (:58)";
    }

    public static boolean isOutdated() {
        return currentVersion == EnumUpdateState.OUTDATED;
    }

    public static boolean needsUpdateNoticeAndMarkAsSeen() {
        if (!Version.isOutdated()) {
            return false;
        }
        Property property = BuildCraftCore.mainConfiguration.get("vars", "version.seen", VERSION);
        property.comment = "indicates the last version the user has been informed about and will suppress further notices on it.";
        String seenVersion = property.getString();
        if (recommendedVersion == null || recommendedVersion.equals(seenVersion)) {
            return false;
        }
        property.set(recommendedVersion);
        BuildCraftCore.mainConfiguration.save();
        return true;
    }

    public static String getRecommendedVersion() {
        return recommendedVersion;
    }

    public static void versionCheck() {
        try {
            String line;
            if ("0.0.0".equals(VERSION)) {
                return;
            }
            String location = REMOTE_VERSION_FILE;
            URLConnection conn = null;
            while (location != null && !location.isEmpty()) {
                URL url = new URL(location);
                if (conn != null) {
                    ((HttpURLConnection)conn).disconnect();
                }
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 6.0; ru; rv:1.9.0.11) Gecko/2009060215 Firefox/3.0.11 (.NET CLR 3.5.30729)");
                conn.connect();
                location = conn.getHeaderField("Location");
            }
            if (conn == null) {
                throw new NullPointerException();
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String mcVersion = CoreProxy.proxy.getMinecraftVersion();
            while ((line = reader.readLine()) != null) {
                String[] tokens = line.split(":");
                if (!mcVersion.matches(tokens[0]) || !"BuildCraft".matches(tokens[1]) || !VERSION.matches(tokens[2])) continue;
                recommendedVersion = tokens[2];
                BCLog.logger.finer("Using the latest version [" + Version.getVersion() + "] for Minecraft " + mcVersion);
                currentVersion = EnumUpdateState.CURRENT;
                return;
            }
            BCLog.logger.warning("Using outdated version [5.0.0 (build:58)] for Minecraft " + mcVersion + ". Consider updating.");
            currentVersion = EnumUpdateState.OUTDATED;
            ((HttpURLConnection)conn).disconnect();
            reader.close();
        }
        catch (Exception e) {
            BCLog.logger.warning("Unable to read from remote version authority.");
            BCLog.logger.warning(e.toString());
            currentVersion = EnumUpdateState.CONNECTION_ERROR;
        }
    }

    public static String[] getChangelog() {
        if (cachedChangelog == null) {
            cachedChangelog = Version.grabChangelog(recommendedVersion);
        }
        return cachedChangelog;
    }

    public static String[] grabChangelog(String version) {
        try {
            String line;
            String location = REMOTE_CHANGELOG_ROOT + version;
            URLConnection conn = null;
            while (location != null && !location.isEmpty()) {
                URL url = new URL(location);
                if (conn != null) {
                    ((HttpURLConnection)conn).disconnect();
                }
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 6.0; ru; rv:1.9.0.11) Gecko/2009060215 Firefox/3.0.11 (.NET CLR 3.5.30729)");
                conn.connect();
                location = conn.getHeaderField("Location");
            }
            if (conn == null) {
                throw new NullPointerException();
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            ((HttpURLConnection)conn).disconnect();
            ArrayList<String> changelog = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#") || line.isEmpty()) continue;
                changelog.add(line);
            }
            return changelog.toArray(new String[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            BCLog.logger.warning("Unable to read changelog from remote site.");
            return new String[]{String.format("Unable to retrieve changelog for %s %s", "BuildCraft", version)};
        }
    }

    @Override
    public void run() {
        currentVersion = null;
        BCLog.logger.info("Beginning version check");
        try {
            for (int count = 0; count < 3 && (currentVersion == null || currentVersion == EnumUpdateState.CONNECTION_ERROR); ++count) {
                Version.versionCheck();
                if (currentVersion != EnumUpdateState.CONNECTION_ERROR) continue;
                BCLog.logger.info("Version check attempt " + count + " failed, trying again in 10 seconds");
                Thread.sleep(10000L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (currentVersion == EnumUpdateState.CONNECTION_ERROR) {
            BCLog.logger.info("Version check failed");
        }
    }

    public static void check() {
        new Thread(instance).start();
    }

    public static enum EnumUpdateState {
        CURRENT,
        OUTDATED,
        CONNECTION_ERROR;

    }
}

