/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.fluids;

import buildcraft.core.gui.tooltips.ToolTip;
import buildcraft.core.gui.tooltips.ToolTipLine;
import java.util.Locale;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidTank;

public class Tank
extends FluidTank {
    private final String name;
    public int colorRenderCache = 0xFFFFFF;
    protected final ToolTip toolTip = new ToolTip(){

        @Override
        public void refresh() {
            Tank.this.refreshTooltip();
        }
    };

    public Tank(String name, int capacity, TileEntity tile) {
        super(capacity);
        this.name = name;
        this.tile = tile;
    }

    public boolean isEmpty() {
        return this.getFluid() == null || this.getFluid().amount <= 0;
    }

    public boolean isFull() {
        return this.getFluid() != null && this.getFluid().amount >= this.getCapacity();
    }

    public Fluid getFluidType() {
        return this.getFluid() != null ? this.getFluid().getFluid() : null;
    }

    public final NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound tankData = new NBTTagCompound();
        super.writeToNBT(tankData);
        this.writeTankToNBT(tankData);
        nbt.func_74782_a(this.name, (NBTBase)tankData);
        return nbt;
    }

    public final FluidTank readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b(this.name)) {
            NBTTagCompound tankData = nbt.func_74775_l(this.name);
            super.readFromNBT(tankData);
            this.readTankFromNBT(tankData);
        }
        return this;
    }

    public void writeTankToNBT(NBTTagCompound nbt) {
    }

    public void readTankFromNBT(NBTTagCompound nbt) {
    }

    public ToolTip getToolTip() {
        return this.toolTip;
    }

    protected void refreshTooltip() {
        this.toolTip.clear();
        int amount = 0;
        if (this.getFluid() != null && this.getFluid().amount > 0) {
            ToolTipLine fluidName = new ToolTipLine(this.getFluid().getFluid().getLocalizedName());
            fluidName.setSpacing(2);
            this.toolTip.add(fluidName);
            amount = this.getFluid().amount;
        }
        this.toolTip.add(new ToolTipLine(String.format(Locale.ENGLISH, "%,d / %,d", amount, this.getCapacity())));
    }
}

