/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.recipes;

import buildcraft.api.recipes.IAssemblyRecipeManager;
import buildcraft.core.inventory.ITransactor;
import buildcraft.core.inventory.InventoryIterator;
import buildcraft.core.inventory.Transactor;
import buildcraft.core.inventory.filters.ArrayStackFilter;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class AssemblyRecipeManager
implements IAssemblyRecipeManager {
    public static final AssemblyRecipeManager INSTANCE = new AssemblyRecipeManager();
    private List<AssemblyRecipe> assemblyRecipes = new LinkedList<AssemblyRecipe>();

    @Override
    public void addRecipe(double energyCost, ItemStack output, Object ... input) {
        this.assemblyRecipes.add(new AssemblyRecipe(output, energyCost, input));
    }

    public List<AssemblyRecipe> getRecipes() {
        return this.assemblyRecipes;
    }

    public static class AssemblyRecipe
    implements IAssemblyRecipeManager.IAssemblyRecipe {
        public final ItemStack output;
        public final double energyCost;
        private final Object[] originalInput;
        private final Object[] processedInput;

        public AssemblyRecipe(ItemStack output, double energyCost, Object ... inputs) {
            this.output = output.func_77946_l();
            this.energyCost = energyCost;
            this.originalInput = inputs;
            this.processedInput = new Object[inputs.length];
            for (int i = 0; i < inputs.length; ++i) {
                if (inputs[i] instanceof String) {
                    this.processedInput[i] = OreDictionary.getOres((String)((String)inputs[i]));
                    continue;
                }
                if (inputs[i] instanceof ItemStack) {
                    this.processedInput[i] = inputs[i];
                    continue;
                }
                if (inputs[i] instanceof Item) {
                    this.processedInput[i] = new ItemStack((Item)inputs[i]);
                    continue;
                }
                if (inputs[i] instanceof Block) {
                    this.processedInput[i] = new ItemStack((Block)inputs[i], 1, Short.MAX_VALUE);
                    continue;
                }
                if (inputs[i] instanceof Integer) {
                    this.processedInput[i] = inputs[i];
                    continue;
                }
                throw new IllegalArgumentException("Unknown Object passed to recipe!");
            }
        }

        @Override
        public ItemStack getOutput() {
            return this.output.func_77946_l();
        }

        @Override
        public Object[] getInputs() {
            return this.originalInput;
        }

        @Override
        public double getEnergyCost() {
            return this.energyCost;
        }

        public boolean canBeDone(IInventory inv) {
            for (int i = 0; i < this.processedInput.length; ++i) {
                ItemStack item;
                int expected;
                int found;
                if (this.processedInput[i] == null) continue;
                if (this.processedInput[i] instanceof ItemStack) {
                    ItemStack requirement = (ItemStack)this.processedInput[i];
                    found = 0;
                    expected = requirement.field_77994_a;
                    for (InventoryIterator.IInvSlot slot : InventoryIterator.getIterable(inv, ForgeDirection.UNKNOWN)) {
                        item = slot.getStackInSlot();
                        if (item == null) continue;
                        if (item.func_77969_a(requirement)) {
                            found += item.field_77994_a;
                        }
                        if (found < expected) continue;
                        break;
                    }
                    if (found >= expected) continue;
                    return false;
                }
                if (!(this.processedInput[i] instanceof List)) continue;
                List oreList = (List)this.processedInput[i];
                found = 0;
                expected = (Integer)this.processedInput[i++ + 1];
                for (InventoryIterator.IInvSlot slot : InventoryIterator.getIterable(inv, ForgeDirection.UNKNOWN)) {
                    item = slot.getStackInSlot();
                    if (item == null) continue;
                    for (ItemStack oreItem : oreList) {
                        if (!OreDictionary.itemMatches((ItemStack)oreItem, (ItemStack)item, (boolean)true)) continue;
                        found += item.field_77994_a;
                        break;
                    }
                    if (found < expected) continue;
                    break;
                }
                if (found >= expected) continue;
                return false;
            }
            return true;
        }

        public void useItems(IInventory inv) {
            ITransactor tran = Transactor.getTransactorFor(inv);
            Object[] input = this.processedInput;
            block0: for (int i = 0; i < input.length; ++i) {
                if (input[i] instanceof ItemStack) {
                    ItemStack requirement = (ItemStack)input[i];
                    for (int num = 0; num < requirement.field_77994_a; ++num) {
                        tran.remove(new ArrayStackFilter(requirement), ForgeDirection.UNKNOWN, true);
                    }
                    continue;
                }
                if (!(input[i] instanceof List)) continue;
                List oreList = (List)input[i];
                int required = (Integer)input[i + 1];
                for (ItemStack ore : oreList) {
                    for (int num = 0; num < required; ++num) {
                        if (tran.remove(new ArrayStackFilter(ore), ForgeDirection.UNKNOWN, true) == null) continue;
                        --required;
                    }
                    if (required > 0) continue;
                    continue block0;
                }
            }
        }
    }
}

