/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.utils;

import buildcraft.core.proxy.CoreProxy;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;

public class Localization {
    private static String loadedLanguage = Localization.getCurrentLanguage();
    private static Properties defaultMappings = new Properties();
    private static Properties mappings = new Properties();
    private static LinkedList<modInfo> mods = new LinkedList();

    public static void addLocalization(String path, String defaultLanguage) {
        mods.add(new modInfo(path, defaultLanguage));
        Localization.load(path, defaultLanguage);
    }

    public static synchronized String get(String key) {
        if (Localization.getCurrentLanguage() == null) {
            return key;
        }
        if (!Localization.getCurrentLanguage().equals(loadedLanguage)) {
            defaultMappings.clear();
            mappings.clear();
            for (modInfo mInfo : mods) {
                Localization.load(mInfo.modName, mInfo.defaultLanguage);
            }
            loadedLanguage = Localization.getCurrentLanguage();
        }
        return mappings.getProperty(key, defaultMappings.getProperty(key, key));
    }

    public static synchronized boolean hasKey(String key) {
        if (Localization.getCurrentLanguage() == null) {
            return false;
        }
        if (!Localization.getCurrentLanguage().equals(loadedLanguage)) {
            defaultMappings.clear();
            mappings.clear();
            for (modInfo mInfo : mods) {
                Localization.load(mInfo.modName, mInfo.defaultLanguage);
            }
            loadedLanguage = Localization.getCurrentLanguage();
        }
        return mappings.getProperty(key, defaultMappings.getProperty(key)) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load(String path, String default_language) {
        InputStream langStream = null;
        Properties modMappings = new Properties();
        try {
            langStream = Localization.class.getResourceAsStream(path + default_language + ".properties");
            modMappings.load(langStream);
            defaultMappings.putAll((Map<?, ?>)modMappings);
            langStream.close();
            langStream = Localization.class.getResourceAsStream(path + Localization.getCurrentLanguage() + ".properties");
            if (langStream != null) {
                modMappings.clear();
                modMappings.load(langStream);
            }
            if (modMappings.containsKey("language.parent") && (langStream = Localization.class.getResourceAsStream(path + modMappings.get("language.parent") + ".properties")) != null) {
                Properties parentModMappings = new Properties();
                parentModMappings.load(langStream);
                mappings.putAll((Map<?, ?>)parentModMappings);
            }
            mappings.putAll((Map<?, ?>)modMappings);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (langStream != null) {
                    langStream.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private static String getCurrentLanguage() {
        return CoreProxy.proxy.getCurrentLanguage();
    }

    private static class modInfo {
        final String modName;
        final String defaultLanguage;

        public modInfo(String modName, String defaultLanguage) {
            this.modName = modName;
            this.defaultLanguage = defaultLanguage;
        }
    }
}

