/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.BuildCraftSilicon;
import buildcraft.api.gates.IAction;
import buildcraft.core.DefaultProps;
import buildcraft.core.IMachine;
import buildcraft.core.network.PacketNBT;
import buildcraft.core.recipes.AssemblyRecipeManager;
import buildcraft.core.utils.StringUtils;
import buildcraft.core.utils.Utils;
import buildcraft.silicon.TileLaserTableBase;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;

public class TileAssemblyTable
extends TileLaserTableBase
implements IMachine,
IInventory {
    Set<AssemblyRecipeManager.AssemblyRecipe> plannedOutput = new LinkedHashSet<AssemblyRecipeManager.AssemblyRecipe>();
    public AssemblyRecipeManager.AssemblyRecipe currentRecipe;

    public List<AssemblyRecipeManager.AssemblyRecipe> getPotentialOutputs() {
        LinkedList<AssemblyRecipeManager.AssemblyRecipe> result = new LinkedList<AssemblyRecipeManager.AssemblyRecipe>();
        for (AssemblyRecipeManager.AssemblyRecipe recipe : AssemblyRecipeManager.INSTANCE.getRecipes()) {
            if (!recipe.canBeDone(this)) continue;
            result.add(recipe);
        }
        return result;
    }

    public boolean canUpdate() {
        return !FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    @Override
    public void func_145845_h() {
        if (this.currentRecipe == null) {
            return;
        }
        if (!this.currentRecipe.canBeDone(this)) {
            this.setNextCurrentRecipe();
            if (this.currentRecipe == null) {
                return;
            }
        }
        if (this.getEnergy() >= this.currentRecipe.getEnergyCost()) {
            this.setEnergy(0.0);
            if (this.currentRecipe.canBeDone(this)) {
                this.currentRecipe.useItems(this);
                ItemStack remaining = this.currentRecipe.output.func_77946_l();
                remaining.field_77994_a -= Utils.addToRandomInventoryAround(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, remaining);
                if (remaining.field_77994_a > 0) {
                    remaining.field_77994_a -= Utils.addToRandomPipeAround(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.UNKNOWN, remaining);
                }
                if (remaining.field_77994_a > 0) {
                    EntityItem entityitem = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.7, (double)this.field_145849_e + 0.5, this.currentRecipe.output.func_77946_l());
                    this.field_145850_b.func_72838_d((Entity)entityitem);
                }
                this.setNextCurrentRecipe();
            }
        }
    }

    public int func_70302_i_() {
        return 12;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        super.func_70299_a(slot, stack);
        if (this.currentRecipe == null) {
            this.setNextCurrentRecipe();
        }
    }

    public String func_145825_b() {
        return StringUtils.localize("tile.assemblyTableBlock");
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("planned", Utils.NBTTag_Types.NBTTagCompound.ordinal());
        block0: for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound cpt = list.func_150305_b(i);
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)cpt);
            for (AssemblyRecipeManager.AssemblyRecipe r : AssemblyRecipeManager.INSTANCE.getRecipes()) {
                if (r.output.func_77973_b() != stack.func_77973_b() || r.output.func_77960_j() != stack.func_77960_j()) continue;
                this.plannedOutput.add(r);
                continue block0;
            }
        }
        if (nbt.func_74764_b("recipe")) {
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("recipe"));
            for (AssemblyRecipeManager.AssemblyRecipe r : this.plannedOutput) {
                if (r.output.func_77973_b() != stack.func_77973_b() || r.output.func_77960_j() != stack.func_77960_j()) continue;
                this.setCurrentRecipe(r);
                break;
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList list = new NBTTagList();
        for (AssemblyRecipeManager.AssemblyRecipe recipe : this.plannedOutput) {
            NBTTagCompound cpt = new NBTTagCompound();
            recipe.output.func_77955_b(cpt);
            list.func_74742_a((NBTBase)cpt);
        }
        nbt.func_74782_a("planned", (NBTBase)list);
        if (this.currentRecipe != null) {
            NBTTagCompound recipe = new NBTTagCompound();
            this.currentRecipe.output.func_77955_b(recipe);
            nbt.func_74782_a("recipe", (NBTBase)recipe);
        }
    }

    public boolean isPlanned(AssemblyRecipeManager.AssemblyRecipe recipe) {
        if (recipe == null) {
            return false;
        }
        return this.plannedOutput.contains(recipe);
    }

    public boolean isAssembling(AssemblyRecipeManager.AssemblyRecipe recipe) {
        return recipe != null && recipe == this.currentRecipe;
    }

    private void setCurrentRecipe(AssemblyRecipeManager.AssemblyRecipe recipe) {
        this.currentRecipe = recipe;
    }

    @Override
    public double getRequiredEnergy() {
        if (this.currentRecipe != null) {
            return this.currentRecipe.getEnergyCost();
        }
        return 0.0;
    }

    public void planOutput(AssemblyRecipeManager.AssemblyRecipe recipe) {
        if (recipe != null && !this.isPlanned(recipe)) {
            this.plannedOutput.add(recipe);
            if (!this.isAssembling(this.currentRecipe) || !this.isPlanned(this.currentRecipe)) {
                this.setCurrentRecipe(recipe);
            }
        }
    }

    public void cancelPlanOutput(AssemblyRecipeManager.AssemblyRecipe recipe) {
        if (this.isAssembling(recipe)) {
            this.setCurrentRecipe(null);
        }
        this.plannedOutput.remove(recipe);
        if (!this.plannedOutput.isEmpty()) {
            this.setCurrentRecipe(this.plannedOutput.iterator().next());
        }
    }

    public void setNextCurrentRecipe() {
        boolean takeNext = false;
        for (AssemblyRecipeManager.AssemblyRecipe recipe : this.plannedOutput) {
            if (recipe == this.currentRecipe) {
                takeNext = true;
                continue;
            }
            if (!takeNext || !recipe.canBeDone(this)) continue;
            this.setCurrentRecipe(recipe);
            return;
        }
        for (AssemblyRecipeManager.AssemblyRecipe recipe : this.plannedOutput) {
            if (!recipe.canBeDone(this)) continue;
            this.setCurrentRecipe(recipe);
            return;
        }
        this.setCurrentRecipe(null);
    }

    public void handleSelectionMessage(SelectionMessage message) {
        for (AssemblyRecipeManager.AssemblyRecipe recipe : AssemblyRecipeManager.INSTANCE.getRecipes()) {
            if (!recipe.output.func_77969_a(message.stack) || !ItemStack.func_77970_a((ItemStack)recipe.output, (ItemStack)message.stack)) continue;
            if (message.select) {
                this.planOutput(recipe);
                break;
            }
            this.cancelPlanOutput(recipe);
            break;
        }
    }

    public void sendSelectionTo(EntityPlayer player) {
        for (AssemblyRecipeManager.AssemblyRecipe recipe : AssemblyRecipeManager.INSTANCE.getRecipes()) {
            SelectionMessage message = new SelectionMessage();
            message.stack = recipe.output;
            message.select = this.isPlanned(recipe);
            PacketNBT packet = new PacketNBT(22, message.getNBT(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
            packet.posX = this.field_145851_c;
            packet.posY = this.field_145848_d;
            packet.posZ = this.field_145849_e;
            BuildCraftSilicon.instance.sendToPlayers(packet, this.field_145850_b, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, DefaultProps.NETWORK_UPDATE_RANGE);
        }
    }

    @Override
    public boolean isActive() {
        return this.currentRecipe != null;
    }

    @Override
    public boolean manageFluids() {
        return false;
    }

    @Override
    public boolean manageSolids() {
        return false;
    }

    @Override
    public boolean allowAction(IAction action) {
        return false;
    }

    @Override
    public boolean canCraft() {
        return this.currentRecipe != null;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public static class SelectionMessage {
        public boolean select;
        public ItemStack stack;

        public NBTTagCompound getNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74757_a("s", this.select);
            NBTTagCompound itemNBT = new NBTTagCompound();
            this.stack.func_77955_b(itemNBT);
            nbt.func_74782_a("i", (NBTBase)itemNBT);
            return nbt;
        }

        public void fromNBT(NBTTagCompound nbt) {
            this.select = nbt.func_74767_n("s");
            NBTTagCompound itemNBT = nbt.func_74775_l("i");
            this.stack = ItemStack.func_77949_a((NBTTagCompound)itemNBT);
        }
    }
}

