/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gates;

import buildcraft.BuildCraftTransport;
import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.GateExpansions;
import buildcraft.api.gates.IAction;
import buildcraft.api.gates.IGateExpansion;
import buildcraft.api.gates.ITrigger;
import buildcraft.core.ItemBuildCraft;
import buildcraft.core.inventory.InvUtils;
import buildcraft.core.utils.Localization;
import buildcraft.core.utils.Utils;
import buildcraft.transport.Gate;
import buildcraft.transport.gates.GateDefinition;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.IIcon;

public class ItemGate
extends ItemBuildCraft {
    private static final String NBT_TAG_MAT = "mat";
    private static final String NBT_TAG_LOGIC = "logic";
    private static final String NBT_TAG_EX = "ex";

    public ItemGate() {
        this.func_77627_a(false);
        this.func_77656_e(0);
        this.setPassSneakClick(true);
    }

    private static NBTTagCompound getNBT(ItemStack stack) {
        if (stack == null || !(stack.func_77973_b() instanceof ItemGate)) {
            return null;
        }
        return InvUtils.getItemData(stack);
    }

    public static void setMaterial(ItemStack stack, GateDefinition.GateMaterial material) {
        NBTTagCompound nbt = InvUtils.getItemData(stack);
        nbt.func_74774_a(NBT_TAG_MAT, (byte)material.ordinal());
    }

    public static GateDefinition.GateMaterial getMaterial(ItemStack stack) {
        NBTTagCompound nbt = ItemGate.getNBT(stack);
        if (nbt == null) {
            return GateDefinition.GateMaterial.REDSTONE;
        }
        return GateDefinition.GateMaterial.fromOrdinal(nbt.func_74771_c(NBT_TAG_MAT));
    }

    public static GateDefinition.GateLogic getLogic(ItemStack stack) {
        NBTTagCompound nbt = ItemGate.getNBT(stack);
        if (nbt == null) {
            return GateDefinition.GateLogic.AND;
        }
        return GateDefinition.GateLogic.fromOrdinal(nbt.func_74771_c(NBT_TAG_LOGIC));
    }

    public static void setLogic(ItemStack stack, GateDefinition.GateLogic logic) {
        NBTTagCompound nbt = InvUtils.getItemData(stack);
        nbt.func_74774_a(NBT_TAG_LOGIC, (byte)logic.ordinal());
    }

    public static void addGateExpansion(ItemStack stack, IGateExpansion expansion) {
        NBTTagCompound nbt = ItemGate.getNBT(stack);
        if (nbt == null) {
            return;
        }
        NBTTagList expansionList = nbt.func_150295_c(NBT_TAG_EX, Utils.NBTTag_Types.NBTTagString.ordinal());
        expansionList.func_74742_a((NBTBase)new NBTTagString(expansion.getUniqueIdentifier()));
        nbt.func_74782_a(NBT_TAG_EX, (NBTBase)expansionList);
    }

    public static boolean hasGateExpansion(ItemStack stack, IGateExpansion expansion) {
        NBTTagCompound nbt = ItemGate.getNBT(stack);
        if (nbt == null) {
            return false;
        }
        try {
            NBTTagList expansionList = nbt.func_150295_c(NBT_TAG_EX, Utils.NBTTag_Types.NBTTagString.ordinal());
            for (int i = 0; i < expansionList.func_74745_c(); ++i) {
                String ex = expansionList.func_150307_f(i);
                if (!ex.equals(expansion.getUniqueIdentifier())) continue;
                return true;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return false;
    }

    public static Set<IGateExpansion> getInstalledExpansions(ItemStack stack) {
        HashSet<IGateExpansion> expansions = new HashSet<IGateExpansion>();
        NBTTagCompound nbt = ItemGate.getNBT(stack);
        if (nbt == null) {
            return expansions;
        }
        try {
            NBTTagList expansionList = nbt.func_150295_c(NBT_TAG_EX, Utils.NBTTag_Types.NBTTagString.ordinal());
            for (int i = 0; i < expansionList.func_74745_c(); ++i) {
                String exTag = expansionList.func_150307_f(i);
                IGateExpansion ex = GateExpansions.getExpansion(exTag);
                if (ex == null) continue;
                expansions.add(ex);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return expansions;
    }

    public static ItemStack makeGateItem(GateDefinition.GateMaterial material, GateDefinition.GateLogic logic) {
        ItemStack stack = new ItemStack(BuildCraftTransport.pipeGate);
        NBTTagCompound nbt = InvUtils.getItemData(stack);
        nbt.func_74774_a(NBT_TAG_MAT, (byte)material.ordinal());
        nbt.func_74774_a(NBT_TAG_LOGIC, (byte)logic.ordinal());
        return stack;
    }

    public static ItemStack makeGateItem(Gate gate) {
        ItemStack stack = new ItemStack(BuildCraftTransport.pipeGate);
        NBTTagCompound nbt = InvUtils.getItemData(stack);
        nbt.func_74774_a(NBT_TAG_MAT, (byte)gate.material.ordinal());
        nbt.func_74774_a(NBT_TAG_LOGIC, (byte)gate.logic.ordinal());
        for (IGateExpansion expansion : gate.expansions.keySet()) {
            ItemGate.addGateExpansion(stack, expansion);
        }
        return stack;
    }

    public String func_77667_c(ItemStack stack) {
        return GateDefinition.getLocalizedName(ItemGate.getMaterial(stack), ItemGate.getLogic(stack));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List itemList) {
        for (GateDefinition.GateMaterial material : GateDefinition.GateMaterial.VALUES) {
            for (GateDefinition.GateLogic logic : GateDefinition.GateLogic.VALUES) {
                if (material == GateDefinition.GateMaterial.REDSTONE && logic == GateDefinition.GateLogic.OR) continue;
                itemList.add(ItemGate.makeGateItem(material, logic));
                for (IGateExpansion exp : GateExpansions.getExpansions()) {
                    ItemStack stackExpansion = ItemGate.makeGateItem(material, logic);
                    ItemGate.addGateExpansion(stackExpansion, exp);
                    itemList.add(stackExpansion);
                }
            }
        }
    }

    public static ItemStack[] getGateVarients() {
        ArrayList<ItemStack> gates = new ArrayList<ItemStack>();
        for (GateDefinition.GateMaterial material : GateDefinition.GateMaterial.VALUES) {
            for (GateDefinition.GateLogic logic : GateDefinition.GateLogic.VALUES) {
                if (material == GateDefinition.GateMaterial.REDSTONE && logic == GateDefinition.GateLogic.OR) continue;
                gates.add(ItemGate.makeGateItem(material, logic));
            }
        }
        return gates.toArray(new ItemStack[gates.size()]);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean adv) {
        super.func_77624_a(stack, player, list, adv);
        list.add("\u00c2\u00a79\u00c2\u00a7o" + Localization.get("tip.gate.wires"));
        list.add(Localization.get("tip.gate.wires." + ItemGate.getMaterial(stack).getTag()));
        Set<IGateExpansion> expansions = ItemGate.getInstalledExpansions(stack);
        if (!expansions.isEmpty()) {
            list.add("\u00c2\u00a79\u00c2\u00a7o" + Localization.get("tip.gate.expansions"));
            for (IGateExpansion expansion : expansions) {
                list.add(expansion.getDisplayName());
            }
        }
    }

    public IIcon func_77650_f(ItemStack stack) {
        return ItemGate.getLogic(stack).getIconItem();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        for (GateDefinition.GateMaterial gateMaterial : GateDefinition.GateMaterial.VALUES) {
            gateMaterial.registerItemIcon(iconRegister);
        }
        for (Enum enum_ : GateDefinition.GateLogic.VALUES) {
            ((GateDefinition.GateLogic)enum_).registerItemIcon(iconRegister);
        }
        for (IGateExpansion expansion : GateExpansions.getExpansions()) {
            expansion.registerItemOverlay(iconRegister);
        }
        for (IAction action : ActionManager.actions.values()) {
            action.registerIcons(iconRegister);
        }
        for (ITrigger trigger : ActionManager.triggers.values()) {
            trigger.registerIcons(iconRegister);
        }
    }
}

