/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import buildcraft.api.transport.IPipeTile;
import buildcraft.transport.IPipeTransportPowerHook;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportPower;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class PipePowerWood
extends Pipe<PipeTransportPower>
implements IPowerReceptor,
IPipeTransportPowerHook {
    private PowerHandler powerHandler;
    protected int standardIconIndex = PipeIconProvider.TYPE.PipePowerWood_Standard.ordinal();
    protected int solidIconIndex = PipeIconProvider.TYPE.PipeAllWood_Solid.ordinal();
    private boolean[] powerSources = new boolean[6];
    private boolean full;

    public PipePowerWood(Item item) {
        super(new PipeTransportPower(), item);
        this.powerHandler = new PowerHandler(this, PowerHandler.Type.PIPE);
        this.initPowerProvider();
        ((PipeTransportPower)this.transport).initFromPipe(this.getClass());
    }

    private void initPowerProvider() {
        this.powerHandler.configure(2.0, 500.0, 1.0, 1500.0);
        this.powerHandler.configurePowerPerdition(1, 10);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        return this.standardIconIndex;
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return this.powerHandler.getPowerReceiver();
    }

    @Override
    public void doWork(PowerHandler workProvider) {
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.container.func_145831_w().field_72995_K) {
            return;
        }
        if (this.powerHandler.getEnergyStored() <= 0.0) {
            return;
        }
        int sources = 0;
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.container.isPipeConnected(o)) {
                this.powerSources[o.ordinal()] = false;
                continue;
            }
            if (this.powerHandler.isPowerSource(o)) {
                this.powerSources[o.ordinal()] = true;
            }
            if (!this.powerSources[o.ordinal()]) continue;
            ++sources;
        }
        if (sources <= 0) {
            this.powerHandler.useEnergy(5.0, 5.0, true);
            return;
        }
        double energyToRemove = this.powerHandler.getEnergyStored() > 40.0 ? this.powerHandler.getEnergyStored() / 40.0 + 4.0 : (this.powerHandler.getEnergyStored() > 10.0 ? this.powerHandler.getEnergyStored() / 10.0 : 1.0);
        energyToRemove /= (double)sources;
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            float energyUsable;
            float energySent;
            if (!this.powerSources[o.ordinal()] || !((energySent = ((PipeTransportPower)this.transport).receiveEnergy(o, energyUsable = (float)this.powerHandler.useEnergy(0.0, energyToRemove, false))) > 0.0f)) continue;
            this.powerHandler.useEnergy(0.0, energySent, true);
        }
    }

    public boolean requestsPower() {
        if (this.full) {
            boolean request;
            boolean bl = request = this.powerHandler.getEnergyStored() < this.powerHandler.getMaxEnergyStored() / 2.0;
            if (request) {
                this.full = false;
            }
            return request;
        }
        this.full = this.powerHandler.getEnergyStored() >= this.powerHandler.getMaxEnergyStored() - 10.0;
        return !this.full;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.powerHandler.writeToNBT(data);
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            data.func_74757_a("powerSources[" + i + "]", this.powerSources[i]);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.powerHandler.readFromNBT(data);
        this.initPowerProvider();
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            this.powerSources[i] = data.func_74767_n("powerSources[" + i + "]");
        }
    }

    @Override
    public float receiveEnergy(ForgeDirection from, float val) {
        return -1.0f;
    }

    @Override
    public float requestEnergy(ForgeDirection from, float amount) {
        if (this.container.getTile(from) instanceof IPipeTile) {
            return amount;
        }
        return 0.0f;
    }
}

