/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.utils;

import io.netty.buffer.ByteBuf;
import net.minecraftforge.common.util.ForgeDirection;

public class TextureMatrix {
    private final int[] _iconIndexes = new int[7];
    private boolean dirty = false;

    public int getTextureIndex(ForgeDirection direction) {
        return this._iconIndexes[direction.ordinal()];
    }

    public void setIconIndex(ForgeDirection direction, int value) {
        if (this._iconIndexes[direction.ordinal()] != value) {
            this._iconIndexes[direction.ordinal()] = value;
            this.dirty = true;
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clean() {
        this.dirty = false;
    }

    public void writeData(ByteBuf data) {
        for (int i = 0; i < this._iconIndexes.length; ++i) {
            data.writeByte(this._iconIndexes[i]);
        }
    }

    public void readData(ByteBuf data) {
        for (int i = 0; i < this._iconIndexes.length; ++i) {
            byte icon = data.readByte();
            if (this._iconIndexes[i] == icon) continue;
            this._iconIndexes[i] = icon;
            this.dirty = true;
        }
    }
}

