/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.recipes;

import buildcraft.api.recipes.IRefineryRecipeManager;
import com.google.common.base.Objects;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import net.minecraftforge.fluids.FluidStack;

public final class RefineryRecipeManager
implements IRefineryRecipeManager {
    public static final RefineryRecipeManager INSTANCE = new RefineryRecipeManager();
    private SortedSet<RefineryRecipe> recipes = new TreeSet<RefineryRecipe>();

    @Override
    public void addRecipe(FluidStack ingredient, FluidStack result, int energy, int delay) {
        this.addRecipe(ingredient, null, result, energy, delay);
    }

    @Override
    public void addRecipe(FluidStack ingredient1, FluidStack ingredient2, FluidStack result, int energy, int delay) {
        RefineryRecipe recipe = new RefineryRecipe(ingredient1, ingredient2, result, energy, delay);
        this.recipes.add(recipe);
    }

    public SortedSet<RefineryRecipe> getRecipes() {
        return Collections.unmodifiableSortedSet(this.recipes);
    }

    @Override
    public RefineryRecipe findRefineryRecipe(FluidStack liquid1, FluidStack liquid2) {
        for (RefineryRecipe recipe : this.recipes) {
            if (!recipe.matches(liquid1, liquid2)) continue;
            return recipe;
        }
        return null;
    }

    private RefineryRecipeManager() {
    }

    public static final class RefineryRecipe
    implements IRefineryRecipeManager.IRefineryRecipe,
    Comparable<RefineryRecipe> {
        public final FluidStack ingredient1;
        public final FluidStack ingredient2;
        public final FluidStack result;
        public final int energyCost;
        public final int timeRequired;

        private RefineryRecipe(FluidStack ingredient1, FluidStack ingredient2, FluidStack result, int energy, int delay) {
            if (ingredient1 == null) {
                throw new IllegalArgumentException("First Ingredient cannot be null!");
            }
            this.ingredient1 = ingredient1;
            this.ingredient2 = ingredient2;
            this.result = result;
            this.energyCost = energy;
            this.timeRequired = delay;
        }

        public boolean matches(FluidStack liquid1, FluidStack liquid2) {
            if (liquid1 == null && liquid2 == null) {
                return false;
            }
            if (this.ingredient1 != null && this.ingredient2 != null && (liquid1 == null || liquid2 == null)) {
                return false;
            }
            if (liquid1 != null && liquid2 != null) {
                if (liquid1.containsFluid(this.ingredient1) && liquid1.containsFluid(this.ingredient2)) {
                    return true;
                }
                if (liquid1.containsFluid(this.ingredient2) && liquid1.containsFluid(this.ingredient1)) {
                    return true;
                }
            }
            if (liquid1 != null) {
                return liquid1.containsFluid(this.ingredient1) || liquid1.containsFluid(this.ingredient2);
            }
            if (liquid2 != null) {
                return liquid2.containsFluid(this.ingredient1) || liquid2.containsFluid(this.ingredient2);
            }
            return false;
        }

        @Override
        public int compareTo(RefineryRecipe other) {
            if (other == null) {
                return -1;
            }
            if (this.ingredient1.getFluid() != other.ingredient1.getFluid()) {
                return this.ingredient1.getFluid().getName().compareTo(other.ingredient1.getFluid().getName());
            }
            if (this.ingredient1.amount != other.ingredient1.amount) {
                return other.ingredient1.amount - this.ingredient1.amount;
            }
            if (this.ingredient2 == null) {
                return other.ingredient2 == null ? 0 : 1;
            }
            if (other.ingredient2 == null) {
                return -1;
            }
            if (this.ingredient2.getFluid() != other.ingredient2.getFluid()) {
                return this.ingredient2.getFluid().getName().compareTo(other.ingredient2.getFluid().getName());
            }
            if (this.ingredient2.amount != other.ingredient2.amount) {
                return other.ingredient2.amount - this.ingredient2.amount;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            return obj instanceof RefineryRecipe && Objects.equal((Object)this.ingredient1, (Object)((RefineryRecipe)obj).ingredient1) && Objects.equal((Object)this.ingredient2, (Object)((RefineryRecipe)obj).ingredient2);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.ingredient1, this.ingredient2});
        }

        @Override
        public FluidStack getIngredient1() {
            return this.ingredient1;
        }

        @Override
        public FluidStack getIngredient2() {
            return this.ingredient2;
        }

        @Override
        public FluidStack getResult() {
            return this.result;
        }

        @Override
        public int getEnergyCost() {
            return this.energyCost;
        }

        @Override
        public int getTimeRequired() {
            return this.timeRequired;
        }
    }
}

