/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.render;

import buildcraft.core.EntityBlock;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class RenderEntityBlock
extends Render {
    public static RenderEntityBlock INSTANCE = new RenderEntityBlock();
    protected RenderBlocks renderBlocks;

    protected ResourceLocation func_110775_a(Entity entity) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private RenderEntityBlock() {
        this.renderBlocks = this.field_147909_c;
    }

    public void func_76986_a(Entity entity, double i, double j, double k, float f, float f1) {
        this.doRenderBlock((EntityBlock)entity, i, j, k);
    }

    public void doRenderBlock(EntityBlock entity, double i, double j, double k) {
        if (entity.field_70128_L) {
            return;
        }
        this.field_76989_e = entity.shadowSize;
        World world = entity.field_70170_p;
        RenderInfo util = new RenderInfo();
        util.texture = entity.texture;
        this.func_110776_a(TextureMap.field_110575_b);
        int iBase = 0;
        while ((double)iBase < entity.iSize) {
            int jBase = 0;
            while ((double)jBase < entity.jSize) {
                int kBase = 0;
                while ((double)kBase < entity.kSize) {
                    util.minX = 0.0;
                    util.minY = 0.0;
                    util.minZ = 0.0;
                    double remainX = entity.iSize - (double)iBase;
                    double remainY = entity.jSize - (double)jBase;
                    double remainZ = entity.kSize - (double)kBase;
                    util.maxX = remainX > 1.0 ? 1.0 : remainX;
                    util.maxY = remainY > 1.0 ? 1.0 : remainY;
                    util.maxZ = remainZ > 1.0 ? 1.0 : remainZ;
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)((float)i), (float)((float)j), (float)((float)k));
                    GL11.glRotatef((float)entity.rotationX, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)entity.rotationY, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)entity.rotationZ, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)iBase, (float)jBase, (float)kBase);
                    int lightX = (int)(Math.floor(entity.field_70165_t) + (double)iBase);
                    int lightY = (int)(Math.floor(entity.field_70163_u) + (double)jBase);
                    int lightZ = (int)(Math.floor(entity.field_70161_v) + (double)kBase);
                    GL11.glDisable((int)2896);
                    this.renderBlock(util, (IBlockAccess)world, 0.0, 0.0, 0.0, lightX, lightY, lightZ, false, true);
                    GL11.glEnable((int)2896);
                    GL11.glPopMatrix();
                    ++kBase;
                }
                ++jBase;
            }
            ++iBase;
        }
    }

    public void renderBlock(RenderInfo info, IBlockAccess blockAccess, int x, int y, int z, boolean doLight, boolean doTessellating) {
        this.renderBlock(info, blockAccess, x, y, z, x, y, z, doLight, doTessellating);
    }

    public void renderBlock(RenderInfo info, IBlockAccess blockAccess, double x, double y, double z, int lightX, int lightY, int lightZ, boolean doLight, boolean doTessellating) {
        float lightBottom = 0.5f;
        float lightTop = 1.0f;
        float lightEastWest = 0.8f;
        float lightNorthSouth = 0.6f;
        Tessellator tessellator = Tessellator.field_78398_a;
        if (blockAccess == null) {
            doLight = false;
        }
        tessellator.func_78382_b();
        float light = 0.0f;
        if (doLight) {
            if (info.light < 0.0f) {
                light = info.baseBlock.func_149677_c(blockAccess, lightX, lightY, lightZ);
                light += (1.0f - light) * 0.4f;
            } else {
                light = info.light;
            }
            int brightness = 0;
            brightness = info.brightness < 0 ? info.baseBlock.func_149677_c(blockAccess, lightX, lightY, lightZ) : info.brightness;
            tessellator.func_78380_c(brightness);
            tessellator.func_78386_a(lightBottom * light, lightBottom * light, lightBottom * light);
        } else if (info.brightness >= 0) {
            tessellator.func_78380_c(info.brightness);
        }
        this.renderBlocks.func_147782_a(info.minX, info.minY, info.minZ, info.maxX, info.maxY, info.maxZ);
        if (info.renderSide[0]) {
            this.renderBlocks.func_147768_a(info.baseBlock, x, y, z, info.getBlockTextureFromSide(0));
        }
        if (doLight) {
            tessellator.func_78386_a(lightTop * light, lightTop * light, lightTop * light);
        }
        if (info.renderSide[1]) {
            this.renderBlocks.func_147806_b(info.baseBlock, x, y, z, info.getBlockTextureFromSide(1));
        }
        if (doLight) {
            tessellator.func_78386_a(lightEastWest * light, lightEastWest * light, lightEastWest * light);
        }
        if (info.renderSide[2]) {
            this.renderBlocks.func_147761_c(info.baseBlock, x, y, z, info.getBlockTextureFromSide(2));
        }
        if (doLight) {
            tessellator.func_78386_a(lightEastWest * light, lightEastWest * light, lightEastWest * light);
        }
        if (info.renderSide[3]) {
            this.renderBlocks.func_147734_d(info.baseBlock, x, y, z, info.getBlockTextureFromSide(3));
        }
        if (doLight) {
            tessellator.func_78386_a(lightNorthSouth * light, lightNorthSouth * light, lightNorthSouth * light);
        }
        if (info.renderSide[4]) {
            this.renderBlocks.func_147798_e(info.baseBlock, x, y, z, info.getBlockTextureFromSide(4));
        }
        if (doLight) {
            tessellator.func_78386_a(lightNorthSouth * light, lightNorthSouth * light, lightNorthSouth * light);
        }
        if (info.renderSide[5]) {
            this.renderBlocks.func_147764_f(info.baseBlock, x, y, z, info.getBlockTextureFromSide(5));
        }
        tessellator.func_78381_a();
    }

    public static class RenderInfo {
        public double minX;
        public double minY;
        public double minZ;
        public double maxX;
        public double maxY;
        public double maxZ;
        public Block baseBlock = Blocks.field_150354_m;
        public IIcon texture = null;
        public IIcon[] textureArray = null;
        public boolean[] renderSide = new boolean[6];
        public float light = -1.0f;
        public int brightness = -1;

        public RenderInfo() {
            this.setRenderAllSides();
        }

        public RenderInfo(Block template, IIcon[] texture) {
            this();
            this.baseBlock = template;
            this.textureArray = texture;
        }

        public RenderInfo(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
            this();
            this.setBounds(minX, minY, minZ, maxX, maxY, maxZ);
        }

        public float getBlockBrightness(IBlockAccess iblockaccess, int i, int j, int k) {
            return this.baseBlock.func_149677_c(iblockaccess, i, j, k);
        }

        public final void setBounds(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
            this.minX = minX;
            this.minY = minY;
            this.minZ = minZ;
            this.maxX = maxX;
            this.maxY = maxY;
            this.maxZ = maxZ;
        }

        public final void setRenderSingleSide(int side) {
            Arrays.fill(this.renderSide, false);
            this.renderSide[side] = true;
        }

        public final void setRenderAllSides() {
            Arrays.fill(this.renderSide, true);
        }

        public void rotate() {
            double temp = this.minX;
            this.minX = this.minZ;
            this.minZ = temp;
            temp = this.maxX;
            this.maxX = this.maxZ;
            this.maxZ = temp;
        }

        public void reverseX() {
            double temp = this.minX;
            this.minX = 1.0 - this.maxX;
            this.maxX = 1.0 - temp;
        }

        public void reverseZ() {
            double temp = this.minZ;
            this.minZ = 1.0 - this.maxZ;
            this.maxZ = 1.0 - temp;
        }

        public IIcon getBlockTextureFromSide(int i) {
            if (this.texture != null) {
                return this.texture;
            }
            if (this.textureArray == null || this.textureArray.length == 0) {
                return this.baseBlock.func_149733_h(i);
            }
            if (i >= this.textureArray.length) {
                i = 0;
            }
            return this.textureArray[i];
        }
    }
}

