/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.fluids.Tank;
import buildcraft.core.fluids.TankManager;
import buildcraft.core.network.PacketPayload;
import buildcraft.core.network.PacketPayloadStream;
import buildcraft.core.network.PacketUpdate;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.EnumSkyBlock;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileTank
extends TileBuildCraft
implements IFluidHandler {
    public final Tank tank = new Tank("tank", 16000, this);
    public final TankManager tankManager = new TankManager(new Tank[]{this.tank});
    public boolean hasUpdate = false;
    public SafeTimeTracker tracker = new SafeTimeTracker();
    private int prevLightValue = 0;

    @Override
    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            int lightValue = this.getFluidLightLevel();
            if (this.prevLightValue != lightValue) {
                this.prevLightValue = lightValue;
                this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            return;
        }
        if (this.tank.getFluid() != null) {
            this.moveFluidBelow();
        }
        if (this.hasUpdate && this.tracker.markTimeIfDelay(this.field_145850_b, 2 * BuildCraftCore.updateFactor)) {
            this.sendNetworkUpdate();
            this.hasUpdate = false;
        }
    }

    @Override
    public PacketPayload getPacketPayload() {
        PacketPayloadStream payload = new PacketPayloadStream(new PacketPayloadStream.StreamWriter(){

            @Override
            public void writeData(ByteBuf data) {
                TileTank.this.tankManager.writeData(data);
            }
        });
        return payload;
    }

    @Override
    public void handleUpdatePacket(PacketUpdate packet) throws IOException {
        ByteBuf stream = ((PacketPayloadStream)packet.payload).stream;
        this.tankManager.readData(stream);
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.tankManager.readFromNBT(data);
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.tankManager.writeToNBT(data);
    }

    public TileTank getBottomTank() {
        TileTank below;
        TileTank lastTank = this;
        while ((below = TileTank.getTankBelow(lastTank)) != null) {
            lastTank = below;
        }
        return lastTank;
    }

    public TileTank getTopTank() {
        TileTank above;
        TileTank lastTank = this;
        while ((above = TileTank.getTankAbove(lastTank)) != null) {
            lastTank = above;
        }
        return lastTank;
    }

    public static TileTank getTankBelow(TileTank tile) {
        TileEntity below = tile.func_145831_w().func_147438_o(tile.field_145851_c, tile.field_145848_d - 1, tile.field_145849_e);
        if (below instanceof TileTank) {
            return (TileTank)below;
        }
        return null;
    }

    public static TileTank getTankAbove(TileTank tile) {
        TileEntity above = tile.func_145831_w().func_147438_o(tile.field_145851_c, tile.field_145848_d + 1, tile.field_145849_e);
        if (above instanceof TileTank) {
            return (TileTank)above;
        }
        return null;
    }

    public void moveFluidBelow() {
        TileTank below = TileTank.getTankBelow(this);
        if (below == null) {
            return;
        }
        int used = below.tank.fill(this.tank.getFluid(), true);
        if (used > 0) {
            this.hasUpdate = true;
            below.hasUpdate = true;
            this.tank.drain(used, true);
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        resource = resource.copy();
        int totalUsed = 0;
        TileTank tankToFill = this.getBottomTank();
        FluidStack liquid = tankToFill.tank.getFluid();
        if (liquid != null && liquid.amount > 0 && !liquid.isFluidEqual(resource)) {
            return 0;
        }
        while (tankToFill != null && resource.amount > 0) {
            int used = tankToFill.tank.fill(resource, doFill);
            resource.amount -= used;
            if (used > 0) {
                tankToFill.hasUpdate = true;
            }
            totalUsed += used;
            tankToFill = TileTank.getTankAbove(tankToFill);
        }
        return totalUsed;
    }

    public FluidStack drain(ForgeDirection from, int maxEmpty, boolean doDrain) {
        TileTank bottom = this.getBottomTank();
        bottom.hasUpdate = true;
        return bottom.tank.drain(maxEmpty, doDrain);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        if (!resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection direction) {
        FluidTank compositeTank = new FluidTank(this.tank.getCapacity());
        TileTank tile = this.getBottomTank();
        int capacity = this.tank.getCapacity();
        if (tile == null || tile.tank.getFluid() == null) {
            return new FluidTankInfo[]{compositeTank.getInfo()};
        }
        compositeTank.setFluid(tile.tank.getFluid().copy());
        tile = TileTank.getTankAbove(tile);
        while (tile != null) {
            FluidStack liquid = tile.tank.getFluid();
            if (liquid != null && liquid.amount != 0) {
                if (!compositeTank.getFluid().isFluidEqual(liquid)) break;
                compositeTank.getFluid().amount += liquid.amount;
            }
            capacity += tile.tank.getCapacity();
            tile = TileTank.getTankAbove(tile);
        }
        compositeTank.setCapacity(capacity);
        return new FluidTankInfo[]{compositeTank.getInfo()};
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public int getFluidLightLevel() {
        FluidStack tankFluid = this.tank.getFluid();
        return tankFluid == null ? 0 : tankFluid.getFluid().getLuminosity(tankFluid);
    }
}

