/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.Position;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.gates.IAction;
import buildcraft.api.gates.IActionReceptor;
import buildcraft.api.power.ILaserTarget;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import buildcraft.core.EntityEnergyLaser;
import buildcraft.core.IMachine;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.triggers.ActionMachineControl;
import java.util.LinkedList;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileLaser
extends TileBuildCraft
implements IPowerReceptor,
IActionReceptor,
IMachine {
    private static final float LASER_OFFSET = 0.125f;
    private EntityEnergyLaser laser = null;
    private final SafeTimeTracker laserTickTracker = new SafeTimeTracker(10L);
    private final SafeTimeTracker searchTracker = new SafeTimeTracker(100L, 100L);
    private final SafeTimeTracker networkTracker = new SafeTimeTracker(3L);
    private ILaserTarget laserTarget;
    protected PowerHandler powerHandler;
    private ActionMachineControl.Mode lastMode = ActionMachineControl.Mode.Unknown;
    private static final PowerHandler.PerditionCalculator PERDITION = new PowerHandler.PerditionCalculator(0.5);

    public TileLaser() {
        this.powerHandler = new PowerHandler(this, PowerHandler.Type.MACHINE);
        this.initPowerProvider();
    }

    private void initPowerProvider() {
        this.powerHandler.configure(25.0, 150.0, 25.0, 1000.0);
        this.powerHandler.setPerdition(PERDITION);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.lastMode == ActionMachineControl.Mode.Off) {
            this.removeLaser();
            return;
        }
        if (this.canFindTable()) {
            this.findTable();
        }
        if (!this.isValidTable()) {
            this.removeLaser();
            return;
        }
        if (this.powerHandler.getEnergyStored() == 0.0) {
            this.removeLaser();
            return;
        }
        if (this.laser == null) {
            this.createLaser();
        }
        if (this.laser != null && this.canUpdateLaser()) {
            this.updateLaser();
        }
        double power = this.powerHandler.useEnergy(0.0, this.getMaxPowerSent(), true);
        this.laserTarget.receiveLaserEnergy(power);
        if (this.laser != null) {
            this.laser.pushPower(power);
        }
        this.onPowerSent(power);
        this.sendNetworkUpdate();
    }

    protected float getMaxPowerSent() {
        return 4.0f;
    }

    protected void onPowerSent(double power) {
    }

    protected boolean canFindTable() {
        return this.searchTracker.markTimeIfDelay(this.field_145850_b);
    }

    protected boolean canUpdateLaser() {
        return this.laserTickTracker.markTimeIfDelay(this.field_145850_b);
    }

    protected boolean isValidTable() {
        return this.laserTarget != null && !this.laserTarget.isInvalidTarget() && this.laserTarget.requiresLaserEnergy();
    }

    protected void findTable() {
        int meta = this.func_145832_p();
        int minX = this.field_145851_c - 5;
        int minY = this.field_145848_d - 5;
        int minZ = this.field_145849_e - 5;
        int maxX = this.field_145851_c + 5;
        int maxY = this.field_145848_d + 5;
        int maxZ = this.field_145849_e + 5;
        switch (ForgeDirection.getOrientation((int)meta)) {
            case WEST: {
                maxX = this.field_145851_c;
                break;
            }
            case EAST: {
                minX = this.field_145851_c;
                break;
            }
            case DOWN: {
                maxY = this.field_145848_d;
                break;
            }
            case UP: {
                minY = this.field_145848_d;
                break;
            }
            case NORTH: {
                maxZ = this.field_145849_e;
                break;
            }
            default: {
                minZ = this.field_145849_e;
            }
        }
        LinkedList<ILaserTarget> targets = new LinkedList<ILaserTarget>();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    ILaserTarget table;
                    TileEntity tile = this.field_145850_b.func_147438_o(x, y, z);
                    if (!(tile instanceof ILaserTarget) || !(table = (ILaserTarget)tile).requiresLaserEnergy()) continue;
                    targets.add(table);
                }
            }
        }
        if (targets.isEmpty()) {
            return;
        }
        this.laserTarget = (ILaserTarget)targets.get(this.field_145850_b.field_73012_v.nextInt(targets.size()));
    }

    protected void createLaser() {
        this.laser = new EntityEnergyLaser(this.field_145850_b, new Position(this.field_145851_c, this.field_145848_d, this.field_145849_e), new Position(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        this.field_145850_b.func_72838_d((Entity)this.laser);
    }

    protected void updateLaser() {
        int meta = this.func_145832_p();
        double px = 0.0;
        double py = 0.0;
        double pz = 0.0;
        switch (ForgeDirection.getOrientation((int)meta)) {
            case WEST: {
                px = -0.125;
                break;
            }
            case EAST: {
                px = 0.125;
                break;
            }
            case DOWN: {
                py = -0.125;
                break;
            }
            case UP: {
                py = 0.125;
                break;
            }
            case NORTH: {
                pz = -0.125;
                break;
            }
            default: {
                pz = 0.125;
            }
        }
        Position head = new Position((double)this.field_145851_c + 0.5 + px, (double)this.field_145848_d + 0.5 + py, (double)this.field_145849_e + 0.5 + pz);
        Position tail = new Position((double)this.laserTarget.getXCoord() + 0.475 + ((double)this.field_145850_b.field_73012_v.nextFloat() - 0.5) / 5.0, (float)this.laserTarget.getYCoord() + 0.5625f, (double)this.laserTarget.getZCoord() + 0.475 + ((double)this.field_145850_b.field_73012_v.nextFloat() - 0.5) / 5.0);
        this.laser.setPositions(head, tail);
        if (!this.laser.isVisible()) {
            this.laser.show();
        }
    }

    protected void removeLaser() {
        if (this.laser != null) {
            this.laser.func_70106_y();
            this.laser = null;
        }
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return this.powerHandler.getPowerReceiver();
    }

    @Override
    public void doWork(PowerHandler workProvider) {
    }

    @Override
    public void sendNetworkUpdate() {
        if (this.networkTracker.markTimeIfDelay(this.field_145850_b)) {
            super.sendNetworkUpdate();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.powerHandler.readFromNBT(nbttagcompound);
        this.initPowerProvider();
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        this.powerHandler.writeToNBT(nbttagcompound);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.removeLaser();
    }

    @Override
    public boolean isActive() {
        return this.isValidTable();
    }

    @Override
    public boolean manageFluids() {
        return false;
    }

    @Override
    public boolean manageSolids() {
        return false;
    }

    @Override
    public boolean allowAction(IAction action) {
        return action == BuildCraftCore.actionOn || action == BuildCraftCore.actionOff;
    }

    @Override
    public void actionActivated(IAction action) {
        if (action == BuildCraftCore.actionOn) {
            this.lastMode = ActionMachineControl.Mode.On;
        } else if (action == BuildCraftCore.actionOff) {
            this.lastMode = ActionMachineControl.Mode.Off;
        }
    }
}

