/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftTransport;
import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.GateExpansionController;
import buildcraft.api.gates.IAction;
import buildcraft.api.gates.IActionReceptor;
import buildcraft.api.gates.IGateExpansion;
import buildcraft.api.gates.ITileTrigger;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.gates.ITriggerParameter;
import buildcraft.api.gates.TriggerParameter;
import buildcraft.api.transport.PipeWire;
import buildcraft.core.triggers.ActionRedstoneOutput;
import buildcraft.transport.IPipeTrigger;
import buildcraft.transport.Pipe;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.gates.GateDefinition;
import buildcraft.transport.gates.ItemGate;
import buildcraft.transport.triggers.ActionRedstoneFaderOutput;
import buildcraft.transport.triggers.ActionSignalOutput;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultiset;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public final class Gate {
    public final Pipe pipe;
    public final GateDefinition.GateMaterial material;
    public final GateDefinition.GateLogic logic;
    public final BiMap<IGateExpansion, GateExpansionController> expansions = HashBiMap.create();
    public ITrigger[] triggers = new ITrigger[8];
    public ITriggerParameter[] triggerParameters = new ITriggerParameter[8];
    public IAction[] actions = new IAction[8];
    public BitSet broadcastSignal = new BitSet(PipeWire.VALUES.length);
    public BitSet prevBroadcastSignal = new BitSet(PipeWire.VALUES.length);
    public int redstoneOutput = 0;
    public boolean isPulsing = false;
    private float pulseStage = 0.0f;

    public Gate(Pipe pipe, GateDefinition.GateMaterial material, GateDefinition.GateLogic logic) {
        this.pipe = pipe;
        this.material = material;
        this.logic = logic;
    }

    public void setTrigger(int position, ITrigger trigger) {
        this.triggers[position] = trigger;
    }

    public ITrigger getTrigger(int position) {
        return this.triggers[position];
    }

    public void setAction(int position, IAction action) {
        this.actions[position] = action;
    }

    public IAction getAction(int position) {
        return this.actions[position];
    }

    public void setTriggerParameter(int position, ITriggerParameter p) {
        this.triggerParameters[position] = p;
    }

    public ITriggerParameter getTriggerParameter(int position) {
        return this.triggerParameters[position];
    }

    public void addGateExpansion(IGateExpansion expansion) {
        if (!this.expansions.containsKey((Object)expansion)) {
            this.expansions.put((Object)expansion, (Object)expansion.makeController(this.pipe.container));
        }
    }

    public void writeToNBT(NBTTagCompound data) {
        data.func_74778_a("material", this.material.name());
        data.func_74778_a("logic", this.logic.name());
        NBTTagList exList = new NBTTagList();
        for (GateExpansionController con : this.expansions.values()) {
            NBTTagCompound conNBT = new NBTTagCompound();
            conNBT.func_74778_a("type", con.getType().getUniqueIdentifier());
            NBTTagCompound conData = new NBTTagCompound();
            con.writeToNBT(conData);
            conNBT.func_74782_a("data", (NBTBase)conData);
            exList.func_74742_a((NBTBase)conNBT);
        }
        data.func_74782_a("expansions", (NBTBase)exList);
        for (int i = 0; i < 8; ++i) {
            if (this.triggers[i] != null) {
                data.func_74778_a("trigger[" + i + "]", this.triggers[i].getUniqueTag());
            }
            if (this.actions[i] != null) {
                data.func_74778_a("action[" + i + "]", this.actions[i].getUniqueTag());
            }
            if (this.triggerParameters[i] == null) continue;
            NBTTagCompound cpt = new NBTTagCompound();
            this.triggerParameters[i].writeToNBT(cpt);
            data.func_74782_a("triggerParameters[" + i + "]", (NBTBase)cpt);
        }
        for (PipeWire wire : PipeWire.VALUES) {
            data.func_74757_a("wireState[" + wire.ordinal() + "]", this.broadcastSignal.get(wire.ordinal()));
        }
        data.func_74774_a("redstoneOutput", (byte)this.redstoneOutput);
    }

    public void readFromNBT(NBTTagCompound data) {
        for (int i = 0; i < 8; ++i) {
            if (data.func_74764_b("trigger[" + i + "]")) {
                this.triggers[i] = ActionManager.triggers.get(data.func_74779_i("trigger[" + i + "]"));
            }
            if (data.func_74764_b("action[" + i + "]")) {
                this.actions[i] = ActionManager.actions.get(data.func_74779_i("action[" + i + "]"));
            }
            if (!data.func_74764_b("triggerParameters[" + i + "]")) continue;
            this.triggerParameters[i] = new TriggerParameter();
            this.triggerParameters[i].readFromNBT(data.func_74775_l("triggerParameters[" + i + "]"));
        }
        for (PipeWire wire : PipeWire.VALUES) {
            this.broadcastSignal.set(wire.ordinal(), data.func_74767_n("wireState[" + wire.ordinal() + "]"));
        }
        this.redstoneOutput = data.func_74771_c("redstoneOutput");
    }

    public void openGui(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            player.openGui((Object)BuildCraftTransport.instance, 51, this.pipe.container.func_145831_w(), this.pipe.container.field_145851_c, this.pipe.container.field_145848_d, this.pipe.container.field_145849_e);
        }
    }

    public void updatePulse() {
        this.pulseStage = this.pipe.container.renderState.isGatePulsing() || this.pulseStage > 0.11f ? (this.pulseStage + 0.01f) % 1.0f : 0.0f;
    }

    public void tick() {
        for (GateExpansionController expansion : this.expansions.values()) {
            expansion.tick();
        }
    }

    public ItemStack getGateItem() {
        return ItemGate.makeGateItem(this);
    }

    public void dropGate() {
        this.pipe.dropItem(this.getGateItem());
    }

    public void resetGate() {
        if (this.redstoneOutput != 0) {
            this.redstoneOutput = 0;
            this.pipe.updateNeighbors(true);
        }
    }

    public boolean isGateActive() {
        for (GateExpansionController expansion : this.expansions.values()) {
            if (!expansion.isActive()) continue;
            return true;
        }
        return this.redstoneOutput > 0 || !this.broadcastSignal.isEmpty();
    }

    public boolean isGatePulsing() {
        return this.isPulsing;
    }

    public int getRedstoneOutput() {
        return this.redstoneOutput;
    }

    public void startResolution() {
        for (GateExpansionController expansion : this.expansions.values()) {
            expansion.startResolution();
        }
    }

    public void resolveActions() {
        IAction action;
        int oldRedstoneOutput = this.redstoneOutput;
        this.redstoneOutput = 0;
        BitSet temp = this.prevBroadcastSignal;
        temp.clear();
        this.prevBroadcastSignal = this.broadcastSignal;
        this.broadcastSignal = temp;
        this.startResolution();
        HashMap<IAction, Boolean> activeActions = new HashMap<IAction, Boolean>();
        HashMultiset actionCount = HashMultiset.create();
        for (int it = 0; it < 8; ++it) {
            ITrigger trigger = this.triggers[it];
            action = this.actions[it];
            ITriggerParameter parameter = this.triggerParameters[it];
            if (trigger == null || action == null) continue;
            actionCount.add((Object)action);
            if (!activeActions.containsKey(action)) {
                activeActions.put(action, this.isNearbyTriggerActive(trigger, parameter));
                continue;
            }
            if (this.logic == GateDefinition.GateLogic.AND) {
                activeActions.put(action, (Boolean)activeActions.get(action) != false && this.isNearbyTriggerActive(trigger, parameter));
                continue;
            }
            activeActions.put(action, (Boolean)activeActions.get(action) != false || this.isNearbyTriggerActive(trigger, parameter));
        }
        for (Map.Entry entry : activeActions.entrySet()) {
            if (!((Boolean)entry.getValue()).booleanValue() || this.resolveAction(action = (IAction)entry.getKey(), actionCount.count((Object)action))) continue;
            if (action instanceof ActionRedstoneOutput) {
                this.redstoneOutput = 15;
                continue;
            }
            if (action instanceof ActionRedstoneFaderOutput) {
                this.redstoneOutput = ((ActionRedstoneFaderOutput)action).level;
                continue;
            }
            if (action instanceof ActionSignalOutput) {
                this.broadcastSignal.set(((ActionSignalOutput)action).color.ordinal());
                continue;
            }
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tile = this.pipe.container.getTile(side);
                if (!(tile instanceof IActionReceptor)) continue;
                IActionReceptor recept = (IActionReceptor)tile;
                recept.actionActivated(action);
            }
        }
        this.pipe.actionsActivated(activeActions);
        if (oldRedstoneOutput != this.redstoneOutput) {
            if (this.redstoneOutput == 0 ^ oldRedstoneOutput == 0) {
                this.pipe.container.scheduleRenderUpdate();
            }
            this.pipe.updateNeighbors(true);
        }
        if (!this.prevBroadcastSignal.equals(this.broadcastSignal)) {
            this.pipe.container.scheduleRenderUpdate();
            this.pipe.updateSignalState();
        }
    }

    public boolean resolveAction(IAction action, int count) {
        for (GateExpansionController expansion : this.expansions.values()) {
            if (!expansion.resolveAction(action, count)) continue;
            return true;
        }
        return false;
    }

    public boolean isNearbyTriggerActive(ITrigger trigger, ITriggerParameter parameter) {
        if (trigger == null) {
            return false;
        }
        if (trigger instanceof IPipeTrigger) {
            return ((IPipeTrigger)trigger).isTriggerActive(this.pipe, parameter);
        }
        if (trigger instanceof ITileTrigger) {
            for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tile = this.pipe.container.getTile(o);
                if (tile == null || tile instanceof TileGenericPipe || !((ITileTrigger)trigger).isTriggerActive(o.getOpposite(), tile, parameter)) continue;
                return true;
            }
            return false;
        }
        for (GateExpansionController expansion : this.expansions.values()) {
            if (!expansion.isTriggerActive(trigger, parameter)) continue;
            return true;
        }
        return false;
    }

    public void addTrigger(List<ITrigger> list) {
        for (PipeWire wire : PipeWire.VALUES) {
            if (!this.pipe.wireSet[wire.ordinal()] || this.material.ordinal() < wire.ordinal()) continue;
            list.add(BuildCraftTransport.triggerPipeWireActive[wire.ordinal()]);
            list.add(BuildCraftTransport.triggerPipeWireInactive[wire.ordinal()]);
        }
        for (GateExpansionController expansion : this.expansions.values()) {
            expansion.addTriggers(list);
        }
    }

    public void addActions(List<IAction> list) {
        for (PipeWire wire : PipeWire.VALUES) {
            if (!this.pipe.wireSet[wire.ordinal()] || this.material.ordinal() < wire.ordinal()) continue;
            list.add(BuildCraftTransport.actionPipeWire[wire.ordinal()]);
        }
        for (GateExpansionController expansion : this.expansions.values()) {
            expansion.addActions(list);
        }
    }

    public void setPulsing(boolean pulsing) {
        if (pulsing != this.isPulsing) {
            this.isPulsing = pulsing;
            this.pipe.container.scheduleRenderUpdate();
        }
    }

    public float getPulseStage() {
        return this.pulseStage;
    }
}

