/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.core.utils.BCLog;
import buildcraft.transport.TileFilteredBuffer;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.gui.ContainerDiamondPipe;
import buildcraft.transport.gui.ContainerEmeraldPipe;
import buildcraft.transport.gui.ContainerEmzuliPipe;
import buildcraft.transport.gui.ContainerFilteredBuffer;
import buildcraft.transport.gui.ContainerGateInterface;
import buildcraft.transport.gui.GuiDiamondPipe;
import buildcraft.transport.gui.GuiEmeraldPipe;
import buildcraft.transport.gui.GuiEmzuliPipe;
import buildcraft.transport.gui.GuiFilteredBuffer;
import buildcraft.transport.gui.GuiGateInterface;
import buildcraft.transport.pipes.PipeItemsDiamond;
import buildcraft.transport.pipes.PipeItemsEmerald;
import buildcraft.transport.pipes.PipeItemsEmzuli;
import cpw.mods.fml.common.network.IGuiHandler;
import java.util.logging.Level;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class GuiHandler
implements IGuiHandler {
    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        try {
            if (!world.func_72899_e(x, y, z)) {
                return null;
            }
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile instanceof TileFilteredBuffer) {
                TileFilteredBuffer filteredBuffer = (TileFilteredBuffer)tile;
                return new ContainerFilteredBuffer(player.field_71071_by, filteredBuffer);
            }
            if (!(tile instanceof TileGenericPipe)) {
                return null;
            }
            TileGenericPipe pipe = (TileGenericPipe)tile;
            if (pipe.pipe == null) {
                return null;
            }
            switch (ID) {
                case 50: {
                    return new ContainerDiamondPipe((IInventory)player.field_71071_by, (PipeItemsDiamond)pipe.pipe);
                }
                case 52: {
                    return new ContainerEmeraldPipe((IInventory)player.field_71071_by, (PipeItemsEmerald)pipe.pipe);
                }
                case 53: {
                    return new ContainerEmzuliPipe((IInventory)player.field_71071_by, (PipeItemsEmzuli)pipe.pipe);
                }
                case 51: {
                    if (!pipe.pipe.hasGate()) break;
                    return new ContainerGateInterface((IInventory)player.field_71071_by, pipe.pipe);
                }
            }
            return null;
        }
        catch (Exception ex) {
            BCLog.logger.log(Level.SEVERE, "Failed to open GUI", ex);
            return null;
        }
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        try {
            if (!world.func_72899_e(x, y, z)) {
                return null;
            }
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile instanceof TileFilteredBuffer) {
                TileFilteredBuffer filteredBuffer = (TileFilteredBuffer)tile;
                return new GuiFilteredBuffer(player.field_71071_by, filteredBuffer);
            }
            if (!(tile instanceof TileGenericPipe)) {
                return null;
            }
            TileGenericPipe pipe = (TileGenericPipe)tile;
            if (pipe.pipe == null) {
                return null;
            }
            switch (ID) {
                case 50: {
                    return new GuiDiamondPipe((IInventory)player.field_71071_by, (PipeItemsDiamond)pipe.pipe);
                }
                case 52: {
                    return new GuiEmeraldPipe((IInventory)player.field_71071_by, (PipeItemsEmerald)pipe.pipe);
                }
                case 53: {
                    return new GuiEmzuliPipe((IInventory)player.field_71071_by, (PipeItemsEmzuli)pipe.pipe);
                }
                case 51: {
                    if (!pipe.pipe.hasGate()) break;
                    return new GuiGateInterface((IInventory)player.field_71071_by, pipe.pipe);
                }
            }
            return null;
        }
        catch (Exception ex) {
            BCLog.logger.log(Level.SEVERE, "Failed to open GUI", ex);
            return null;
        }
    }
}

