/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.Position;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.gates.GateExpansions;
import buildcraft.api.gates.IGateExpansion;
import buildcraft.api.gates.IOverrideDefaultTriggers;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.PipeWire;
import buildcraft.core.DefaultProps;
import buildcraft.core.IDropControlInventory;
import buildcraft.core.ITileBufferHolder;
import buildcraft.core.TileBuffer;
import buildcraft.core.inventory.InvUtils;
import buildcraft.core.network.BuildCraftPacket;
import buildcraft.core.network.IClientState;
import buildcraft.core.network.IGuiReturnHandler;
import buildcraft.core.network.ISyncedTile;
import buildcraft.core.network.PacketTileState;
import buildcraft.core.utils.BCLog;
import buildcraft.core.utils.Utils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.IPipeConnectionForced;
import buildcraft.transport.ISolidSideTile;
import buildcraft.transport.ItemFacade;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeRenderState;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.gates.GateDefinition;
import buildcraft.transport.gates.GateFactory;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileGenericPipe
extends TileEntity
implements IPowerReceptor,
IFluidHandler,
IPipeTile,
IOverrideDefaultTriggers,
ITileBufferHolder,
IDropControlInventory,
ISyncedTile,
ISolidSideTile,
IGuiReturnHandler {
    public final PipeRenderState renderState = new PipeRenderState();
    public final CoreState coreState = new CoreState();
    private boolean deletePipe = false;
    private TileBuffer[] tileBuffer;
    public boolean[] pipeConnectionsBuffer = new boolean[6];
    public SafeTimeTracker networkSyncTracker = new SafeTimeTracker();
    public Pipe pipe;
    private boolean sendClientUpdate = false;
    private boolean blockNeighborChange = false;
    private boolean refreshRenderState = false;
    private boolean pipeBound = false;
    private boolean resyncGateExpansions = false;
    public int redstoneInput = 0;
    private Block[] facadeBlocks = new Block[ForgeDirection.VALID_DIRECTIONS.length];
    private int[] facadeMeta = new int[ForgeDirection.VALID_DIRECTIONS.length];
    private boolean[] plugs = new boolean[ForgeDirection.VALID_DIRECTIONS.length];
    public boolean initialized = false;

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74774_a("redstoneInput", (byte)this.redstoneInput);
        if (this.pipe != null) {
            nbt.func_74768_a("pipeId", Item.field_150901_e.func_148757_b((Object)this.pipe.item));
            this.pipe.writeToNBT(nbt);
        } else {
            nbt.func_74768_a("pipeId", this.coreState.pipeId);
        }
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            if (this.facadeBlocks[i] == null) {
                nbt.func_74768_a("facadeBlocks[" + i + "]", 0);
            } else {
                nbt.func_74768_a("facadeBlocks[" + i + "]", Block.field_149771_c.func_148757_b((Object)this.facadeBlocks[i]));
            }
            nbt.func_74768_a("facadeMeta[" + i + "]", this.facadeMeta[i]);
            nbt.func_74757_a("plug[" + i + "]", this.plugs[i]);
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.redstoneInput = nbt.func_74771_c("redstoneInput");
        this.coreState.pipeId = nbt.func_74762_e("pipeId");
        this.pipe = BlockGenericPipe.createPipe((Item)Item.field_150901_e.func_148754_a(this.coreState.pipeId));
        this.bindPipe();
        if (this.pipe != null) {
            this.pipe.readFromNBT(nbt);
        } else {
            BCLog.logger.log(Level.WARNING, "Pipe failed to load from NBT at {0},{1},{2}", new Object[]{this.field_145851_c, this.field_145848_d, this.field_145849_e});
            this.deletePipe = true;
        }
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            int blockId = nbt.func_74762_e("facadeBlocks[" + i + "]");
            this.facadeBlocks[i] = blockId != 0 ? (Block)Block.field_149771_c.func_148754_a(blockId) : null;
            this.facadeMeta[i] = nbt.func_74762_e("facadeMeta[" + i + "]");
            this.plugs[i] = nbt.func_74767_n("plug[" + i + "]");
        }
    }

    public void func_145843_s() {
        this.initialized = false;
        this.tileBuffer = null;
        if (this.pipe != null) {
            this.pipe.invalidate();
        }
        super.func_145843_s();
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.initialized = false;
        this.tileBuffer = null;
        this.bindPipe();
        if (this.pipe != null) {
            this.pipe.validate();
        }
    }

    public void func_145845_h() {
        PowerHandler.PowerReceiver provider;
        if (!this.field_145850_b.field_72995_K) {
            if (this.deletePipe) {
                this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (this.pipe == null) {
                return;
            }
            if (!this.initialized) {
                this.initialize(this.pipe);
            }
        }
        if (!BlockGenericPipe.isValid(this.pipe)) {
            return;
        }
        this.pipe.updateEntity();
        if (this.field_145850_b.field_72995_K) {
            if (this.resyncGateExpansions) {
                this.syncGateExpansions();
            }
            return;
        }
        if (this.blockNeighborChange) {
            this.computeConnections();
            this.pipe.onNeighborBlockChange(0);
            this.blockNeighborChange = false;
            this.refreshRenderState = true;
        }
        if (this.refreshRenderState) {
            this.refreshRenderState();
            this.refreshRenderState = false;
        }
        if ((provider = this.getPowerReceiver(null)) != null) {
            provider.update();
        }
        if (this.sendClientUpdate) {
            this.sendClientUpdate = false;
            if (this.field_145850_b instanceof WorldServer) {
                WorldServer world = (WorldServer)this.field_145850_b;
                BuildCraftPacket updatePacket = this.getBCDescriptionPacket();
                for (Object o : world.field_73010_i) {
                    EntityPlayerMP player = (EntityPlayerMP)o;
                    if (!world.func_73040_p().func_72694_a(player, this.field_145851_c >> 4, this.field_145849_e >> 4)) continue;
                    BuildCraftCore.instance.sendToPlayer((EntityPlayer)player, updatePacket);
                }
            }
        }
    }

    private void refreshRenderState() {
        for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
            this.renderState.pipeConnectionMatrix.setConnected(forgeDirection, this.pipeConnectionsBuffer[forgeDirection.ordinal()]);
        }
        for (int i = 0; i < 7; ++i) {
            ForgeDirection o = ForgeDirection.getOrientation((int)i);
            this.renderState.textureMatrix.setIconIndex(o, this.pipe.getIconIndex(o));
        }
        block8: for (PipeWire pipeWire : PipeWire.values()) {
            this.renderState.wireMatrix.setWire(pipeWire, this.pipe.wireSet[pipeWire.ordinal()]);
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                this.renderState.wireMatrix.setWireConnected(pipeWire, direction, this.pipe.isWireConnectedTo(this.getTile(direction), pipeWire));
            }
            boolean lit = this.pipe.signalStrength[pipeWire.ordinal()] > 0;
            switch (pipeWire) {
                case RED: {
                    this.renderState.wireMatrix.setWireIndex(pipeWire, lit ? 1 : 0);
                    continue block8;
                }
                case BLUE: {
                    this.renderState.wireMatrix.setWireIndex(pipeWire, lit ? 3 : 2);
                    continue block8;
                }
                case GREEN: {
                    this.renderState.wireMatrix.setWireIndex(pipeWire, lit ? 5 : 4);
                    continue block8;
                }
                case YELLOW: {
                    this.renderState.wireMatrix.setWireIndex(pipeWire, lit ? 7 : 6);
                    continue block8;
                }
            }
        }
        this.renderState.setIsGateLit(this.pipe.gate != null ? this.pipe.gate.isGateActive() : false);
        this.renderState.setIsGatePulsing(this.pipe.gate != null ? this.pipe.gate.isGatePulsing() : false);
        for (PipeWire pipeWire : ForgeDirection.VALID_DIRECTIONS) {
            Block block = this.facadeBlocks[pipeWire.ordinal()];
            this.renderState.facadeMatrix.setFacade((ForgeDirection)pipeWire, block, this.facadeMeta[pipeWire.ordinal()]);
        }
        for (PipeWire pipeWire : ForgeDirection.VALID_DIRECTIONS) {
            this.renderState.plugMatrix.setConnected((ForgeDirection)pipeWire, this.plugs[pipeWire.ordinal()]);
        }
        if (this.renderState.isDirty()) {
            this.renderState.clean();
            this.sendUpdateToClient();
        }
    }

    public void initialize(Pipe pipe) {
        this.field_145854_h = this.func_145838_q();
        if (pipe == null) {
            BCLog.logger.log(Level.WARNING, "Pipe failed to initialize at {0},{1},{2}, deleting", new Object[]{this.field_145851_c, this.field_145848_d, this.field_145849_e});
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return;
        }
        this.pipe = pipe;
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = this.getTile(o);
            if (tile instanceof ITileBufferHolder) {
                ((ITileBufferHolder)tile).blockCreated(o, (Block)BuildCraftTransport.genericPipeBlock, this);
            }
            if (!(tile instanceof TileGenericPipe)) continue;
            ((TileGenericPipe)tile).scheduleNeighborChange();
        }
        this.bindPipe();
        this.computeConnections();
        this.scheduleRenderUpdate();
        if (pipe.needsInit()) {
            pipe.initialize();
        }
        this.initialized = true;
    }

    private void bindPipe() {
        if (!this.pipeBound && this.pipe != null) {
            this.pipe.setTile(this);
            this.coreState.pipeId = Item.func_150891_b((Item)this.pipe.item);
            this.pipeBound = true;
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe instanceof IPowerReceptor) {
            return ((IPowerReceptor)((Object)this.pipe)).getPowerReceiver(null);
        }
        return null;
    }

    @Override
    public void doWork(PowerHandler workProvider) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe instanceof IPowerReceptor) {
            ((IPowerReceptor)((Object)this.pipe)).doWork(workProvider);
        }
    }

    public void scheduleNeighborChange() {
        this.blockNeighborChange = true;
    }

    @Override
    public int injectItem(ItemStack payload, boolean doAdd, ForgeDirection from) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof PipeTransportItems && this.isPipeConnected(from)) {
            if (doAdd) {
                Position itemPos = new Position((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, from.getOpposite());
                itemPos.moveBackwards(0.4);
                TravelingItem pipedItem = TravelingItem.make(itemPos.x, itemPos.y, itemPos.z, payload);
                ((PipeTransportItems)this.pipe.transport).injectItem(pipedItem, itemPos.orientation);
            }
            return payload.field_77994_a;
        }
        return 0;
    }

    @Override
    public IPipeTile.PipeType getPipeType() {
        if (BlockGenericPipe.isValid(this.pipe)) {
            return ((PipeTransport)this.pipe.transport).getPipeType();
        }
        return null;
    }

    public BuildCraftPacket getBCDescriptionPacket() {
        this.bindPipe();
        PacketTileState packet = new PacketTileState(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.coreState.expansions.clear();
        if (this.pipe != null && this.pipe.gate != null) {
            this.coreState.gateMaterial = this.pipe.gate.material.ordinal();
            this.coreState.gateLogic = this.pipe.gate.logic.ordinal();
            for (IGateExpansion ex : this.pipe.gate.expansions.keySet()) {
                this.coreState.expansions.add(GateExpansions.getServerExpansionID(ex.getUniqueIdentifier()));
            }
        } else {
            this.coreState.gateMaterial = -1;
            this.coreState.gateLogic = -1;
        }
        if (this.pipe != null && this.pipe.transport != null) {
            ((PipeTransport)this.pipe.transport).sendDescriptionPacket();
        }
        packet.addStateForSerialization((byte)0, this.coreState);
        packet.addStateForSerialization((byte)1, this.renderState);
        if (this.pipe instanceof IClientState) {
            packet.addStateForSerialization((byte)2, (IClientState)((Object)this.pipe));
        }
        return packet;
    }

    public Packet func_145844_m() {
        return Utils.toPacket(this.getBCDescriptionPacket(), 1);
    }

    public void sendUpdateToClient() {
        this.sendClientUpdate = true;
    }

    @Override
    public LinkedList<ITrigger> getTriggers() {
        LinkedList<ITrigger> result = new LinkedList<ITrigger>();
        if (BlockGenericPipe.isFullyDefined(this.pipe) && this.pipe.hasGate()) {
            result.add(BuildCraftCore.triggerRedstoneActive);
            result.add(BuildCraftCore.triggerRedstoneInactive);
        }
        return result;
    }

    @Override
    public void blockRemoved(ForgeDirection from) {
    }

    public TileBuffer[] getTileCache() {
        if (this.tileBuffer == null && this.pipe != null) {
            this.tileBuffer = TileBuffer.makeBuffer(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ((PipeTransport)this.pipe.transport).delveIntoUnloadedChunks());
        }
        return this.tileBuffer;
    }

    @Override
    public void blockCreated(ForgeDirection from, Block block, TileEntity tile) {
        TileBuffer[] cache = this.getTileCache();
        if (cache != null) {
            cache[from.getOpposite().ordinal()].set(block, tile);
        }
    }

    @Override
    public Block getBlock(ForgeDirection to) {
        TileBuffer[] cache = this.getTileCache();
        if (cache != null) {
            return cache[to.ordinal()].getBlock();
        }
        return null;
    }

    @Override
    public TileEntity getTile(ForgeDirection to) {
        TileBuffer[] cache = this.getTileCache();
        if (cache != null) {
            return cache[to.ordinal()].getTile();
        }
        return null;
    }

    protected boolean canPipeConnect(TileEntity with, ForgeDirection side) {
        IPipeConnection.ConnectOverride override;
        if (with == null) {
            return false;
        }
        if (this.hasPlug(side)) {
            return false;
        }
        if (!BlockGenericPipe.isValid(this.pipe)) {
            return false;
        }
        if (!(this.pipe instanceof IPipeConnectionForced && ((IPipeConnectionForced)((Object)this.pipe)).ignoreConnectionOverrides(side) || !(with instanceof IPipeConnection) || (override = ((IPipeConnection)with).overridePipeConnection(((PipeTransport)this.pipe.transport).getPipeType(), side.getOpposite())) == IPipeConnection.ConnectOverride.DEFAULT)) {
            return override == IPipeConnection.ConnectOverride.CONNECT;
        }
        if (with instanceof TileGenericPipe) {
            if (((TileGenericPipe)with).hasPlug(side.getOpposite())) {
                return false;
            }
            Pipe otherPipe = ((TileGenericPipe)with).pipe;
            if (!BlockGenericPipe.isValid(otherPipe)) {
                return false;
            }
            if (!otherPipe.canPipeConnect(this, side.getOpposite())) {
                return false;
            }
        }
        return this.pipe.canPipeConnect(with, side);
    }

    private void computeConnections() {
        TileBuffer[] cache = this.getTileCache();
        if (cache == null) {
            return;
        }
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileBuffer t = cache[side.ordinal()];
            t.refresh();
            this.pipeConnectionsBuffer[side.ordinal()] = this.canPipeConnect(t.getTile(), side);
        }
    }

    @Override
    public boolean isPipeConnected(ForgeDirection with) {
        if (this.field_145850_b.field_72995_K) {
            return this.renderState.pipeConnectionMatrix.isConnected(with);
        }
        return this.pipeConnectionsBuffer[with.ordinal()];
    }

    @Override
    public boolean isWireActive(PipeWire wire) {
        if (this.pipe == null) {
            return false;
        }
        return this.pipe.signalStrength[wire.ordinal()] > 0;
    }

    @Override
    public boolean doDrop() {
        if (BlockGenericPipe.isValid(this.pipe)) {
            return this.pipe.doDrop();
        }
        return false;
    }

    public void onChunkUnload() {
        if (this.pipe != null) {
            this.pipe.onChunkUnload();
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof IFluidHandler && !this.hasPlug(from)) {
            return ((IFluidHandler)this.pipe.transport).fill(from, resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof IFluidHandler && !this.hasPlug(from)) {
            return ((IFluidHandler)this.pipe.transport).drain(from, maxDrain, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof IFluidHandler && !this.hasPlug(from)) {
            return ((IFluidHandler)this.pipe.transport).drain(from, resource, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof IFluidHandler && !this.hasPlug(from)) {
            return ((IFluidHandler)this.pipe.transport).canFill(from, fluid);
        }
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof IFluidHandler && !this.hasPlug(from)) {
            return ((IFluidHandler)this.pipe.transport).canDrain(from, fluid);
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return null;
    }

    public void scheduleRenderUpdate() {
        this.refreshRenderState = true;
    }

    public boolean addFacade(ForgeDirection direction, Block block, int meta) {
        if (this.func_145831_w().field_72995_K) {
            return false;
        }
        if (this.facadeBlocks[direction.ordinal()] == block) {
            return false;
        }
        if (this.hasFacade(direction)) {
            this.dropFacadeItem(direction);
        }
        this.facadeBlocks[direction.ordinal()] = block;
        this.facadeMeta[direction.ordinal()] = meta;
        this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getBlock());
        this.scheduleRenderUpdate();
        return true;
    }

    public boolean hasFacade(ForgeDirection direction) {
        if (direction == null || direction == ForgeDirection.UNKNOWN) {
            return false;
        }
        if (this.func_145831_w().field_72995_K) {
            return this.renderState.facadeMatrix.getFacadeBlock(direction) != null;
        }
        return this.facadeBlocks[direction.ordinal()] != null;
    }

    private void dropFacadeItem(ForgeDirection direction) {
        InvUtils.dropItems(this.field_145850_b, ItemFacade.getStack(this.facadeBlocks[direction.ordinal()], this.facadeMeta[direction.ordinal()]), this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean dropFacade(ForgeDirection direction) {
        if (!this.hasFacade(direction)) {
            return false;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.dropFacadeItem(direction);
            this.facadeBlocks[direction.ordinal()] = null;
            this.facadeMeta[direction.ordinal()] = 0;
            this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getBlock());
            this.scheduleRenderUpdate();
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIconProvider getPipeIcons() {
        if (this.pipe == null) {
            return null;
        }
        return this.pipe.getIconProvider();
    }

    @Override
    public IClientState getStateInstance(byte stateId) {
        switch (stateId) {
            case 0: {
                return this.coreState;
            }
            case 1: {
                return this.renderState;
            }
            case 2: {
                return (IClientState)((Object)this.pipe);
            }
        }
        throw new RuntimeException("Unknown state requested: " + stateId + " this is a bug!");
    }

    @Override
    public void afterStateUpdated(byte stateId) {
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        switch (stateId) {
            case 0: {
                if (this.pipe == null && this.coreState.pipeId != 0) {
                    this.initialize(BlockGenericPipe.createPipe((Item)Item.field_150901_e.func_148754_a(this.coreState.pipeId)));
                }
                if (this.pipe == null) break;
                if (this.coreState.gateMaterial == -1) {
                    this.pipe.gate = null;
                } else if (this.pipe.gate == null) {
                    this.pipe.gate = GateFactory.makeGate(this.pipe, GateDefinition.GateMaterial.fromOrdinal(this.coreState.gateMaterial), GateDefinition.GateLogic.fromOrdinal(this.coreState.gateLogic));
                }
                this.syncGateExpansions();
                this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                break;
            }
            case 1: {
                if (!this.renderState.needsRenderUpdate()) break;
                this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.renderState.clean();
            }
        }
    }

    private void syncGateExpansions() {
        this.resyncGateExpansions = false;
        if (this.pipe.gate != null && !this.coreState.expansions.isEmpty()) {
            for (byte id : this.coreState.expansions) {
                IGateExpansion ex = GateExpansions.getExpansionClient(id);
                if (ex != null) {
                    if (this.pipe.gate.expansions.containsKey((Object)ex)) continue;
                    this.pipe.gate.addGateExpansion(ex);
                    continue;
                }
                this.resyncGateExpansions = true;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return DefaultProps.PIPE_CONTENTS_RENDER_DIST * DefaultProps.PIPE_CONTENTS_RENDER_DIST;
    }

    public boolean shouldRefresh(Block oldBlock, Block newBlock, int oldMeta, int newMeta, World world, int x, int y, int z) {
        return oldBlock != newBlock;
    }

    @Override
    public boolean isSolidOnSide(ForgeDirection side) {
        if (this.hasFacade(side)) {
            return true;
        }
        return BlockGenericPipe.isValid(this.pipe) && this.pipe instanceof ISolidSideTile && ((ISolidSideTile)((Object)this.pipe)).isSolidOnSide(side);
    }

    public boolean hasPlug(ForgeDirection side) {
        if (side == null || side == ForgeDirection.UNKNOWN) {
            return false;
        }
        if (this.func_145831_w().field_72995_K) {
            return this.renderState.plugMatrix.isConnected(side);
        }
        return this.plugs[side.ordinal()];
    }

    public boolean removeAndDropPlug(ForgeDirection side) {
        if (!this.hasPlug(side)) {
            return false;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.plugs[side.ordinal()] = false;
            InvUtils.dropItems(this.field_145850_b, new ItemStack(BuildCraftTransport.plugItem), this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getBlock());
            this.scheduleNeighborChange();
            this.scheduleRenderUpdate();
        }
        return true;
    }

    public boolean addPlug(ForgeDirection forgeDirection) {
        if (this.hasPlug(forgeDirection)) {
            return false;
        }
        this.plugs[forgeDirection.ordinal()] = true;
        this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getBlock());
        this.scheduleNeighborChange();
        this.scheduleRenderUpdate();
        return true;
    }

    public Block getBlock() {
        return this.func_145838_q();
    }

    @Override
    public World getWorld() {
        return this.field_145850_b;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this;
    }

    @Override
    public void writeGuiData(ByteBuf data) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe instanceof IGuiReturnHandler) {
            ((IGuiReturnHandler)((Object)this.pipe)).writeGuiData(data);
        }
    }

    @Override
    public void readGuiData(ByteBuf data, EntityPlayer sender) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe instanceof IGuiReturnHandler) {
            ((IGuiReturnHandler)((Object)this.pipe)).readGuiData(data, sender);
        }
    }

    public class CoreState
    implements IClientState {
        public int pipeId = -1;
        public int gateMaterial = -1;
        public int gateLogic = -1;
        public final Set<Byte> expansions = new HashSet<Byte>();

        @Override
        public void writeData(ByteBuf data) {
            data.writeInt(this.pipeId);
            data.writeByte(this.gateMaterial);
            data.writeByte(this.gateLogic);
            data.writeByte(this.expansions.size());
            for (Byte expansion : this.expansions) {
                data.writeByte((int)expansion.byteValue());
            }
        }

        @Override
        public void readData(ByteBuf data) {
            this.pipeId = data.readInt();
            this.gateMaterial = data.readByte();
            this.gateLogic = data.readByte();
            this.expansions.clear();
            int numExp = data.readByte();
            for (int i = 0; i < numExp; ++i) {
                this.expansions.add(data.readByte());
            }
        }
    }
}

