/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gates;

import buildcraft.BuildCraftTransport;
import buildcraft.api.gates.GateExpansionController;
import buildcraft.api.gates.IGateExpansion;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.gates.ITriggerParameter;
import buildcraft.transport.gates.GateExpansionBuildcraft;
import buildcraft.transport.triggers.TriggerClockTimer;
import java.util.List;
import net.minecraft.tileentity.TileEntity;

public class GateExpansionTimer
extends GateExpansionBuildcraft
implements IGateExpansion {
    public static GateExpansionTimer INSTANCE = new GateExpansionTimer();

    private GateExpansionTimer() {
        super("timer");
    }

    @Override
    public GateExpansionController makeController(TileEntity pipeTile) {
        return new GateExpansionControllerTimer(pipeTile);
    }

    private class GateExpansionControllerTimer
    extends GateExpansionController {
        private final Timer[] timers;

        public GateExpansionControllerTimer(TileEntity pipeTile) {
            super(GateExpansionTimer.this, pipeTile);
            this.timers = new Timer[TriggerClockTimer.Time.VALUES.length];
            for (TriggerClockTimer.Time time : TriggerClockTimer.Time.VALUES) {
                this.timers[time.ordinal()] = new Timer(time);
            }
        }

        @Override
        public boolean isTriggerActive(ITrigger trigger, ITriggerParameter parameter) {
            if (trigger instanceof TriggerClockTimer) {
                TriggerClockTimer timerTrigger = (TriggerClockTimer)trigger;
                return this.timers[timerTrigger.time.ordinal()].isActive();
            }
            return super.isTriggerActive(trigger, parameter);
        }

        @Override
        public void addTriggers(List<ITrigger> list) {
            super.addTriggers(list);
            for (TriggerClockTimer.Time time : TriggerClockTimer.Time.VALUES) {
                list.add(BuildCraftTransport.triggerTimer[time.ordinal()]);
            }
        }

        @Override
        public void tick() {
            for (Timer timer : this.timers) {
                timer.tick();
            }
        }

        private class Timer {
            private static final int ACTIVE_TIME = 5;
            private final TriggerClockTimer.Time time;
            private int clock;

            public Timer(TriggerClockTimer.Time time) {
                this.time = time;
            }

            public void tick() {
                this.clock = this.clock > -5 ? --this.clock : this.time.delay * 20 + 5;
            }

            public boolean isActive() {
                return this.clock < 0;
            }
        }
    }
}

