/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.Position;
import buildcraft.api.inventory.ISpecialInventory;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.PipeManager;
import buildcraft.core.inventory.InvUtils;
import buildcraft.core.inventory.InventoryWrapper;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.pipes.PipeLogicWood;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeItemsWood
extends Pipe<PipeTransportItems>
implements IPowerReceptor {
    protected PowerHandler powerHandler;
    protected int standardIconIndex = PipeIconProvider.TYPE.PipeItemsWood_Standard.ordinal();
    protected int solidIconIndex = PipeIconProvider.TYPE.PipeAllWood_Solid.ordinal();
    private PipeLogicWood logic = new PipeLogicWood(this){

        @Override
        protected boolean isValidConnectingTile(TileEntity tile) {
            if (tile instanceof IPipeTile) {
                return false;
            }
            if (!(tile instanceof IInventory)) {
                return false;
            }
            return PipeManager.canExtractItems(this.pipe, tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
        }
    };

    public PipeItemsWood(Item item) {
        super(new PipeTransportItems(), item);
        this.powerHandler = new PowerHandler(this, PowerHandler.Type.MACHINE);
        this.powerHandler.configure(1.0, 64.1f, 1.0, 64.1f);
        this.powerHandler.configurePowerPerdition(0, 0);
    }

    @Override
    public boolean blockActivated(EntityPlayer entityplayer) {
        return this.logic.blockActivated(entityplayer);
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        this.logic.onNeighborBlockChange(blockId);
        super.onNeighborBlockChange(blockId);
    }

    @Override
    public void initialize() {
        this.logic.initialize();
        super.initialize();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return this.standardIconIndex;
        }
        int metadata = this.container.func_145832_p();
        if (metadata == direction.ordinal()) {
            return this.solidIconIndex;
        }
        return this.standardIconIndex;
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return this.powerHandler.getPowerReceiver();
    }

    @Override
    public void doWork(PowerHandler workProvider) {
        if (this.container.func_145831_w().field_72995_K) {
            return;
        }
        if (this.powerHandler.getEnergyStored() <= 0.0) {
            return;
        }
        if (((PipeTransportItems)this.transport).getNumberOfStacks() < 64) {
            this.extractItems();
        }
        this.powerHandler.setEnergy(0.0);
    }

    private void extractItems() {
        int meta = this.container.func_145832_p();
        if (meta > 5) {
            return;
        }
        ForgeDirection side = ForgeDirection.getOrientation((int)meta);
        TileEntity tile = this.container.getTile(side);
        if (tile instanceof IInventory) {
            if (!PipeManager.canExtractItems(this, tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e)) {
                return;
            }
            IInventory inventory = (IInventory)tile;
            ItemStack[] extracted = this.checkExtract(inventory, true, side.getOpposite());
            if (extracted == null) {
                return;
            }
            tile.func_70296_d();
            for (ItemStack stack : extracted) {
                if (stack == null || stack.field_77994_a == 0) {
                    this.powerHandler.useEnergy(1.0, 1.0, true);
                    continue;
                }
                Position entityPos = new Position((double)tile.field_145851_c + 0.5, (double)tile.field_145848_d + 0.5, (double)tile.field_145849_e + 0.5, side.getOpposite());
                entityPos.moveForwards(0.6);
                TravelingItem entity = this.makeItem(entityPos.x, entityPos.y, entityPos.z, stack);
                ((PipeTransportItems)this.transport).injectItem(entity, entityPos.orientation);
            }
        }
    }

    protected TravelingItem makeItem(double x, double y, double z, ItemStack stack) {
        return TravelingItem.make(x, y, z, stack);
    }

    public ItemStack[] checkExtract(IInventory inventory, boolean doRemove, ForgeDirection from) {
        if (inventory instanceof ISpecialInventory) {
            ItemStack[] stacks = ((ISpecialInventory)inventory).extractItem(doRemove, from, Math.min((int)this.powerHandler.getEnergyStored(), 1024 - ((PipeTransportItems)this.transport).getNumberOfItems()));
            if (stacks != null && doRemove) {
                for (ItemStack stack : stacks) {
                    if (stack == null) continue;
                    this.powerHandler.useEnergy(stack.field_77994_a, stack.field_77994_a, true);
                }
            }
            return stacks;
        }
        IInventory inv = InvUtils.getInventory(inventory);
        ItemStack result = this.checkExtractGeneric(inv, doRemove, from);
        if (result != null) {
            return new ItemStack[]{result};
        }
        return null;
    }

    public ItemStack checkExtractGeneric(IInventory inventory, boolean doRemove, ForgeDirection from) {
        return this.checkExtractGeneric(InventoryWrapper.getWrappedInventory(inventory), doRemove, from);
    }

    public ItemStack checkExtractGeneric(ISidedInventory inventory, boolean doRemove, ForgeDirection from) {
        if (inventory == null) {
            return null;
        }
        for (int k : inventory.func_94128_d(from.ordinal())) {
            ItemStack slot = inventory.func_70301_a(k);
            if (slot == null || slot.field_77994_a <= 0 || !inventory.func_102008_b(k, slot, from.ordinal())) continue;
            if (doRemove) {
                return inventory.func_70298_a(k, (int)this.powerHandler.useEnergy(1.0, slot.field_77994_a, true));
            }
            return slot;
        }
        return null;
    }
}

