/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.triggers;

import buildcraft.core.triggers.BCTrigger;
import buildcraft.core.utils.StringUtils;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;

public class TriggerClockTimer
extends BCTrigger {
    public final Time time;
    private IIcon icon;

    public TriggerClockTimer(Time time) {
        super("buildcraft:timer." + time.name().toLowerCase(Locale.ENGLISH));
        this.time = time;
    }

    @Override
    public IIcon getIcon() {
        return this.icon;
    }

    @Override
    public String getDescription() {
        return String.format(StringUtils.localize("gate.trigger.timer"), this.time.delay);
    }

    @Override
    public void registerIcons(IIconRegister iconRegister) {
        this.icon = iconRegister.func_94245_a("buildcraft:triggers/trigger_timer_" + this.time.name().toLowerCase(Locale.ENGLISH));
    }

    public static enum Time {
        SHORT(5),
        MEDIUM(10),
        LONG(15);

        public static final Time[] VALUES;
        public final int delay;

        private Time(int delay) {
            this.delay = delay;
        }

        static {
            VALUES = Time.values();
        }
    }
}

