/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.msh;

import com.github.lunatrius.core.util.vector.Vector3f;
import com.github.lunatrius.core.util.vector.Vector4i;
import com.github.lunatrius.msh.EntityLivingEntry;
import com.github.lunatrius.msh.client.Events;
import com.github.lunatrius.msh.client.gui.TextureInformation;
import com.github.lunatrius.msh.client.renderer.Renderer;
import com.github.lunatrius.msh.config.Config;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.culling.Frustrum;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="MonsterSpawnHighlighter")
public class MonsterSpawnHighlighter {
    private final Minecraft minecraft = Minecraft.func_71410_x();
    private World world = null;
    public final KeyBinding toggleKey = new KeyBinding("key.msh.toggle", 38, "key.category.msh");
    private final Frustrum frustrum = new Frustrum();
    private final AxisAlignedBB boundingBox = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    private Map<Integer, Map<Class, EnumCreatureType>> biomeCreatureSpawnMapping = new HashMap<Integer, Map<Class, EnumCreatureType>>();
    public final List<Vector4i> spawnList = new ArrayList<Vector4i>();
    public Vector3f playerPosition = new Vector3f();
    private int ticks = -1;
    public Config config = null;
    public List<String> entityBlacklist = new ArrayList<String>();
    public List<EntityLivingEntry> entityList = new ArrayList<EntityLivingEntry>();
    public Map<Class<? extends EntityLiving>, TextureInformation> entityIcons = new HashMap<Class<? extends EntityLiving>, TextureInformation>();
    public boolean hasSeed = false;
    public long seed = 0L;
    @Mod.Instance(value="MonsterSpawnHighlighter")
    public static MonsterSpawnHighlighter instance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.config = new Config(event.getSuggestedConfigurationFile());
        this.config.save();
        this.entityBlacklist.add("Blaze");
        this.entityBlacklist.add("CaveSpider");
        this.entityBlacklist.add("EnderDragon");
        this.entityBlacklist.add("Giant");
        this.entityBlacklist.add("Mob");
        this.entityBlacklist.add("Monster");
        this.entityBlacklist.add("SnowMan");
        this.entityBlacklist.add("Villager");
        this.entityBlacklist.add("VillagerGolem");
        this.entityBlacklist.add("WitherBoss");
        this.entityBlacklist.add("Silverfish");
        this.entityBlacklist.add("Witch");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        try {
            MinecraftForge.EVENT_BUS.register((Object)new Renderer(this.minecraft));
            ClientRegistry.registerKeyBinding((KeyBinding)this.toggleKey);
            FMLCommonHandler.instance().bus().register((Object)new Events());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Set entityNames = EntityList.field_75625_b.keySet();
        for (String entityName : entityNames) {
            Entity entity;
            if (this.entityBlacklist.contains(entityName) || !((entity = EntityList.func_75620_a((String)entityName, null)) instanceof EntityLiving)) continue;
            EntityLiving entityLiving = (EntityLiving)entity;
            boolean enabled = this.config.isEntityEnabled(entityName);
            EntityLivingEntry entityLivingEntry = new EntityLivingEntry(entityName, entityLiving, enabled);
            this.entityList.add(entityLivingEntry);
            if (entityLivingEntry.entity instanceof EntitySlime) {
                try {
                    Method method = ReflectionHelper.findMethod(EntitySlime.class, (Object)((EntitySlime)entityLivingEntry.entity), (String[])new String[]{"func_70799_a", "a", "setSlimeSize"}, (Class[])new Class[]{Integer.TYPE});
                    method.invoke((Object)entityLivingEntry.entity, 1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                TextureInformation textureInformation = new TextureInformation(entityLiving);
                this.entityIcons.put(entityLiving.getClass(), textureInformation);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        try {
            this.hasSeed = true;
            this.seed = event.getServer().func_71218_a(0).func_72905_C();
        }
        catch (Exception e) {
            this.hasSeed = false;
        }
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        this.hasSeed = false;
    }

    public boolean onTick() {
        if (--this.ticks < 0) {
            this.ticks = this.config.updateRate;
            if (this.minecraft != null && this.minecraft.field_71441_e != null && this.config.renderSpawns != 0) {
                this.spawnList.clear();
                this.frustrum.func_78547_a((double)this.playerPosition.x, (double)this.playerPosition.y, (double)this.playerPosition.z);
                this.world = this.minecraft.field_71441_e;
                int lowX = (int)(Math.floor(this.playerPosition.x) - (double)this.config.renderRangeXZ);
                int highX = (int)(Math.floor(this.playerPosition.x) + (double)this.config.renderRangeXZ);
                int lowY = (int)(Math.floor(this.playerPosition.y) - (double)this.config.renderRangeYBellow);
                int highY = (int)(Math.floor(this.playerPosition.y) + (double)this.config.renderRangeYAbove);
                int lowZ = (int)(Math.floor(this.playerPosition.z) - (double)this.config.renderRangeXZ);
                int highZ = (int)(Math.floor(this.playerPosition.z) + (double)this.config.renderRangeXZ);
                for (int y = lowY; y <= highY; ++y) {
                    for (int x = lowX; x <= highX; ++x) {
                        for (int z = lowZ; z <= highZ; ++z) {
                            if (!this.frustrum.func_78546_a(this.boundingBox.func_72324_b((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)))) continue;
                            this.setEntityLivingLocation(x, y, z);
                            int type = this.getCanSpawnHere(x, y, z);
                            if (type <= 0) continue;
                            this.spawnList.add(new Vector4i(x, y, z, type));
                        }
                    }
                }
            } else {
                this.world = null;
            }
        }
        return true;
    }

    private void setEntityLivingLocation(int x, int y, int z) {
        for (EntityLivingEntry entityLivingEntry : this.entityList) {
            entityLivingEntry.entity.func_70012_b((double)((float)x + 0.5f), (double)y, (double)((float)z + 0.5f), 0.0f, 0.0f);
        }
    }

    private int getCanSpawnHere(int x, int y, int z) {
        Block block = this.world.func_147439_a(x, y - 1, z);
        if (block == null || block == Blocks.field_150350_a || block.func_149688_o().func_76224_d()) {
            return 0;
        }
        BiomeGenBase biome = this.world.func_72807_a(x, z);
        Map<Object, Object> entityCreatureTypeMapping = null;
        if (!this.biomeCreatureSpawnMapping.containsKey(biome.field_76756_M)) {
            entityCreatureTypeMapping = new HashMap();
            for (EnumCreatureType creatureType : EnumCreatureType.values()) {
                List spawnableList = biome.func_76747_a(creatureType);
                if (spawnableList == null) continue;
                for (BiomeGenBase.SpawnListEntry spawnListEntry : spawnableList) {
                    entityCreatureTypeMapping.put(spawnListEntry.field_76300_b, creatureType);
                }
            }
            this.biomeCreatureSpawnMapping.put(biome.field_76756_M, entityCreatureTypeMapping);
        }
        if ((entityCreatureTypeMapping = this.biomeCreatureSpawnMapping.get(biome.field_76756_M)) == null) {
            return 0;
        }
        int spawnType = 0;
        EntityLiving entity = null;
        for (Map.Entry<Object, Object> entry : entityCreatureTypeMapping.entrySet()) {
            Class key = (Class)entry.getKey();
            EnumCreatureType value = (EnumCreatureType)entry.getValue();
            for (EntityLivingEntry entityLivingEntry : this.entityList) {
                entity = entityLivingEntry.entity;
                if (!entityLivingEntry.enabled || !key.isInstance(entity) || !key.equals(EntityOcelot.class) && !SpawnerAnimals.func_77190_a((EnumCreatureType)value, (World)this.world, (int)x, (int)y, (int)z)) continue;
                if (key.equals(EntitySquid.class) && y > 45 && y < 63) {
                    return 3;
                }
                if (this.world.func_72953_d(entity.field_70121_D) || !this.world.func_147461_a(entity.field_70121_D).isEmpty()) continue;
                if (key.equals(EntitySlime.class) && (y < 40 && this.isSlimeChunk(x >> 4, z >> 4) || y > 50 && y < 70 && biome.field_76756_M == BiomeGenBase.field_76780_h.field_76756_M && this.getBlockLightLevel(x, y, z, 16) < 8)) {
                    return 3;
                }
                if ((key.equals(EntityPigZombie.class) || key.equals(EntityGhast.class) || key.equals(EntityMagmaCube.class)) && this.world.field_73013_u != EnumDifficulty.PEACEFUL) {
                    return 3;
                }
                if (key.equals(EntityOcelot.class) && y >= 64 && (block == Blocks.field_150349_c || block.isLeaves((IBlockAccess)this.world, x, y - 1, z))) {
                    return 3;
                }
                if ((key.equals(EntityCreeper.class) || key.equals(EntityZombie.class) || key.equals(EntitySkeleton.class) || key.equals(EntitySpider.class) || key.equals(EntityEnderman.class)) && this.getBlockLightLevel(x, y, z, 16) < 8 && this.world.field_73013_u != EnumDifficulty.PEACEFUL) {
                    spawnType |= 2;
                }
                Calendar calendar = this.world.func_83015_S();
                if (key.equals(EntityBat.class) && entity.field_70121_D.field_72338_b < 63.0 && this.getBlockLightLevel(x, y, z, 16) < (!(calendar.get(2) + 1 == 10 && calendar.get(5) >= 20 || calendar.get(2) + 1 == 11 && calendar.get(5) <= 3) ? 5 : 8)) {
                    spawnType |= 2;
                }
                if (!key.equals(EntityChicken.class) && !key.equals(EntityCow.class) && !key.equals(EntityMooshroom.class) && !key.equals(EntityPig.class) && !key.equals(EntityWolf.class) || block != Blocks.field_150349_c || this.getBlockLightLevel(x, y, z, 0) <= 8) continue;
                spawnType |= 1;
            }
        }
        return spawnType;
    }

    private int getBlockLightLevel(int x, int y, int z, int kst) {
        return this.world.func_72964_e(x >> 4, z >> 4).func_76629_c(x & 0xF, y, z & 0xF, kst);
    }

    private boolean isSlimeChunk(int x, int z) {
        return this.hasSeed && new Random(this.seed + (long)(x * x * 4987142) + (long)(x * 5947611) + (long)(z * z) * 4392871L + (long)(z * 389711) ^ 0x3AD8025FL).nextInt(10) == 0;
    }
}

