/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.msh.client.gui;

import com.github.lunatrius.msh.EntityLivingEntry;
import com.github.lunatrius.msh.MonsterSpawnHighlighter;
import com.github.lunatrius.msh.client.gui.GuiMonsterSpawnHighlighter;
import com.github.lunatrius.msh.client.gui.TextureInformation;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.EntityLiving;
import org.lwjgl.opengl.GL11;

public class GuiMonsterSpawnHighlighterSlot
extends GuiSlot {
    private final GuiMonsterSpawnHighlighter guiMonsterSpawnHighlighter;
    private final TextureManager renderEngine;
    private final FontRenderer fontRenderer;
    private final List<EntityLivingEntry> entityList;

    public GuiMonsterSpawnHighlighterSlot(Minecraft minecraft, GuiMonsterSpawnHighlighter guiMonsterSpawnHighlighter) {
        super(minecraft, guiMonsterSpawnHighlighter.field_146294_l, guiMonsterSpawnHighlighter.field_146295_m, 16, guiMonsterSpawnHighlighter.field_146295_m - 30, 24);
        this.guiMonsterSpawnHighlighter = guiMonsterSpawnHighlighter;
        this.renderEngine = minecraft.field_71446_o;
        this.fontRenderer = minecraft.field_71466_p;
        this.entityList = MonsterSpawnHighlighter.instance.entityList;
    }

    protected int func_148127_b() {
        return this.entityList.size();
    }

    protected void func_148144_a(int index, boolean isDoubleClick, int a, int b) {
        if (index < 0 || index >= this.entityList.size()) {
            return;
        }
        EntityLivingEntry entityLivingEntry = this.entityList.get(index);
        entityLivingEntry.enabled = !entityLivingEntry.enabled;
        this.guiMonsterSpawnHighlighter.config.setEntityEnabled(entityLivingEntry.name, entityLivingEntry.enabled);
    }

    protected boolean func_148131_a(int index) {
        return index >= 0 && index < this.entityList.size() && this.entityList.get((int)index).enabled;
    }

    protected void func_148123_a() {
    }

    protected void drawContainerBackground(Tessellator tessellator) {
    }

    protected void func_148126_a(int index, int x, int y, int par4, Tessellator tessellator, int a, int b) {
        if (index < 0 || index >= this.entityList.size()) {
            return;
        }
        this.drawEntity(x, y, this.entityList.get((int)index).entity);
        this.guiMonsterSpawnHighlighter.func_73731_b(this.fontRenderer, this.entityList.get((int)index).entity.func_145748_c_().func_150254_d(), x + 24, y + 6, 0xFFFFFF);
    }

    private void drawEntity(int x, int y, EntityLiving entityLiving) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator tess = Tessellator.field_78398_a;
        this.renderEngine.func_110577_a(Gui.field_110323_l);
        this.drawEntitySlot(tess, x, y);
        TextureInformation ti = MonsterSpawnHighlighter.instance.entityIcons.get(entityLiving.getClass());
        if (ti != null) {
            this.renderEngine.func_110577_a(ti.resourceLocation);
            this.drawTextureParts(tess, x, y, ti);
            if (ti.resourceSpecial != null) {
                this.renderEngine.func_110577_a(ti.resourceSpecial);
                this.drawTextureParts(tess, x, y, ti);
            }
        }
    }

    private void drawEntitySlot(Tessellator tess, int x, int y) {
        tess.func_78382_b();
        tess.func_78374_a((double)(x + 1), (double)(y + 19), 0.0, 0.0, 0.140625);
        tess.func_78374_a((double)(x + 19), (double)(y + 19), 0.0, 0.140625, 0.140625);
        tess.func_78374_a((double)(x + 19), (double)(y + 1), 0.0, 0.140625, 0.0);
        tess.func_78374_a((double)(x + 1), (double)(y + 1), 0.0, 0.0, 0.0);
        tess.func_78381_a();
    }

    private void drawTextureParts(Tessellator tess, int x, int y, TextureInformation ti) {
        tess.func_78382_b();
        for (TextureInformation.TexturePart tp : ti.textureParts) {
            tess.func_78374_a((double)(x + 2) + tp.x, (double)(y + 2) + tp.y + tp.height, 0.0, tp.srcX / (double)ti.width, (tp.srcY + tp.srcHeight) / (double)ti.height);
            tess.func_78374_a((double)(x + 2) + tp.x + tp.width, (double)(y + 2) + tp.y + tp.height, 0.0, (tp.srcX + tp.srcWidth) / (double)ti.width, (tp.srcY + tp.srcHeight) / (double)ti.height);
            tess.func_78374_a((double)(x + 2) + tp.x + tp.width, (double)(y + 2) + tp.y, 0.0, (tp.srcX + tp.srcWidth) / (double)ti.width, tp.srcY / (double)ti.height);
            tess.func_78374_a((double)(x + 2) + tp.x, (double)(y + 2) + tp.y, 0.0, tp.srcX / (double)ti.width, tp.srcY / (double)ti.height);
        }
        tess.func_78381_a();
    }
}

