/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.msh.client.renderer;

import com.github.lunatrius.core.util.vector.Vector4i;
import com.github.lunatrius.msh.MonsterSpawnHighlighter;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;

public class Renderer {
    private MonsterSpawnHighlighter msh = MonsterSpawnHighlighter.instance;
    private Minecraft minecraft = null;
    private final int[] list = new int[]{-1, -1};

    public Renderer(Minecraft minecraft) {
        this.minecraft = minecraft;
        this.compileList();
    }

    private void compileList() {
        this.list[0] = GL11.glGenLists((int)1);
        GL11.glNewList((int)this.list[0], (int)4864);
        GL11.glBegin((int)7);
        GL11.glVertex3f((float)0.1f, (float)0.03f, (float)0.1f);
        GL11.glVertex3f((float)0.1f, (float)0.03f, (float)0.9f);
        GL11.glVertex3f((float)0.9f, (float)0.03f, (float)0.9f);
        GL11.glVertex3f((float)0.9f, (float)0.03f, (float)0.1f);
        GL11.glEnd();
        GL11.glBegin((int)2);
        GL11.glVertex3f((float)0.1f, (float)0.03f, (float)0.1f);
        GL11.glVertex3f((float)0.1f, (float)0.03f, (float)0.9f);
        GL11.glVertex3f((float)0.9f, (float)0.03f, (float)0.9f);
        GL11.glVertex3f((float)0.9f, (float)0.03f, (float)0.1f);
        GL11.glEnd();
        GL11.glEndList();
        this.list[1] = GL11.glGenLists((int)1);
        GL11.glNewList((int)this.list[1], (int)4864);
        GL11.glBegin((int)7);
        GL11.glVertex3f((float)0.1f, (float)0.03f, (float)0.1f);
        GL11.glVertex3f((float)0.1f, (float)0.03f, (float)0.9f);
        GL11.glVertex3f((float)0.9f, (float)0.03f, (float)0.9f);
        GL11.glVertex3f((float)0.9f, (float)0.03f, (float)0.1f);
        GL11.glEnd();
        GL11.glBegin((int)2);
        GL11.glVertex3f((float)0.1f, (float)0.03f, (float)0.1f);
        GL11.glVertex3f((float)0.1f, (float)0.03f, (float)0.9f);
        GL11.glVertex3f((float)0.9f, (float)0.03f, (float)0.9f);
        GL11.glVertex3f((float)0.9f, (float)0.03f, (float)0.1f);
        GL11.glEnd();
        GL11.glBegin((int)1);
        GL11.glVertex3f((float)0.5f, (float)0.0f, (float)0.5f);
        GL11.glVertex3f((float)0.5f, (float)this.msh.config.guideLength, (float)0.5f);
        GL11.glEnd();
        GL11.glEndList();
    }

    @SubscribeEvent
    public void onRender(RenderWorldLastEvent event) {
        EntityClientPlayerMP player;
        if (this.minecraft != null && this.msh.config.renderSpawns != 0 && (player = this.minecraft.field_71439_g) != null) {
            this.msh.playerPosition.x = (float)(player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.partialTicks);
            this.msh.playerPosition.y = (float)(player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.partialTicks);
            this.msh.playerPosition.z = (float)(player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.partialTicks);
            this.render();
        }
    }

    private void render() {
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)2848);
        GL11.glLineWidth((float)2.0f);
        GL11.glTranslatef((float)(-this.msh.playerPosition.x), (float)(-this.msh.playerPosition.y), (float)(-this.msh.playerPosition.z));
        for (int i = 0; i < this.msh.spawnList.size(); ++i) {
            Vector4i blockPos = this.msh.spawnList.get(i);
            switch (blockPos.w) {
                case 1: {
                    this.msh.config.glColorDay();
                    break;
                }
                case 2: {
                    this.msh.config.glColorNight();
                    break;
                }
                case 3: {
                    this.msh.config.glColorBoth();
                }
            }
            float delta = 0.0f;
            Block block = this.minecraft.field_71441_e.func_147439_a(blockPos.x, blockPos.y, blockPos.z);
            if (block != null && (block == Blocks.field_150433_aE || block == Blocks.field_150452_aw || block == Blocks.field_150456_au || block == Blocks.field_150445_bS || block == Blocks.field_150443_bT)) {
                block.func_149719_a((IBlockAccess)this.minecraft.field_71441_e, blockPos.x, blockPos.y, blockPos.z);
                delta = (float)block.func_149669_A();
            }
            GL11.glTranslatef((float)blockPos.x, (float)((float)blockPos.y + delta), (float)blockPos.z);
            GL11.glCallList((int)this.list[this.msh.config.renderSpawns == 1 ? 0 : 1]);
            GL11.glTranslatef((float)(-blockPos.x), (float)(-((float)blockPos.y + delta)), (float)(-blockPos.z));
        }
        GL11.glTranslatef((float)this.msh.playerPosition.x, (float)this.msh.playerPosition.y, (float)this.msh.playerPosition.z);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2848);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }
}

