/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.msh.config;

import com.github.lunatrius.core.config.Configuration;
import java.io.File;
import net.minecraftforge.common.config.Property;
import org.lwjgl.opengl.GL11;

public class Config
extends Configuration {
    public static final int COLOR_MIN = 0;
    public static final int COLOR_MAX = 255;
    private final Property propColorDayRed;
    private final Property propColorDayGreen;
    private final Property propColorDayBlue;
    private final Property propColorNightRed;
    private final Property propColorNightGreen;
    private final Property propColorNightBlue;
    private final Property propColorBothRed;
    private final Property propColorBothGreen;
    private final Property propColorBothBlue;
    private final Property propRenderRangeXZ;
    private final Property propRenderRangeYBellow;
    private final Property propRenderRangeYAbove;
    private final Property propUpdateRate;
    private final Property propGuideLength;
    public int colorDayRed = 0;
    public int colorDayGreen = 255;
    public int colorDayBlue = 0;
    public int colorNightRed = 0;
    public int colorNightGreen = 0;
    public int colorNightBlue = 255;
    public int colorBothRed = 255;
    public int colorBothGreen = 0;
    public int colorBothBlue = 0;
    public int renderRangeXZ = 8;
    public int renderRangeYBellow = 4;
    public int renderRangeYAbove = 0;
    public int updateRate = 4;
    public float guideLength = 1.5f;
    public int renderSpawns = 0;

    public Config(File file) {
        super(file);
        String categoryColor = "color";
        String categoryOther = "other";
        this.propColorDayRed = this.get(categoryColor, "colorDayRed", this.colorDayRed, 0, 255, "Amount of red color (during the day).");
        this.propColorDayGreen = this.get(categoryColor, "colorDayGreen", this.colorDayGreen, 0, 255, "Amount of green color (during the day).");
        this.propColorDayBlue = this.get(categoryColor, "colorDayBlue", this.colorDayBlue, 0, 255, "Amount of blue color (during the day).");
        this.propColorNightRed = this.get(categoryColor, "colorNightRed", this.colorNightRed, 0, 255, "Amount of red color (during the night).");
        this.propColorNightGreen = this.get(categoryColor, "colorNightGreen", this.colorNightGreen, 0, 255, "Amount of green color (during the night).");
        this.propColorNightBlue = this.get(categoryColor, "colorNightBlue", this.colorNightBlue, 0, 255, "Amount of blue color (during the night).");
        this.propColorBothRed = this.get(categoryColor, "colorBothRed", this.colorBothRed, 0, 255, "Amount of red color (during the night).");
        this.propColorBothGreen = this.get(categoryColor, "colorBothGreen", this.colorBothGreen, 0, 255, "Amount of green color (during the night).");
        this.propColorBothBlue = this.get(categoryColor, "colorBothBlue", this.colorBothBlue, 0, 255, "Amount of blue color (during the night).");
        this.propRenderRangeXZ = this.get(categoryOther, "renderRangeXZ", this.renderRangeXZ, 1, 32, "Amount of blocks that should be checked in X and Z directions ([2*range+1]^2 total).");
        this.propRenderRangeYBellow = this.get(categoryOther, "renderRangeYBellow", this.renderRangeYBellow, 1, 32, "Amount of blocks that should be checked bellow the player.");
        this.propRenderRangeYAbove = this.get(categoryOther, "renderRangeYAbove", this.renderRangeYAbove, 1, 32, "Amount of blocks that should be checked above the player.");
        this.propUpdateRate = this.get(categoryOther, "updateRate", this.updateRate, 1, 30, "Amount of ticks to wait before refreshing again.");
        this.propGuideLength = this.get(categoryOther, "guideLength", this.guideLength, -50.0, 50.0, "Length of the guide line (negative numbers invert the guide line).");
        this.colorDayRed = this.propColorDayRed.getInt(this.colorDayRed);
        this.colorDayGreen = this.propColorDayGreen.getInt(this.colorDayGreen);
        this.colorDayBlue = this.propColorDayBlue.getInt(this.colorDayBlue);
        this.colorNightRed = this.propColorNightRed.getInt(this.colorNightRed);
        this.colorNightGreen = this.propColorNightGreen.getInt(this.colorNightGreen);
        this.colorNightBlue = this.propColorNightBlue.getInt(this.colorNightBlue);
        this.colorBothRed = this.propColorBothRed.getInt(this.colorBothRed);
        this.colorBothGreen = this.propColorBothGreen.getInt(this.colorBothGreen);
        this.colorBothBlue = this.propColorBothBlue.getInt(this.colorBothBlue);
        this.renderRangeXZ = this.propRenderRangeXZ.getInt(this.renderRangeXZ);
        this.renderRangeYBellow = this.propRenderRangeYBellow.getInt(this.renderRangeYBellow);
        this.renderRangeYAbove = this.propRenderRangeYAbove.getInt(this.renderRangeYAbove);
        this.updateRate = this.propUpdateRate.getInt(this.updateRate);
        this.guideLength = (float)this.propGuideLength.getDouble((double)this.guideLength);
    }

    public void glColorDay() {
        GL11.glColor4ub((byte)((byte)this.colorDayRed), (byte)((byte)this.colorDayGreen), (byte)((byte)this.colorDayBlue), (byte)79);
    }

    public void glColorNight() {
        GL11.glColor4ub((byte)((byte)this.colorNightRed), (byte)((byte)this.colorNightGreen), (byte)((byte)this.colorNightBlue), (byte)79);
    }

    public void glColorBoth() {
        GL11.glColor4ub((byte)((byte)this.colorBothRed), (byte)((byte)this.colorBothGreen), (byte)((byte)this.colorBothBlue), (byte)79);
    }

    private Property getEntityProperty(String entityName) {
        return this.get("Entities", String.format("enabled%s", entityName), false, String.format("Enable spawn rendering of %s.", entityName));
    }

    public boolean isEntityEnabled(String entityName) {
        return this.getEntityProperty(entityName).getBoolean(false);
    }

    public void setEntityEnabled(String entityName, boolean enabled) {
        Property property = this.getEntityProperty(entityName);
        property.set(enabled);
    }
}

