/*
 * Decompiled with CFR 0.152.
 */
package org.gudenau.minecraft.cooler.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.FoodStats;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.gudenau.minecraft.cooler.block.tileentity.TileCooler;

public class ItemCooler
extends ItemBlock {
    public ItemCooler(Block block) {
        super(block);
        this.func_77627_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List info, boolean par4) {
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound tag = stack.field_77990_d;
        if (tag.func_74764_b("buffer")) {
            info.add(I18n.func_135052_a((String)"gud_cooler.tooltip.buffer", (Object[])new Object[0]) + ": " + tag.func_74762_e("buffer"));
        }
        if (tag.func_74764_b("items")) {
            NBTTagCompound tags = tag.func_74775_l("items");
            for (int i = 0; i < 6; ++i) {
                if (!tags.func_74764_b("" + i)) continue;
                ItemStack item = ItemStack.func_77949_a((NBTTagCompound)tags.func_74775_l("" + i));
                info.add(StatCollector.func_74838_a((String)(item.func_77977_a() + ".name")) + (item.field_77994_a != 1 ? " x" + item.field_77994_a : ""));
            }
        }
        if (tag.func_74764_b("red") || tag.func_74764_b("green") || tag.func_74764_b("blue")) {
            info.add(I18n.func_135052_a((String)"gud_cooler.tooltip.coloured", (Object[])new Object[0]));
        }
        if (tag.func_74764_b("clear") && tag.func_74767_n("clear")) {
            info.add(I18n.func_135052_a((String)"gud_cooler.tooltip.clear", (Object[])new Object[0]));
        }
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        boolean orig = super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata);
        if (orig && stack.func_77942_o()) {
            TileCooler tile = new TileCooler();
            tile.readFromItem(stack.field_77990_d);
            world.func_147455_a(x, y, z, (TileEntity)tile);
        }
        return orig;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        int buffer;
        EntityPlayer player;
        FoodStats food;
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
            return;
        }
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        NBTTagCompound tag = stack.field_77990_d;
        int correctColor = (tag.func_74767_n("clear") ? 0x1000000 : 0) + (tag.func_74762_e("red") & 0xFF) + ((tag.func_74762_e("green") & 0xFF) << 8) + ((tag.func_74762_e("blue") & 0xFF) << 16);
        if (stack.func_77960_j() != correctColor) {
            stack.func_77964_b(correctColor);
        }
        if ((food = (player = (EntityPlayer)entity).func_71024_bL()).func_75121_c() && (buffer = tag.func_74762_e("buffer")) != 0) {
            int foodLevel = food.func_75116_a();
            if (foodLevel + buffer <= 20) {
                food.func_75114_a(foodLevel + buffer);
                buffer = 0;
            } else {
                buffer -= 20 - foodLevel;
                food.func_75114_a(20);
            }
            if (buffer != 0) {
                tag.func_74768_a("buffer", buffer);
            } else {
                tag.func_82580_o("buffer");
            }
        }
        if (tag.func_74764_b("items") && (food.func_75115_e() < 20.0f || food.func_75121_c()) && !tag.func_74764_b("buffer")) {
            int i;
            NBTTagCompound itemTags = tag.func_74775_l("items");
            ItemStack foodStack = null;
            for (i = 0; i < 6; ++i) {
                if (!itemTags.func_74764_b("" + i)) continue;
                foodStack = ItemStack.func_77949_a((NBTTagCompound)itemTags.func_74775_l("" + i));
                break;
            }
            ItemFood foodItem = (ItemFood)foodStack.func_77973_b();
            foodItem.func_150905_g(foodStack);
            int foodLevel = foodItem.func_150905_g(foodStack);
            float satLevel = foodItem.func_150906_h(foodStack) * (float)foodLevel * 2.0f;
            if ((int)(food.func_75115_e() + satLevel) <= 20) {
                food.func_75119_b(20.0f);
                tag.func_74768_a("buffer", foodLevel);
                --foodStack.field_77994_a;
                if (foodStack.field_77994_a == 0) {
                    foodStack = null;
                }
                world.func_72956_a(entity, "random.burp", 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (foodStack != null) {
                NBTTagCompound tmpTag = new NBTTagCompound();
                foodStack.func_77955_b(tmpTag);
                itemTags.func_74782_a("" + i, (NBTBase)tmpTag);
            } else {
                itemTags.func_82580_o("" + i);
            }
            if (itemTags.func_82582_d()) {
                tag.func_82580_o("items");
            } else {
                tag.func_74782_a("items", (NBTBase)itemTags);
            }
            if ((float)food.func_75116_a() < food.func_75115_e()) {
                food.func_75119_b((float)food.func_75116_a());
            }
        }
    }
}

