/*
 * Decompiled with CFR 0.152.
 */
package org.gudenau.minecraft.cooler.render;

import com.google.common.primitives.SignedBytes;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.gudenau.minecraft.cooler.block.tileentity.TileCooler;
import org.gudenau.minecraft.cooler.model.ModelCooler;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderCooler
extends TileEntitySpecialRenderer {
    private static final ResourceLocation texture = new ResourceLocation("gud_cooler:textures/blocks/cooler.png");
    private static final ResourceLocation textureClear = new ResourceLocation("gud_cooler:textures/blocks/cooler_clear.png");
    private static final ModelCooler model = new ModelCooler();
    private final RenderItem itemRenderer = new RenderItem(){

        public byte getMiniBlockCount(ItemStack stack, byte orig) {
            return SignedBytes.saturatedCast((long)(Math.min(stack.field_77994_a / 32, 15) + 1));
        }

        public byte getMiniItemCount(ItemStack stack, byte orig) {
            return SignedBytes.saturatedCast((long)(Math.min(stack.field_77994_a / 32, 7) + 1));
        }

        public boolean shouldBob() {
            return false;
        }

        public boolean shouldSpreadItems() {
            return false;
        }
    };

    public RenderCooler() {
        this.itemRenderer.func_76976_a(RenderManager.field_78727_a);
    }

    public void func_147500_a(TileEntity tile, double x, double y, double z, float delta) {
        if (tile instanceof TileCooler) {
            this.renderCooler((TileCooler)tile, x, y, z, delta);
        }
    }

    private void renderCooler(TileCooler tile, double x, double y, double z, float delta) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
        int meta = tile.func_145831_w().func_72805_g(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e) + 1 & 3;
        GL11.glRotatef((float)(meta * 90), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.65625f);
        this.func_147499_a(tile.clear ? textureClear : texture);
        GL11.glColor3f((float)((float)tile.red / 256.0f), (float)((float)tile.green / 256.0f), (float)((float)tile.blue / 256.0f));
        float f1 = tile.lastAngle + (tile.angle - tile.lastAngle) * delta;
        f1 = 1.0f - f1;
        f1 = 1.0f - f1 * f1 * f1;
        RenderCooler.model.lid.field_78795_f = -(f1 * (float)Math.PI / 2.0f);
        f1 = tile.lastAngle2 + (tile.angle2 - tile.lastAngle2) * delta;
        f1 = 1.0f - f1;
        f1 = 1.0f - f1 * f1 * f1;
        RenderCooler.model.handle.field_78795_f = 2.41661f * f1;
        model.renderAll();
        if (tile.clear) {
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2884);
            EntityItem entityItem = new EntityItem(tile.func_145831_w());
            entityItem.field_70290_d = 0.0f;
            int slot = -1;
            GL11.glTranslatef((float)0.05f, (float)-0.05f, (float)0.65f);
            for (ItemStack item : tile.getInventory()) {
                ++slot;
                if (item == null) continue;
                GL11.glPushMatrix();
                GL11.glTranslatef((float)((float)(3 - slot % 3) / 4.5f), (float)((float)(2 - slot / 3) / 4.5f), (float)0.0f);
                GL11.glRotatef((float)(tile.itemRot + slot * 30), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                entityItem.func_92058_a(item);
                this.itemRenderer.func_76986_a(entityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
                GL11.glPopMatrix();
            }
            GL11.glEnable((int)2884);
            GL11.glEnable((int)2896);
        }
        GL11.glPopMatrix();
    }
}

