/*
 * Decompiled with CFR 0.152.
 */
package thebombzen.mods.thebombzenapi;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import thebombzen.mods.thebombzenapi.SideSpecificUtlities;
import thebombzen.mods.thebombzenapi.ThebombzenAPIBaseMod;
import thebombzen.mods.thebombzenapi.ThebombzenAPIConfiguration;
import thebombzen.mods.thebombzenapi.ThebombzenAPIMetaConfiguration;
import thebombzen.mods.thebombzenapi.client.ThebombzenAPIConfigScreen;

@Mod(modid="thebombzenapi", name="ThebombzenAPI", version="2.3.0")
public class ThebombzenAPI
extends ThebombzenAPIBaseMod {
    public static final String newLine = String.format("%n", new Object[0]);
    @Mod.Instance(value="thebombzenapi")
    public static ThebombzenAPI instance;
    @SidedProxy(clientSide="thebombzen.mods.thebombzenapi.client.ClientSideSpecificUtilities", serverSide="thebombzen.mods.thebombzenapi.server.ServerSideSpecificUtilities")
    public static SideSpecificUtlities sideSpecificUtilities;
    private static Set<ThebombzenAPIBaseMod> mods;
    @SideOnly(value=Side.CLIENT)
    public static int prevWorld;
    private ThebombzenAPIMetaConfiguration dummyConfig = null;
    private static JarFile jarFile;

    public static boolean areItemStackCollectionsEqual(Collection<? extends ItemStack> coll1, Collection<? extends ItemStack> coll2) {
        if (coll1.size() != coll2.size()) {
            return false;
        }
        ArrayList<? extends ItemStack> list1 = new ArrayList<ItemStack>(coll1);
        ArrayList<? extends ItemStack> list2 = new ArrayList<ItemStack>(coll2);
        Iterator iter1 = list1.iterator();
        block0: while (iter1.hasNext()) {
            ItemStack stack1 = (ItemStack)iter1.next();
            Iterator iter2 = list2.iterator();
            while (iter2.hasNext()) {
                ItemStack stack2 = (ItemStack)iter2.next();
                if (!ItemStack.func_77989_b((ItemStack)stack1, (ItemStack)stack2)) continue;
                iter2.remove();
                iter1.remove();
                continue block0;
            }
            return false;
        }
        return true;
    }

    public static <T> T getPrivateField(Object arg, Class<?> clazz, String name) {
        return ThebombzenAPI.getPrivateField(arg, clazz, new String[]{name});
    }

    public static int[] intArrayFromIntegerCollection(Collection<? extends Integer> coll) {
        ArrayList<? extends Integer> ret = new ArrayList<Integer>();
        ret.addAll(coll);
        return ThebombzenAPI.intArrayFromIntegerList(ret);
    }

    public static List<Integer> intArrayToIntegerList(int[] array) {
        ArrayList<Integer> ret = new ArrayList<Integer>(array.length);
        for (int i : array) {
            ret.add(i);
        }
        return ret;
    }

    public static ThebombzenAPIBaseMod[] getMods() {
        return mods.toArray(new ThebombzenAPIBaseMod[mods.size()]);
    }

    public static <T> T getPrivateField(Object arg, Class<?> clazz, String[] names) {
        for (String name : names) {
            try {
                Field field = clazz.getDeclaredField(name);
                field.setAccessible(true);
                try {
                    return (T)field.get(arg);
                }
                catch (Exception e) {
                    return null;
                }
            }
            catch (NoSuchFieldException nsfe) {
            }
        }
        return null;
    }

    public static InputStream getResourceAsStream(Object mod, String resourceName) throws IOException {
        File source = FMLCommonHandler.instance().findContainerFor(mod).getSource();
        if (source.isDirectory()) {
            return new FileInputStream(new File(source, resourceName));
        }
        jarFile = new JarFile(source);
        JarEntry entry = jarFile.getJarEntry(resourceName);
        return jarFile.getInputStream(entry);
    }

    public static int[] intArrayFromIntegerList(List<? extends Integer> list) {
        int[] ret = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ret[i] = list.get(i);
        }
        return ret;
    }

    public static <T> T invokePrivateMethod(Object arg, Class<?> clazz, String name, Class<?>[] parameterTypes, Object ... args) {
        return ThebombzenAPI.invokePrivateMethod(arg, clazz, new String[]{name}, parameterTypes, args);
    }

    public static <T> T invokePrivateMethod(Object arg, Class<?> clazz, String[] names, Class<?>[] parameterTypes, Object ... args) {
        for (String name : names) {
            try {
                Method method = clazz.getDeclaredMethod(name, parameterTypes);
                method.setAccessible(true);
                try {
                    return (T)method.invoke(arg, args);
                }
                catch (Exception e) {
                    return null;
                }
            }
            catch (NoSuchMethodException nsme) {
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isCurrentlyExecutingMethod(String methodName) {
        StackTraceElement[] trace;
        for (StackTraceElement element : trace = Thread.currentThread().getStackTrace()) {
            if (!element.getMethodName().equals(methodName)) continue;
            return true;
        }
        return false;
    }

    public static int parseInteger(String s) {
        int i;
        boolean onecomp;
        boolean bl = onecomp = (s = s.replace("_", "")).charAt(0) == '~';
        if (onecomp) {
            s = s.substring(1);
        }
        if (s.length() == 0) {
            throw new NumberFormatException();
        }
        if (s.charAt(0) != '0') {
            return Integer.parseInt(s);
        }
        if (s.length() == 1) {
            return 0;
        }
        switch (s.charAt(1)) {
            case 'X': 
            case 'x': {
                i = Integer.parseInt(s.substring(2), 16);
                break;
            }
            case 'B': 
            case 'b': {
                i = Integer.parseInt(s.substring(2), 2);
                break;
            }
            default: {
                i = Integer.parseInt(s, 8);
            }
        }
        if (onecomp) {
            i ^= 0xFFFFFFFF;
        }
        return i;
    }

    public static void registerMod(ThebombzenAPIBaseMod mod) {
        mods.add(mod);
    }

    public static void setPrivateField(Object arg, Class<?> clazz, String name, Object set) {
        ThebombzenAPI.setPrivateField(arg, clazz, new String[]{name}, set);
    }

    public static void setPrivateField(Object arg, Class<?> clazz, String[] names, Object set) {
        for (String name : names) {
            try {
                Field field = clazz.getDeclaredField(name);
                field.setAccessible(true);
                try {
                    field.set(arg, set);
                }
                catch (Exception e) {
                    return;
                }
            }
            catch (NoSuchFieldException nsfe) {
                // empty catch block
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent tickEvent) {
        if (tickEvent.phase.equals((Object)TickEvent.Phase.END)) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null) {
            return;
        }
        int currWorld = System.identityHashCode(mc.field_71441_e);
        if (prevWorld == 0) {
            for (ThebombzenAPIBaseMod mod : mods) {
                String latestVersion = mod.getLatestVersion();
                if (latestVersion.equals(mod.getLongVersionString())) continue;
                mc.field_71439_g.func_146105_b((IChatComponent)new ChatComponentText(latestVersion + " is available."));
            }
        }
        if (prevWorld != currWorld) {
            for (ThebombzenAPIBaseMod mod : mods) {
                mod.readFromCorrectMemoryFile();
            }
        }
        for (ThebombzenAPIBaseMod mod : mods) {
            try {
                mod.getConfiguration().reloadPropertiesFromFileIfChanged();
            }
            catch (IOException ioe) {
                mod.throwException("Could not read properties!", ioe, false);
            }
        }
        prevWorld = currWorld;
    }

    @Override
    public ThebombzenAPIConfigScreen createConfigScreen(GuiScreen base) {
        return null;
    }

    @Override
    protected void finalize() throws Throwable {
        jarFile.close();
    }

    @Override
    public ThebombzenAPIConfiguration<?> getConfiguration() {
        if (this.dummyConfig == null) {
            this.dummyConfig = new ThebombzenAPIMetaConfiguration();
        }
        return this.dummyConfig;
    }

    @Override
    public String getLongName() {
        return "ThebombzenAPI";
    }

    @Override
    public String getLongVersionString() {
        return "ThebombzenAPI, version 2.3.0, Minecraft 1.7.2";
    }

    @Override
    public int getNumToggleKeys() {
        return 0;
    }

    @Override
    public String getShortName() {
        return "TBZAPI";
    }

    @Override
    protected String getToggleMessageString(int index, boolean enabled) {
        throw new UnsupportedOperationException("ThebombzenAPI has no toggles!");
    }

    @Override
    protected String getVersionFileURLString() {
        return "https://dl.dropboxusercontent.com/u/51080973/Mods/ThebombzenAPI/TBZAPIVersion.txt";
    }

    @Override
    public boolean hasConfigScreen() {
        return false;
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.initialize();
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    static {
        mods = new HashSet<ThebombzenAPIBaseMod>();
        prevWorld = 0;
        jarFile = null;
    }
}

