/*
 * Decompiled with CFR 0.152.
 */
package thebombzen.mods.thebombzenapi;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Arrays;
import java.util.Properties;
import thebombzen.mods.thebombzenapi.ThebombzenAPI;
import thebombzen.mods.thebombzenapi.ThebombzenAPIBaseMod;
import thebombzen.mods.thebombzenapi.ThebombzenAPIConfigOption;

public abstract class ThebombzenAPIConfiguration<T extends Enum<T>> {
    protected ThebombzenAPIBaseMod mod;
    protected Class<T> optionClass;
    protected Properties properties = new Properties();
    protected File propsFile;
    protected long lastCheckedConfigLastModified;

    public ThebombzenAPIConfiguration(ThebombzenAPIBaseMod baseMod, Class<T> optionClass) {
        this.mod = baseMod;
        this.optionClass = optionClass;
        this.propsFile = new File(new File(ThebombzenAPI.sideSpecificUtilities.getMinecraftDirectory(), "config"), this.mod.getClass().getSimpleName() + ".cfg");
    }

    public ThebombzenAPIConfigOption[] getAllOptions() {
        return (ThebombzenAPIConfigOption[])this.optionClass.getEnumConstants();
    }

    public String getProperty(ThebombzenAPIConfigOption option) {
        String value = this.properties.getProperty(option.toString());
        return value != null ? value : "";
    }

    public boolean getPropertyBoolean(ThebombzenAPIConfigOption option) {
        return Boolean.parseBoolean(this.getProperty(option));
    }

    protected File getPropertyFile() {
        return this.propsFile;
    }

    private void initializeDefaults() {
        for (ThebombzenAPIConfigOption option : this.getAllOptions()) {
            this.setPropertyWithoutSave(option, option.getDefaultValue());
        }
    }

    public void load() throws IOException {
        this.initializeDefaults();
        this.loadProperties();
        this.saveProperties();
    }

    protected void loadProperties() throws IOException {
        if (!this.propsFile.exists()) {
            this.propsFile.createNewFile();
        }
        BufferedReader reader = new BufferedReader(new FileReader(this.propsFile));
        this.properties.load(reader);
        ((Reader)reader).close();
        for (ThebombzenAPIConfigOption option : this.getAllOptions()) {
            if (option.getDefaultToggleIndex() < 0) continue;
            this.mod.setToggleDefaultEnabled(option.getDefaultToggleIndex(), this.getPropertyBoolean(option));
        }
        this.lastCheckedConfigLastModified = this.getPropertyFile().lastModified();
    }

    public boolean reloadPropertiesFromFileIfChanged() throws IOException {
        if (this.shouldRefreshConfig()) {
            this.loadProperties();
            return true;
        }
        return false;
    }

    public void saveProperties() {
        try {
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(this.getPropertyFile())));
            this.properties.store(writer, this.mod.getLongName() + " basic properties");
            Object[] options = this.getAllOptions();
            Arrays.sort(options);
            StringBuilder builder = new StringBuilder();
            for (Object option : options) {
                builder.append("# ").append(option.toString()).append(ThebombzenAPI.newLine);
                for (String info : option.getInfo()) {
                    builder.append("#     ").append(info).append(ThebombzenAPI.newLine);
                }
            }
            writer.write(builder.toString());
            writer.flush();
            writer.close();
            this.lastCheckedConfigLastModified = this.getPropertyFile().lastModified();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setProperty(ThebombzenAPIConfigOption option, String value) {
        this.setPropertyWithoutSave(option, value);
        this.saveProperties();
    }

    protected void setPropertyWithoutSave(ThebombzenAPIConfigOption option, String value) {
        this.properties.setProperty(option.toString(), value);
    }

    protected boolean shouldRefreshConfig() {
        long configLastModified = this.getPropertyFile().lastModified();
        return this.lastCheckedConfigLastModified != configLastModified;
    }
}

