/*
 * Decompiled with CFR 0.152.
 */
package com.minimap.settings;

import com.minimap.XaeroMinimap;
import com.minimap.events.ControlsHandler;
import com.minimap.interfaces.Interface;
import com.minimap.interfaces.InterfaceHandler;
import com.minimap.minimap.Minimap;
import com.minimap.minimap.Waypoint;
import com.minimap.settings.ModOptions;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.settings.KeyBinding;

public class ModSettings {
    public static final String[] ENCHANT_COLORS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    public static final String[] ENCHANT_COLOR_NAMES = new String[]{"Black", "Dark Blue", "Dark Green", "Dark Aqua", "Dark Red", "Dark Purple", "Gold", "Gray", "Dark Gray", "Blue", "Green", "Aqua", "Red", "Purple", "Yellow", "White"};
    public static final int[] COLORS = new int[]{new Color(0, 0, 0, 255).hashCode(), new Color(0, 0, 170, 255).hashCode(), new Color(0, 170, 0, 255).hashCode(), new Color(0, 170, 170, 255).hashCode(), new Color(170, 0, 0, 255).hashCode(), new Color(170, 0, 170, 255).hashCode(), new Color(255, 170, 0, 255).hashCode(), new Color(170, 170, 170, 255).hashCode(), new Color(85, 85, 85, 255).hashCode(), new Color(85, 85, 255, 255).hashCode(), new Color(85, 255, 85, 255).hashCode(), new Color(85, 255, 255, 255).hashCode(), new Color(155, 85, 85, 255).hashCode(), new Color(255, 85, 255, 255).hashCode(), new Color(255, 255, 85, 255).hashCode(), new Color(255, 255, 255, 255).hashCode()};
    public static final String[] MINIMAP_SIZE = new String[]{"Tiny", "Small", "Medium", "Large"};
    public static final String format = "\u00a7";
    public static final int defaultSettings = Integer.MAX_VALUE;
    public static int serverSettings = Integer.MAX_VALUE;
    public static KeyBinding keyBindSettings = new KeyBinding("Minimap Settings", 21, "Xaero's Minimap");
    public static KeyBinding keyBindZoom = new KeyBinding("Minimap Zoom In", 23, "Xaero's Minimap");
    public static KeyBinding keyBindZoom1 = new KeyBinding("Minimap Zoom Out", 24, "Xaero's Minimap");
    public static KeyBinding newWaypoint = new KeyBinding("New Waypoint", 48, "Xaero's Minimap");
    private boolean minimap = true;
    public int zoom = 2;
    public int entityAmount = 1;
    private boolean showPlayers = true;
    private boolean showMobs = true;
    private boolean showItems = true;
    private boolean showOther = true;
    private boolean caveMaps = true;
    private boolean showOtherTeam = true;
    private boolean showWaypoints = true;
    public int mapSize = 2;
    private static boolean keysLoaded = false;

    public boolean getMinimap() {
        return this.minimap && !this.minimapDisabled();
    }

    public boolean getShowPlayers() {
        return this.showPlayers && !this.minimapDisplayPlayersDisabled();
    }

    public boolean getShowMobs() {
        return this.showMobs && !this.minimapDisplayMobsDisabled();
    }

    public boolean getShowItems() {
        return this.showItems && !this.minimapDisplayItemsDisabled();
    }

    public boolean getShowOther() {
        return this.showOther && !this.minimapDisplayOtherDisabled();
    }

    public boolean getCaveMaps() {
        return this.caveMaps && !this.caveMapsDisabled();
    }

    public boolean getShowOtherTeam() {
        return this.showOtherTeam && !this.showOtherTeamDisabled();
    }

    public boolean getShowWaypoints() {
        return this.showWaypoints && !this.showWaypointsDisabled();
    }

    public ModSettings() {
        if (!keysLoaded) {
            XaeroMinimap.ch = new ControlsHandler();
            keysLoaded = true;
        }
    }

    public void saveSettings() throws IOException {
        PrintWriter writer = new PrintWriter(new FileWriter(XaeroMinimap.optionsFile));
        writer.println("minimap:" + this.minimap);
        writer.println("caveMaps:" + this.caveMaps);
        writer.println("showPlayers:" + this.showPlayers);
        writer.println("showMobs:" + this.showMobs);
        writer.println("showItems:" + this.showItems);
        writer.println("showOther:" + this.showOther);
        writer.println("showWaypoints:" + this.showWaypoints);
        writer.println("zoom:" + this.zoom);
        writer.println("mapSize:" + this.mapSize);
        writer.println("entityAmount:" + this.entityAmount);
        for (Interface l : InterfaceHandler.list) {
            writer.println("interface:" + l.iname + ":" + l.actualx + ":" + l.actualy + ":" + l.centered + ":" + l.flipped + ":" + l.fromRight);
        }
        if (!Minimap.waypointMap.isEmpty()) {
            Set<Map.Entry<String, ArrayList<Waypoint>>> keyMap = Minimap.waypointMap.entrySet();
            for (Map.Entry<String, ArrayList<Waypoint>> entry : keyMap) {
                String worldID = entry.getKey();
                ArrayList<Waypoint> waypoints = entry.getValue();
                for (Waypoint w : waypoints) {
                    writer.println("waypoint:" + worldID + ":" + w.name + ":" + w.symbol + ":" + w.x + ":" + w.y + ":" + w.z + ":" + w.color);
                }
            }
        }
        for (int i = 0; i < ControlsHandler.toAdd.length; ++i) {
            KeyBinding kb = ControlsHandler.toAdd[i];
            writer.println("key_" + kb.func_151464_g() + ":" + kb.func_151463_i());
        }
        writer.close();
    }

    public void loadSettings() throws IOException {
        String s;
        if (!XaeroMinimap.optionsFile.exists()) {
            this.saveSettings();
            return;
        }
        Minimap.waypointMap.clear();
        BufferedReader reader = new BufferedReader(new FileReader(XaeroMinimap.optionsFile));
        block2: while ((s = reader.readLine()) != null) {
            String[] args = s.split(":");
            try {
                if (args[0].equalsIgnoreCase("minimap")) {
                    this.minimap = args[1].equals("true");
                }
                if (args[0].equalsIgnoreCase("caveMaps")) {
                    this.caveMaps = args[1].equals("true");
                }
                if (args[0].equalsIgnoreCase("showPlayers")) {
                    this.showPlayers = args[1].equals("true");
                }
                if (args[0].equalsIgnoreCase("showMobs")) {
                    this.showMobs = args[1].equals("true");
                }
                if (args[0].equalsIgnoreCase("showItems")) {
                    this.showItems = args[1].equals("true");
                }
                if (args[0].equalsIgnoreCase("showOther")) {
                    this.showOther = args[1].equals("true");
                }
                if (args[0].equalsIgnoreCase("showWaypoints")) {
                    this.showWaypoints = args[1].equals("true");
                }
                if (args[0].equalsIgnoreCase("zoom")) {
                    this.zoom = Integer.parseInt(args[1]);
                }
                if (args[0].equalsIgnoreCase("mapSize")) {
                    this.mapSize = Integer.parseInt(args[1]);
                }
                if (args[0].equalsIgnoreCase("entityAmount")) {
                    this.entityAmount = Integer.parseInt(args[1]);
                }
                if (args[0].equalsIgnoreCase("interface")) {
                    for (Interface l : InterfaceHandler.list) {
                        if (!args[1].equals(l.iname)) continue;
                        l.actualx = l.x = Integer.parseInt(args[2]);
                        l.bx = l.x;
                        l.actualy = l.y = Integer.parseInt(args[3]);
                        l.by = l.y;
                        l.bcentered = l.centered = args[4].equals("true");
                        l.bflipped = l.flipped = args[5].equals("true");
                        l.bfromRight = l.fromRight = args[6].equals("true");
                    }
                }
                if (args[0].equalsIgnoreCase("waypoint")) {
                    Minimap.addWorld(args[1]);
                    ArrayList<Waypoint> waypoints = Minimap.waypointMap.get(args[1]);
                    if (waypoints != null) {
                        waypoints.add(new Waypoint(Integer.parseInt(args[4]), Integer.parseInt(args[5]), Integer.parseInt(args[6]), args[2], args[3], Integer.parseInt(args[7])));
                    }
                }
                if (!args[0].startsWith("key_")) continue;
                for (int i = 0; i < ControlsHandler.toAdd.length; ++i) {
                    KeyBinding kb = ControlsHandler.toAdd[i];
                    if (!kb.func_151464_g().equals(args[0].substring(4))) continue;
                    kb.func_151462_b(Integer.parseInt(args[1]));
                    continue block2;
                }
            }
            catch (Exception e) {
                System.out.println("Skipping setting:" + args[0]);
            }
        }
        KeyBinding.func_74508_b();
    }

    public String getKeyBinding(ModOptions par1EnumOptions) {
        String s = par1EnumOptions.getEnumString() + ": ";
        if (par1EnumOptions == ModOptions.EDIT) {
            s = par1EnumOptions.getEnumString();
        } else if (par1EnumOptions == ModOptions.RESET) {
            s = par1EnumOptions.getEnumString();
        } else if (par1EnumOptions == ModOptions.ZOOM) {
            s = s + this.zoom + "x";
        } else if (par1EnumOptions == ModOptions.SIZE) {
            s = s + MINIMAP_SIZE[this.mapSize];
        } else if (par1EnumOptions == ModOptions.EAMOUNT) {
            s = s + 100 * this.entityAmount;
        } else {
            boolean clientSetting = this.getClientBooleanValue(par1EnumOptions);
            boolean serverSetting = this.getBooleanValue(par1EnumOptions);
            s = s + ModSettings.getTranslation(clientSetting) + (serverSetting != clientSetting ? "\u00a7e (" + ModSettings.getTranslation(serverSetting) + ")" : "");
        }
        return s;
    }

    public boolean getBooleanValue(ModOptions o) {
        if (o == ModOptions.MINIMAP) {
            return this.getMinimap();
        }
        if (o == ModOptions.CAVE_MAPS) {
            return this.getCaveMaps();
        }
        if (o == ModOptions.DISPLAY_OTHER_TEAM) {
            return this.getShowOtherTeam();
        }
        if (o == ModOptions.WAYPOINTS) {
            return this.getShowWaypoints();
        }
        if (o == ModOptions.PLAYERS) {
            return this.getShowPlayers();
        }
        if (o == ModOptions.MOBS) {
            return this.getShowMobs();
        }
        if (o == ModOptions.ITEMS) {
            return this.getShowItems();
        }
        if (o == ModOptions.ENTITIES) {
            return this.getShowOther();
        }
        return false;
    }

    public boolean getClientBooleanValue(ModOptions o) {
        if (o == ModOptions.MINIMAP) {
            return this.minimap;
        }
        if (o == ModOptions.CAVE_MAPS) {
            return this.caveMaps;
        }
        if (o == ModOptions.DISPLAY_OTHER_TEAM) {
            return this.showOtherTeam;
        }
        if (o == ModOptions.WAYPOINTS) {
            return this.showWaypoints;
        }
        if (o == ModOptions.CAVE_MAPS) {
            return this.caveMaps;
        }
        if (o == ModOptions.PLAYERS) {
            return this.showPlayers;
        }
        if (o == ModOptions.MOBS) {
            return this.showMobs;
        }
        if (o == ModOptions.ITEMS) {
            return this.showItems;
        }
        if (o == ModOptions.ENTITIES) {
            return this.showOther;
        }
        return false;
    }

    private static String getTranslation(boolean o) {
        return o ? "ON" : "OFF";
    }

    public void setOptionValue(ModOptions par1EnumOptions, int par2) throws IOException {
        if (par1EnumOptions == ModOptions.ZOOM) {
            this.zoom = (this.zoom + 1) % 6;
            if (this.zoom == 0) {
                this.zoom = 1;
            }
        }
        if (par1EnumOptions == ModOptions.SIZE) {
            this.mapSize = (this.mapSize + 1) % 4;
            InterfaceHandler.minimap.resetImage();
        }
        if (par1EnumOptions == ModOptions.EAMOUNT) {
            this.entityAmount = (this.entityAmount + 1) % 11;
            if (this.entityAmount == 0) {
                this.entityAmount = 1;
            }
        }
        if (par1EnumOptions == ModOptions.MINIMAP) {
            boolean bl = this.minimap = !this.minimap;
        }
        if (par1EnumOptions == ModOptions.CAVE_MAPS) {
            boolean bl = this.caveMaps = !this.caveMaps;
        }
        if (par1EnumOptions == ModOptions.DISPLAY_OTHER_TEAM) {
            boolean bl = this.showOtherTeam = !this.showOtherTeam;
        }
        if (par1EnumOptions == ModOptions.WAYPOINTS) {
            boolean bl = this.showWaypoints = !this.showWaypoints;
        }
        if (par1EnumOptions == ModOptions.PLAYERS) {
            boolean bl = this.showPlayers = !this.showPlayers;
        }
        if (par1EnumOptions == ModOptions.MOBS) {
            boolean bl = this.showMobs = !this.showMobs;
        }
        if (par1EnumOptions == ModOptions.ITEMS) {
            boolean bl = this.showItems = !this.showItems;
        }
        if (par1EnumOptions == ModOptions.ENTITIES) {
            this.showOther = !this.showOther;
        }
        this.saveSettings();
    }

    public boolean minimapDisabled() {
        return (serverSettings & 1) != 1;
    }

    public boolean minimapDisplayPlayersDisabled() {
        return (serverSettings & 0x400) != 1024;
    }

    public boolean minimapDisplayMobsDisabled() {
        return (serverSettings & 0x800) != 2048;
    }

    public boolean minimapDisplayItemsDisabled() {
        return (serverSettings & 0x1000) != 4096;
    }

    public boolean minimapDisplayOtherDisabled() {
        return (serverSettings & 0x2000) != 8192;
    }

    public boolean caveMapsDisabled() {
        return (serverSettings & 0x4000) != 16384;
    }

    public boolean showOtherTeamDisabled() {
        return (serverSettings & 0x8000) != 32768;
    }

    public boolean showWaypointsDisabled() {
        return (serverSettings & 0x10000) != 65536;
    }

    public void resetServerSettings() {
        serverSettings = Integer.MAX_VALUE;
    }

    public static void setServerSettings() {
    }
}

