/*
 * Decompiled with CFR 0.152.
 */
package com.minimap.minimap;

import com.minimap.XaeroMinimap;
import com.minimap.animation.Animation;
import com.minimap.interfaces.Interface;
import com.minimap.minimap.DynamicTexture;
import com.minimap.minimap.MinimapChunk;
import com.minimap.minimap.Waypoint;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.chunk.Chunk;

public class Minimap {
    public Interface screen;
    public static final int frame = 9;
    public static final int loadSide = 16;
    public Minecraft mc = Minecraft.func_71410_x();
    private boolean loadedCaving = false;
    private boolean loadingCaving = false;
    public static final Color radarMobs = new Color(255, 237, 36);
    public static final Color radarPlayers = new Color(255, 255, 255);
    public static final Color radarItems = new Color(255, 0, 0);
    public static final Color radarOther = new Color(174, 0, 255);
    public static final ResourceLocation mapTextures = new ResourceLocation("xaeromaptexture");
    public static DynamicTexture mapTexture = new DynamicTexture(mapTextures);
    public static MinimapChunk[][] mapBlocks0 = new MinimapChunk[16][16];
    public static MinimapChunk[][] mapBlocks1 = new MinimapChunk[16][16];
    public static ArrayList<Entity> loadedEntities = new ArrayList();
    public static int blocksLoaded = 0;
    public int loadingMapX = 0;
    public int loadingMapZ = 0;
    public int loadedMapX = 0;
    public int loadedMapZ = 0;
    public double minimapZoom = 1.0;
    public int minimapWidth = 0;
    public int minimapHeight = 0;
    public MapLoader loader = new MapLoader();
    public static HashMap<String, ArrayList<Waypoint>> waypointMap = new HashMap();
    public static ArrayList<Waypoint> waypoints = null;
    private static String worldID = null;
    public MinimapChunk[][] currentBlocks = mapBlocks1;
    public MinimapChunk[][] loadingBlocks = mapBlocks0;
    int underRed = -1;
    int underGreen = -1;
    int underBlue = -1;
    int blockY = 0;
    int blockColor = 0;
    public static int lastBlockY = -1;
    public static int lastX = 0;
    boolean isglowing = false;
    private byte[] bytes = new byte[786432];
    private byte drawYState = 0;
    private boolean toResetImage = false;
    public double zoom = 1.0;

    private String getWorld() {
        if (this.mc.func_71401_C() != null) {
            return this.mc.func_71401_C().func_71270_I() + "_" + this.mc.field_71441_e.field_73011_w.getSaveFolder();
        }
        return "Multiplayer_" + this.mc.func_147104_D().field_78845_b + "_" + this.mc.field_71441_e.field_73011_w.getSaveFolder();
    }

    private static ArrayList<Waypoint> getWaypoints() {
        return waypointMap.get(worldID);
    }

    public static void addWorld(String id) {
        if (waypointMap.get(id) == null) {
            waypointMap.put(id, new ArrayList());
        }
    }

    public void updateWaypoints() {
        worldID = this.getWorld();
        waypoints = Minimap.getWaypoints();
        Minimap.addWorld(worldID);
    }

    public Minimap(Interface i) {
        this.screen = i;
        new Thread(this.loader).start();
    }

    public Block findBlock(Chunk bchunk, int insideX, int insideZ, int highY, int lowY) {
        boolean underair = false;
        for (int i = highY; i >= lowY; --i) {
            Block got = bchunk.func_177438_a(insideX, i, insideZ);
            if (!(got instanceof BlockAir) && underair) {
                if (got == Blocks.field_150355_j || got == Blocks.field_150358_i) {
                    this.underRed = 0;
                    this.underGreen = 100;
                    this.underBlue = 225;
                    continue;
                }
                if (got == Blocks.field_150359_w || got instanceof BlockStainedGlass) {
                    this.underRed = 255;
                    this.underGreen = 255;
                    this.underBlue = 255;
                    continue;
                }
                if (got == Blocks.field_150478_aa) {
                    this.underRed = 255;
                    this.underGreen = 227;
                    this.underBlue = 150;
                    continue;
                }
                this.blockY = i;
                int i5 = bchunk.func_177418_c(new BlockPos(insideX, this.blockY, insideZ));
                int color = got.func_180659_g((IBlockState)got.func_176203_a((int)i5)).field_76291_p;
                if (color == 0) continue;
                this.blockColor = color;
                return got;
            }
            if (!(got instanceof BlockAir)) continue;
            underair = true;
        }
        return null;
    }

    public void loadBlockColor(int par1, int par2) {
        MinimapChunk chunk;
        int lowY;
        int chunkX = par1 >> 4;
        int chunkZ = par2 >> 4;
        int insideX = par1 & 0xF;
        int insideZ = par2 & 0xF;
        int playerY = (int)this.mc.field_71439_g.field_70163_u;
        Chunk bchunk = this.mc.field_71439_g.field_70170_p.func_72964_e(chunkX, chunkZ);
        chunkX -= this.loadingMapX;
        chunkZ -= this.loadingMapZ;
        int height = bchunk.func_76611_b(insideX, insideZ);
        int highY = this.loadingCaving ? playerY + 1 : height + 3;
        int n = lowY = this.loadingCaving ? playerY - 30 : 0;
        if (lowY < 0) {
            lowY = 0;
        }
        this.blockY = 0;
        this.blockColor = 0;
        this.underRed = -1;
        this.underGreen = -1;
        this.underBlue = -1;
        this.isglowing = false;
        Block block = this.findBlock(bchunk, insideX, insideZ, highY, lowY);
        this.isglowing = block == Blocks.field_150353_l || block == Blocks.field_150356_k || block == Blocks.field_150426_aN;
        double brightness = 1.1;
        if (this.loadingCaving || this.underRed != -1) {
            brightness = (double)this.blockY / (double)height;
        }
        if (brightness > 1.0) {
            brightness = 1.0;
        }
        if (par1 != lastX) {
            lastBlockY = this.blockY;
        }
        double secondaryB = 1.0;
        if (this.blockY < lastBlockY) {
            secondaryB -= 0.15;
        }
        if (this.blockY > lastBlockY) {
            secondaryB += 0.15;
        }
        brightness *= secondaryB;
        lastBlockY = this.blockY;
        lastX = par1;
        if (this.blockColor == 0) {
            this.blockColor = 1;
        }
        int l = this.blockColor >> 16 & 0xFF;
        int i1 = this.blockColor >> 8 & 0xFF;
        int j1 = this.blockColor & 0xFF;
        if ((l = (int)((double)l * (this.isglowing ? 1.0 : brightness))) > 255) {
            l = 255;
        }
        if ((i1 = (int)((double)i1 * (this.isglowing ? 1.0 : brightness))) > 255) {
            i1 = 255;
        }
        if ((j1 = (int)((double)j1 * (this.isglowing ? 1.0 : brightness))) > 255) {
            j1 = 255;
        }
        if (this.underRed != -1) {
            l = (l + this.underRed) / 2;
        }
        if (this.underGreen != -1) {
            i1 = (i1 + this.underGreen) / 2;
        }
        if (this.underBlue != -1) {
            j1 = (j1 + this.underBlue) / 2;
        }
        this.blockColor = 0xFF000000 | l << 16 | i1 << 8 | j1;
        if (chunkX < 0 || chunkX >= 16 || chunkZ < 0 || chunkZ >= 16) {
            return;
        }
        MinimapChunk[] chunkmap = this.loadingBlocks[chunkX];
        if (chunkmap == null) {
            chunkmap = new MinimapChunk[16];
            this.loadingBlocks[chunkX] = chunkmap;
        }
        if ((chunk = chunkmap[chunkZ]) == null) {
            chunkmap[chunkZ] = chunk = new MinimapChunk();
        }
        chunk.colors[insideX][insideZ] = this.blockColor;
    }

    public int getMapX() {
        return (Minimap.myFloor(this.mc.field_71439_g.field_70165_t) >> 4) - 8;
    }

    public int getMapZ() {
        return (Minimap.myFloor(this.mc.field_71439_g.field_70161_v) >> 4) - 8;
    }

    public int getLoadedBlockColor(int par1, int par2) {
        int chunkX = (par1 >> 4) - this.loadedMapX;
        int chunkZ = (par2 >> 4) - this.loadedMapZ;
        if (chunkX < 0 || chunkX >= 16 || chunkZ < 0 || chunkZ >= 16) {
            return 1;
        }
        if (this.currentBlocks[chunkX][chunkZ] != null) {
            return this.currentBlocks[chunkX][chunkZ].colors[par1 & 0xF][par2 & 0xF];
        }
        return 1;
    }

    public double getAngle() {
        double angle;
        double rotation = this.mc.field_71439_g.field_70177_z;
        if (rotation < 0.0) {
            rotation += 360.0;
        }
        if ((angle = 270.0 - rotation) < 0.0) {
            angle += 360.0;
        }
        angle /= 180.0;
        return angle *= Math.PI;
    }

    public double getZoom() {
        return this.minimapZoom + 1.0;
    }

    public void updateZoom() {
        double target = (double)XaeroMinimap.getSettings().zoom * (this.loadedCaving ? 3.0 : 1.0);
        if (target > 5.0) {
            target = 5.0;
        }
        double off = target - this.minimapZoom;
        off = Animation.animate(off, 0.8);
        this.minimapZoom = target - off;
    }

    public double getPlayerX() {
        return this.mc.field_71439_g.field_70165_t;
    }

    public double getPlayerZ() {
        return this.mc.field_71439_g.field_70161_v;
    }

    public void resetImage() {
        this.toResetImage = true;
    }

    public static int myFloor(double d) {
        if (d < 0.0) {
            d -= 1.0;
        }
        return (int)d;
    }

    public void updateMapFrame(int mapW, int mapH) {
        double X;
        double offx;
        double angle = this.getAngle();
        double ps = Math.sin(Math.PI - angle);
        double pc = Math.cos(Math.PI - angle);
        int currentState = this.drawYState;
        EntityPlayerSP p = this.mc.field_71439_g;
        int halfW = mapW / 2;
        int halfH = mapH / 2;
        this.updateZoom();
        double sizedZoom = (double)mapW / 225.0;
        this.zoom = this.getZoom() * sizedZoom;
        long before = System.currentTimeMillis();
        if (this.toResetImage) {
            this.bytes = new byte[786432];
            this.toResetImage = false;
        }
        double halfWZoomed = (double)halfW / this.zoom;
        double halfHZoomed = (double)halfH / this.zoom;
        for (int currentX = 0; currentX <= mapW; ++currentX) {
            double currentXZoomed = (double)currentX / this.zoom;
            offx = currentXZoomed - halfWZoomed;
            double psx = ps * offx;
            double pcx = pc * offx;
            for (int currentY = currentState; currentY <= mapH; currentY += 2) {
                int blockZ;
                double offy = (double)currentY / this.zoom - halfHZoomed;
                double Y = ps * offy - pcx;
                X = psx + pc * offy;
                int blockX = Minimap.myFloor(this.getPlayerX() + X);
                int j = this.getLoadedBlockColor(blockX, blockZ = Minimap.myFloor(this.getPlayerZ() + Y));
                if (j == 0) continue;
                this.putColor(this.bytes, currentX + 8, currentY + 8, j);
            }
            currentState = (byte)(currentState != 1 ? 1 : 0);
        }
        this.drawYState = (byte)(this.drawYState != 1 ? 1 : 0);
        for (int i = 0; i < loadedEntities.size(); ++i) {
            try {
                double brightness;
                Entity e = loadedEntities.get(i);
                if (e.func_70093_af() || e.func_82150_aj()) continue;
                offx = e.field_70165_t - p.field_70165_t;
                double offz = e.field_70161_v - p.field_70161_v;
                double offh = p.field_70163_u - e.field_70163_u;
                double Z = pc * offx + ps * offz;
                X = ps * offx - pc * offz;
                int drawX = mapW / 2 + (int)(X * this.zoom);
                int drawY = mapH / 2 + (int)(Z * this.zoom);
                int color = radarOther.hashCode();
                if (e instanceof EntityPlayer) {
                    color = radarPlayers.hashCode();
                } else if (e instanceof EntityLiving) {
                    color = radarMobs.hashCode();
                } else if (e instanceof EntityItem) {
                    color = radarItems.hashCode();
                }
                int l = color >> 16 & 0xFF;
                int i1 = color >> 8 & 0xFF;
                int j1 = color & 0xFF;
                double level = 20.0 - offh;
                if (level < 0.0) {
                    level = 0.0;
                }
                if ((l = (int)((double)l * (brightness = level / 20.0))) > 255) {
                    l = 255;
                }
                if ((i1 = (int)((double)i1 * brightness)) > 255) {
                    i1 = 255;
                }
                if ((j1 = (int)((double)j1 * brightness)) > 255) {
                    j1 = 255;
                }
                color = 0xFF000000 | l << 16 | i1 << 8 | j1;
                for (int a = drawX - 2; a < drawX + 4; ++a) {
                    if (a < 0 || a > mapW) continue;
                    for (int b = drawY - 2; b < drawY + 4; ++b) {
                        if (b < 0 || b > mapW || (a == drawX - 2 || a == drawX + 3) && (b == drawY - 2 || b == drawY + 3) || a == drawX + 2 && b == drawY - 2 || a == drawX + 3 && b == drawY - 1 || a == drawX - 2 && b == drawY + 2 || a == drawX - 1 && b == drawY + 3) continue;
                        if (a == drawX + 3 || b == drawY + 3 || a == drawX + 2 && b == drawY + 2) {
                            this.putColor(this.bytes, 8 + a, 8 + b, 0);
                            continue;
                        }
                        this.putColor(this.bytes, 8 + a, 8 + b, color);
                    }
                }
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Minimap.mapTexture.buffer.put(this.bytes);
        Minimap.mapTexture.buffer.flip();
    }

    private boolean isCaving() {
        if (!XaeroMinimap.settings.getCaveMaps()) {
            return false;
        }
        int x = Minimap.myFloor(this.getPlayerX());
        int y = (int)this.mc.field_71439_g.field_70163_u;
        int z = Minimap.myFloor(this.getPlayerZ());
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        int insideX = x & 0xF;
        int insideZ = z & 0xF;
        Chunk bchunk = this.mc.field_71439_g.field_70170_p.func_72964_e(chunkX, chunkZ);
        int top = bchunk.func_76611_b(insideX, insideZ);
        if (y < top) {
            for (int i = y; i < top; ++i) {
                Block got = bchunk.func_177438_a(x, i, z);
                if (!got.func_149688_o().func_76218_k()) continue;
                return true;
            }
        }
        return false;
    }

    private void putColor(byte[] bytes, int x, int y, int color) {
        int pixel = (y * 512 + x) * 3;
        bytes[pixel] = (byte)(color >> 16 & 0xFF);
        bytes[++pixel] = (byte)(color >> 8 & 0xFF);
        bytes[++pixel] = (byte)(color & 0xFF);
    }

    public class MapLoader
    implements Runnable {
        @Override
        public void run() {
            int updateChunkX = 0;
            int updateChunkZ = 0;
            int x = 0;
            int z = 0;
            while (true) {
                long before = System.currentTimeMillis();
                try {
                    if (XaeroMinimap.getSettings() != null && XaeroMinimap.getSettings().getMinimap() && Minimap.this.mc.field_71439_g != null) {
                        Minimap.this.updateWaypoints();
                        if (updateChunkX == 0 && updateChunkZ == 0) {
                            Minimap.this.loadingCaving = Minimap.this.isCaving();
                            x = Minimap.myFloor(Minimap.this.mc.field_71439_g.field_70165_t);
                            z = Minimap.myFloor(Minimap.this.mc.field_71439_g.field_70161_v);
                            Minimap.this.loadingMapX = Minimap.this.getMapX();
                            Minimap.this.loadingMapZ = Minimap.this.getMapZ();
                        }
                        long before1 = System.currentTimeMillis();
                        this.updateChunk(updateChunkX, updateChunkZ);
                        if (updateChunkX == 15 && updateChunkZ == 15) {
                            MinimapChunk[][] bu = Minimap.this.currentBlocks;
                            Minimap.this.currentBlocks = Minimap.this.loadingBlocks;
                            Minimap.this.loadingBlocks = bu;
                            Minimap.this.loadingBlocks = new MinimapChunk[16][16];
                            Minimap.this.loadedMapX = Minimap.this.loadingMapX;
                            Minimap.this.loadedMapZ = Minimap.this.loadingMapZ;
                            Minimap.this.loadedCaving = Minimap.this.loadingCaving;
                        }
                        if ((updateChunkX = (updateChunkX + 1) % 16) == 0) {
                            updateChunkZ = (updateChunkZ + 1) % 16;
                            EntityPlayerSP p = Minimap.this.mc.field_71439_g;
                            ArrayList<Entity> loadingEntities = new ArrayList<Entity>();
                            for (int i = 0; i < p.field_70170_p.field_72996_f.size(); ++i) {
                                try {
                                    Entity e = (Entity)p.field_70170_p.field_72996_f.get(i);
                                    if (e instanceof EntityPlayer ? e != p && (!XaeroMinimap.getSettings().getShowPlayers() || !XaeroMinimap.settings.getShowOtherTeam() && p.func_96124_cp() != ((EntityLivingBase)e).func_96124_cp()) : (e instanceof EntityLiving ? !XaeroMinimap.getSettings().getShowMobs() : (e instanceof EntityItem ? !XaeroMinimap.getSettings().getShowItems() : !XaeroMinimap.getSettings().getShowOther()))) continue;
                                    double offx = e.field_70165_t - p.field_70165_t;
                                    double offy = e.field_70161_v - p.field_70161_v;
                                    double offh = p.field_70163_u - e.field_70163_u;
                                    double offheight2 = offh * offh;
                                    double offx2 = offx * offx;
                                    double offy2 = offy * offy;
                                    double maxDistance = 31250.0 / (Minimap.this.getZoom() * Minimap.this.getZoom());
                                    if (offx2 > maxDistance || offy2 > maxDistance || offheight2 > 400.0) continue;
                                    loadingEntities.add(e);
                                    if (loadingEntities.size() < 100 * XaeroMinimap.getSettings().entityAmount) continue;
                                    break;
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            loadedEntities = loadingEntities;
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                int passed = (int)(System.currentTimeMillis() - before);
                try {
                    if (passed <= 5) {
                        Thread.sleep(5 - passed);
                        continue;
                    }
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                }
            }
        }

        public void updateChunk(int x, int z) {
            int chunkX = Minimap.this.loadingMapX + x;
            int chunkZ = Minimap.this.loadingMapZ + z;
            int x1 = chunkX * 16;
            int z1 = chunkZ * 16;
            for (int blockX = x1; blockX < x1 + 16; ++blockX) {
                for (int blockZ = z1; blockZ < z1 + 16; ++blockZ) {
                    Minimap.this.loadBlockColor(blockX, blockZ);
                }
            }
        }
    }
}

