/*
 * Decompiled with CFR 0.152.
 */
package com.chunkbase.mod.forge.mods.villageinfossp.display;

import com.chunkbase.mod.forge.mods.villageinfossp.display.IDisplay;
import com.chunkbase.mod.forge.mods.villageinfossp.villagedata.IVillageDataAccess;
import com.chunkbase.mod.forge.mods.villageinfossp.villagedata.VillageData;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;

public final class Display
implements IDisplay {
    private final Minecraft mc;
    private IVillageDataAccess villageDataAccess;

    public Display(Minecraft mc, IVillageDataAccess villageDataAccess) {
        this.mc = mc;
        this.villageDataAccess = villageDataAccess;
    }

    @Override
    public void addVillageInfoToList(List<String> list) {
        EntityPlayerSP player = this.mc.field_71439_g;
        WorldClient world = this.mc.field_71441_e;
        if (player == null || world == null || this.villageDataAccess == null || !this.mc.field_71474_y.field_74330_P) {
            return;
        }
        list.add(null);
        VillageData village = this.villageDataAccess.getVillageData();
        if (village == null) {
            list.add("No village info available");
            return;
        }
        if (!village.isVillageFound()) {
            list.add("No Village Found");
            return;
        }
        int radius = village.getRadius();
        BlockPos center = village.getCenter();
        double distanceCenter = Math.sqrt(center.func_177954_c((double)MathHelper.func_76128_c((double)this.mc.field_71439_g.field_70165_t), (double)MathHelper.func_76128_c((double)this.mc.field_71439_g.field_70163_u), (double)MathHelper.func_76128_c((double)this.mc.field_71439_g.field_70161_v)));
        double distance = distanceCenter - (double)radius;
        boolean showDetails = false;
        if (distance < 0.0) {
            list.add("Inside Village (ID: " + village.getId() + ")");
            showDetails = true;
        } else if (distance < 32.0) {
            list.add("Nearby Village Found (ID: " + village.getId() + ")");
            showDetails = true;
        } else {
            list.add("Distant Village Found (" + village.getId() + ")");
        }
        list.add("Center: (" + center.func_177958_n() + ", " + center.func_177956_o() + ", " + center.func_177952_p() + "), Radius: " + radius);
        list.add("Distance to Center: " + (int)distanceCenter);
        if (showDetails) {
            int maxVillagers = (int)((double)village.getNumDoors() * 0.35);
            list.add("Villagers: " + village.getNumVillagers() + " (" + maxVillagers + "), Golems: " + village.getNumGolems() + " (" + village.getNumVillagers() / 10 + ")");
            EnumChatFormatting houseColor = village.getNumDoors() > 20 ? EnumChatFormatting.GREEN : EnumChatFormatting.RED;
            list.add(houseColor + "Houses: " + village.getNumDoors());
            int reputation = village.getReputation();
            EnumChatFormatting repColor = reputation <= -15 ? EnumChatFormatting.RED : EnumChatFormatting.GREEN;
            list.add(repColor + "Reputation: " + reputation);
            String status = "Breeding Status: ";
            status = village.areBreeding() ? status + "OK" : status + "Stopped";
            list.add(status);
            boolean gsz = true;
            if (MathHelper.func_76128_c((double)this.mc.field_71439_g.field_70165_t) > center.func_177958_n() + 7) {
                gsz = false;
            }
            if (MathHelper.func_76128_c((double)this.mc.field_71439_g.field_70165_t) < center.func_177958_n() - 8) {
                gsz = false;
            }
            if (MathHelper.func_76128_c((double)this.mc.field_71439_g.func_174813_aQ().field_72338_b) > center.func_177956_o() + 2) {
                gsz = false;
            }
            if (MathHelper.func_76128_c((double)this.mc.field_71439_g.func_174813_aQ().field_72338_b) < center.func_177956_o() - 3) {
                gsz = false;
            }
            if (MathHelper.func_76128_c((double)this.mc.field_71439_g.field_70161_v) > center.func_177952_p() + 7) {
                gsz = false;
            }
            if (MathHelper.func_76128_c((double)this.mc.field_71439_g.field_70161_v) < center.func_177952_p() - 8) {
                gsz = false;
            }
            if (gsz) {
                list.add("Inside Golem Spawn Zone");
            }
        }
    }

    @Override
    public void setVillageDataAccess(IVillageDataAccess slimeChunks) {
        this.villageDataAccess = slimeChunks;
    }
}

