/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.core.version;

import com.github.lunatrius.core.handler.ConfigurationHandler;
import com.github.lunatrius.core.reference.Reference;
import com.google.common.base.Joiner;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;

public class VersionChecker {
    public static final String RECOMMENDED_FORGE = "\n---\nRecommended Forge: %s";
    public static final String VERCHECKAPI_URL = "http://mc.lunatri.us/json?latest=1&mc=%s&v=%d";
    public static final int VERCHECKAPI_VER = 2;
    public static final String VERSION = "%s -> %s";
    public static final String UPDATEAVAILABLE = "\nUpdate is available (%s -> %s)!";
    public static final String UPTODATE = "\nUp to date!";
    public static final String UPDATEAVAILABLECON = "Update is available for %s (%s -> %s)!";
    public static final String UPTODATECON = "%s is up to date!";
    public static final String FUTURECON = "Is %s from the future?";
    public static final String DYNIOUS_VERSIONCHECKER_MODID = "VersionChecker";
    public static final String UPDATE_URL = "https://mods.io/mods?author=Lunatrius";
    private static final List<ModMetadata> REGISTERED_MODS = new ArrayList<ModMetadata>();
    private static final Map<String, String> OUTDATED_MODS = new HashMap<String, String>();
    private static boolean done = false;

    @Deprecated
    public static void registerMod(ModMetadata modMetadata) {
        VersionChecker.registerMod(modMetadata, "11.14.0.1289-1.8");
    }

    public static void registerMod(ModMetadata modMetadata, String forgeVersion) {
        REGISTERED_MODS.add(modMetadata);
        if (modMetadata.description != null) {
            modMetadata.description = modMetadata.description + String.format(RECOMMENDED_FORGE, forgeVersion);
        }
    }

    public static Set<Map.Entry<String, String>> getOutdatedMods() {
        return OUTDATED_MODS.entrySet();
    }

    public static void setDone(boolean isDone) {
        done = isDone;
    }

    public static boolean isDone() {
        return done;
    }

    public static void startVersionCheck() {
        new Thread("LunatriusCore Version Check"){

            @Override
            public void run() {
                try {
                    if ("1.8" == null || "null".equals("1.8")) {
                        Reference.logger.error("Minecraft version is null! This is a bug!");
                        return;
                    }
                    URL url = new URL(String.format(VersionChecker.VERCHECKAPI_URL, "1.8", 2));
                    InputStream con = url.openStream();
                    String data = new String(ByteStreams.toByteArray((InputStream)con));
                    con.close();
                    Map json = (Map)new Gson().fromJson(data, Map.class);
                    if ((Double)json.get("version") == 2.0) {
                        Map mods = (Map)json.get("mods");
                        for (ModMetadata modMetadata : REGISTERED_MODS) {
                            String modid = modMetadata.modId;
                            DefaultArtifactVersion versionLocal = new DefaultArtifactVersion(modMetadata.version);
                            try {
                                Map latest;
                                Map mod = (Map)mods.get(modid);
                                if (mod == null || (latest = (Map)mod.get("latest")) == null) continue;
                                DefaultArtifactVersion versionRemote = new DefaultArtifactVersion((String)latest.get("version"));
                                int diff = versionRemote.compareTo((ArtifactVersion)versionLocal);
                                if (diff > 0) {
                                    ArrayList<String> changes = (ArrayList<String>)latest.get("changes");
                                    if (changes == null) {
                                        changes = new ArrayList<String>();
                                    }
                                    if (changes.size() == 0) {
                                        changes.add("No changelog available.");
                                    }
                                    if (ConfigurationHandler.canNotifyOfUpdate(modid, versionRemote.getVersionString())) {
                                        VersionChecker.addOutdatedMod(modMetadata, (ArtifactVersion)versionLocal, versionRemote, Joiner.on((String)"\n").join(changes));
                                    }
                                    modMetadata.description = modMetadata.description + String.format(VersionChecker.UPDATEAVAILABLE, versionLocal, versionRemote);
                                    Reference.logger.info(String.format(VersionChecker.UPDATEAVAILABLECON, modid, versionLocal, versionRemote));
                                } else if (diff == 0) {
                                    modMetadata.description = modMetadata.description + VersionChecker.UPTODATE;
                                    Reference.logger.info(String.format(VersionChecker.UPTODATECON, modid));
                                } else {
                                    Reference.logger.info(String.format(VersionChecker.FUTURECON, modid));
                                }
                                ConfigurationHandler.addUpdate(modid, versionRemote.getVersionString());
                            }
                            catch (Exception e) {
                                Reference.logger.error("Something went wrong!", (Throwable)e);
                            }
                        }
                    } else {
                        Reference.logger.warn(String.format("Unsupported version (%s)!", json.get("version")));
                    }
                }
                catch (Exception e) {
                    Reference.logger.error("Something went wrong!", (Throwable)e);
                }
                done = true;
            }
        }.start();
    }

    private static void addOutdatedMod(ModMetadata metadata, ArtifactVersion versionLocal, DefaultArtifactVersion versionRemote, String changeLog) {
        if (Loader.isModLoaded((String)DYNIOUS_VERSIONCHECKER_MODID)) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("modDisplayName", metadata.name);
            data.func_74778_a("oldVersion", versionLocal.getVersionString());
            data.func_74778_a("newVersion", versionRemote.getVersionString());
            data.func_74778_a("updateUrl", UPDATE_URL);
            data.func_74757_a("isDirectLink", false);
            data.func_74778_a("changeLog", changeLog);
            FMLInterModComms.sendRuntimeMessage((Object)metadata.modId, (String)DYNIOUS_VERSIONCHECKER_MODID, (String)"addUpdate", (NBTTagCompound)data);
        } else {
            OUTDATED_MODS.put(metadata.name, String.format(VERSION, versionLocal, versionRemote));
        }
    }
}

