/*
 * Decompiled with CFR 0.152.
 */
package com.slatebit.paintball.common;

import com.slatebit.paintball.common.EnumColor;
import com.slatebit.paintball.common.ItemMetadataBlock;
import com.slatebit.paintball.common.Paintball;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPressurePlate;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class BlockScanner
extends BlockPressurePlate {
    public static final PropertyEnum COLOR = PropertyEnum.func_177709_a((String)"color", EnumColor.class);
    private final BlockPressurePlate.Sensitivity sensitivity;

    public BlockScanner(Material material, BlockPressurePlate.Sensitivity sensitivity) {
        super(material, sensitivity);
        this.func_149711_c(0.8f);
        this.sensitivity = sensitivity;
        this.func_149672_a(Block.field_149775_l);
        this.func_149647_a(Paintball.TAB);
        GameRegistry.registerBlock((Block)this, ItemMetadataBlock.class, (String)"scanner");
    }

    public int func_180669_e(World world, BlockPos pos) {
        List list;
        AxisAlignedBB axisalignedbb = this.func_180667_a(pos);
        switch (this.sensitivity) {
            case EVERYTHING: {
                list = world.func_72839_b((Entity)null, axisalignedbb);
                break;
            }
            case MOBS: {
                list = world.func_72872_a(EntityLivingBase.class, axisalignedbb);
                break;
            }
            default: {
                return 0;
            }
        }
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (!(entity instanceof EntityPlayer) || entity.func_145773_az()) continue;
                int color = ((EnumColor)((Object)world.func_180495_p(pos).func_177229_b((IProperty)COLOR))).getMetadata();
                EntityPlayer entityplayer = (EntityPlayer)entity;
                if (!Paintball.isSameTeam(color, entityplayer.field_71071_by.field_70460_b)) continue;
                return 15;
            }
        }
        return 0;
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumColor)((Object)state.func_177229_b((IProperty)COLOR))).getMetadata();
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < 6; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public MapColor func_180659_g(IBlockState state) {
        return ((EnumColor)((Object)state.func_177229_b((IProperty)COLOR))).getMapColor();
    }

    public IBlockState func_176203_a(int meta) {
        EnumColor enumColor;
        switch (meta & 7) {
            case 0: {
                enumColor = EnumColor.RED;
                break;
            }
            case 1: {
                enumColor = EnumColor.ORANGE;
                break;
            }
            case 2: {
                enumColor = EnumColor.YELLOW;
                break;
            }
            case 3: {
                enumColor = EnumColor.GREEN;
                break;
            }
            case 4: {
                enumColor = EnumColor.BLUE;
                break;
            }
            default: {
                enumColor = EnumColor.PURPLE;
            }
        }
        return this.func_176223_P().func_177226_a((IProperty)COLOR, (Comparable)((Object)enumColor)).func_177226_a((IProperty)BlockPressurePlate.field_176580_a, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i;
        switch ((EnumColor)((Object)state.func_177229_b((IProperty)COLOR))) {
            case RED: {
                i = 1;
                break;
            }
            case ORANGE: {
                i = 2;
                break;
            }
            case YELLOW: {
                i = 3;
                break;
            }
            case GREEN: {
                i = 4;
                break;
            }
            default: {
                i = 5;
                break;
            }
            case PURPLE: {
                i = 0;
            }
        }
        if (((Boolean)state.func_177229_b((IProperty)BlockPressurePlate.field_176580_a)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{BlockPressurePlate.field_176580_a, COLOR});
    }
}

