/*
 * Decompiled with CFR 0.152.
 */
package com.slatebit.paintball.common;

import com.slatebit.paintball.common.PacketHandler;
import com.slatebit.paintball.common.Paintball;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.common.registry.IThrowableEntity;

public class EntityPellet
extends EntityArrow
implements IEntityAdditionalSpawnData,
IThrowableEntity {
    public int color = 0;
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private Block inTile = null;
    private int inData = 0;
    private boolean inGround = false;
    private int ticksInGround;
    private int ticksInAir = 0;
    private int damage;
    private int distance;
    private boolean hasDataWatcher;
    private double xStart;
    private double yStart;
    private double zStart;

    public EntityPellet(World world) {
        super(world);
        this.field_70155_l = 25.0;
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityPellet(World world, double x, double y, double z, int damage, int distance, int color) {
        super(world);
        this.field_70155_l = 25.0;
        this.func_70105_a(0.5f, 0.5f);
        this.func_70107_b(x, y, z);
        this.color = color;
        this.damage = damage;
        this.distance = distance;
        this.xStart = x;
        this.yStart = y;
        this.zStart = z;
        this.field_70180_af.func_75682_a(15, (Object)color);
        this.hasDataWatcher = true;
    }

    public EntityPellet(World world, EntityPlayer entityPlayer, int damage, int distance, int color) {
        super(world);
        this.field_70155_l = 25.0;
        this.field_70250_c = entityPlayer;
        this.field_70251_a = 0;
        this.func_70012_b(entityPlayer.field_70165_t, entityPlayer.field_70163_u + (double)entityPlayer.func_70047_e(), entityPlayer.field_70161_v, entityPlayer.field_70177_z, entityPlayer.field_70125_A);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70159_w = 10.0 * (double)(-MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * 3.141593f))) * (double)MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * 3.141593f));
        this.field_70179_y = 10.0 * (double)MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * 3.141593f)) * (double)MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * 3.141593f));
        this.field_70181_x = 10.0 * (double)(-MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * 3.141593f)));
        if (distance == 15) {
            this.field_70159_w += 2.0 * this.field_70146_Z.nextDouble() - 0.5;
            this.field_70181_x += 2.0 * this.field_70146_Z.nextDouble() - 0.5;
            this.field_70179_y += 2.0 * this.field_70146_Z.nextDouble() - 0.5;
        }
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, 1.5f, 1.0f);
        this.color = color;
        this.damage = damage;
        this.distance = distance;
        this.xStart = this.field_70165_t;
        this.yStart = this.field_70163_u;
        this.zStart = this.field_70161_v;
        this.field_70180_af.func_75682_a(15, (Object)color);
        this.hasDataWatcher = true;
    }

    public void func_70071_h_() {
        IBlockState state;
        Block var16;
        if (this.hasDataWatcher) {
            if (this.field_70170_p.field_72995_K) {
                this.color = this.field_70180_af.func_75679_c(15);
            } else {
                this.field_70180_af.func_75692_b(15, (Object)this.color);
            }
        }
        if (!this.field_70170_p.field_72995_K && Math.sqrt(Math.pow(this.field_70165_t - this.xStart, 2.0) + Math.pow(this.field_70163_u - this.yStart, 2.0) + Math.pow(this.field_70161_v - this.zStart, 2.0)) >= (double)this.distance) {
            this.func_70106_y();
        }
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float var1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(this.field_70181_x, var1) * 180.0 / Math.PI);
        }
        if ((var16 = (state = this.field_70170_p.func_180495_p(new BlockPos(this.xTile, this.yTile, this.zTile))).func_177230_c()) != Blocks.field_150350_a) {
            var16.func_180654_a((IBlockAccess)this.field_70170_p, new BlockPos(this.xTile, this.yTile, this.zTile));
            AxisAlignedBB var2 = var16.func_180640_a(this.field_70170_p, new BlockPos(this.xTile, this.yTile, this.zTile), state);
            if (var2 != null && var2.func_72318_a(new Vec3(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
                this.inGround = true;
            }
        }
        if (this.field_70249_b > 0) {
            --this.field_70249_b;
        }
        if (this.inGround) {
            int var19 = var16.func_176201_c(state);
            if (var16 == this.inTile && var19 == this.inData) {
                ++this.ticksInGround;
                this.field_70159_w = 0.0;
                this.field_70181_x = -1.0;
                this.field_70179_y = 0.0;
                if (this.ticksInGround == 1200) {
                    this.func_70106_y();
                }
            } else {
                this.inGround = false;
                this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.ticksInGround = 0;
                this.ticksInAir = 0;
            }
        } else {
            float var11;
            ++this.ticksInAir;
            Vec3 var17 = new Vec3(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3 var3 = new Vec3(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            MovingObjectPosition var4 = this.field_70170_p.func_147447_a(var17, var3, false, true, false);
            var17 = new Vec3(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            var3 = new Vec3(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            if (var4 != null) {
                var3 = new Vec3(var4.field_72307_f.field_72450_a, var4.field_72307_f.field_72448_b, var4.field_72307_f.field_72449_c);
            }
            Entity var5 = null;
            List var6 = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
            double var7 = 0.0;
            for (Entity var10 : var6) {
                double var14;
                if (!var10.func_70067_L() || var10 == this.field_70250_c && this.ticksInAir < 5) continue;
                var11 = 0.3f;
                AxisAlignedBB var12 = var10.func_174813_aQ().func_72314_b((double)var11, (double)var11, (double)var11);
                MovingObjectPosition var13 = var12.func_72327_a(var17, var3);
                if (var13 == null || !((var14 = var17.func_72438_d(var13.field_72307_f)) < var7) && var7 != 0.0) continue;
                var5 = var10;
                var7 = var14;
            }
            if (var5 != null) {
                var4 = new MovingObjectPosition(var5);
            }
            if (var4 != null) {
                if (var4.field_72308_g != null) {
                    EntityDamageSource damageSource = new EntityDamageSource("Paintball", this.field_70250_c);
                    if (var4.field_72308_g instanceof EntityPlayer && var4.field_72308_g != this.field_70250_c) {
                        EntityPlayer entityPlayer = (EntityPlayer)var4.field_72308_g;
                        InventoryPlayer inventory = entityPlayer.field_71071_by;
                        if (entityPlayer.field_71071_by != null && inventory.field_70460_b != null && !Paintball.isSameTeam(this.color, entityPlayer.field_71071_by.field_70460_b) && !entityPlayer.field_71075_bZ.field_75098_d) {
                            Paintball.NETWORK_HELPER.sendPacketToPlayer(new PacketHandler(((EntityPlayer)this.field_70250_c).getDisplayNameString(), 2), (EntityPlayer)this.field_70250_c);
                            entityPlayer.field_70172_ad = 0;
                            entityPlayer.func_70097_a((DamageSource)damageSource, (float)this.damage);
                        }
                        this.field_70170_p.func_72956_a((Entity)entityPlayer, Paintball.GUN_SPLAT, 1.0f, 1.0f / (this.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                        this.func_70106_y();
                    } else if (var4.field_72308_g instanceof EntityLiving && var4.field_72308_g != this.field_70250_c) {
                        Paintball.NETWORK_HELPER.sendPacketToPlayer(new PacketHandler(((EntityPlayer)this.field_70250_c).getDisplayNameString(), 2), (EntityPlayer)this.field_70250_c);
                        EntityLiving entityliving = (EntityLiving)var4.field_72308_g;
                        this.field_70170_p.func_72956_a((Entity)entityliving, Paintball.GUN_SPLAT, 1.0f, 1.0f / (this.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                        entityliving.field_70172_ad = 0;
                        entityliving.func_70097_a((DamageSource)damageSource, (float)this.damage);
                        this.func_70106_y();
                    } else if (var4.field_72308_g instanceof EntityPainting || var4.field_72308_g instanceof EntityMinecart) {
                        this.field_70170_p.func_72956_a(var4.field_72308_g, Paintball.GUN_SPLAT, 1.0f, 1.0f / (this.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                        this.func_70106_y();
                    } else {
                        this.field_70159_w *= (double)-0.1f;
                        this.field_70181_x *= (double)-0.1f;
                        this.field_70179_y *= (double)-0.1f;
                        this.field_70177_z += 180.0f;
                        this.field_70126_B += 180.0f;
                        this.ticksInAir = 0;
                    }
                } else {
                    BlockPos blockpos1 = var4.func_178782_a();
                    this.xTile = blockpos1.func_177958_n();
                    this.yTile = blockpos1.func_177956_o();
                    this.zTile = blockpos1.func_177952_p();
                    state = this.field_70170_p.func_180495_p(blockpos1);
                    this.inTile = state.func_177230_c();
                    this.inData = this.inTile.func_176201_c(state);
                    this.field_70159_w = (float)(var4.field_72307_f.field_72450_a - this.field_70165_t);
                    this.field_70181_x = (float)(var4.field_72307_f.field_72448_b - this.field_70163_u);
                    this.field_70179_y = (float)(var4.field_72307_f.field_72449_c - this.field_70161_v);
                    float var20 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
                    this.field_70165_t -= this.field_70159_w / (double)var20 * (double)0.05f;
                    this.field_70163_u -= this.field_70181_x / (double)var20 * (double)0.05f;
                    this.field_70161_v -= this.field_70179_y / (double)var20 * (double)0.05f;
                    this.field_70170_p.func_72956_a((Entity)this, Paintball.GUN_SPLAT, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                    this.inGround = true;
                    this.field_70249_b = 7;
                    this.func_70243_d(false);
                }
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            float var20 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            float var23 = 0.99f;
            var11 = 0.05f;
            if (this.func_70090_H()) {
                for (int var26 = 0; var26 < 4; ++var26) {
                    float var27 = 0.25f;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)var27, this.field_70163_u - this.field_70181_x * (double)var27, this.field_70161_v - this.field_70179_y * (double)var27, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
                var23 = 0.8f;
            }
            this.field_70159_w *= (double)var23;
            this.field_70181_x *= (double)var23;
            this.field_70179_y *= (double)var23;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_145775_I();
        }
    }

    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("Color", this.color);
        nbtTagCompound.func_74780_a("xStart", this.xStart);
        nbtTagCompound.func_74780_a("yStart", this.yStart);
        nbtTagCompound.func_74780_a("zStart", this.zStart);
        nbtTagCompound.func_74768_a("Distance", this.distance);
    }

    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        this.color = nbtTagCompound.func_74762_e("Color");
        this.xStart = nbtTagCompound.func_74769_h("xStart");
        this.yStart = nbtTagCompound.func_74769_h("yStart");
        this.zStart = nbtTagCompound.func_74769_h("zStart");
        this.distance = nbtTagCompound.func_74762_e("Distance");
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.color);
    }

    public void readSpawnData(ByteBuf data) {
        this.color = data.readInt();
    }

    public Entity getThrower() {
        return this.field_70250_c;
    }

    public void setThrower(Entity entity) {
        this.field_70250_c = entity;
    }
}

