/*
 * Decompiled with CFR 0.152.
 */
package com.slatebit.paintball.common;

import com.slatebit.paintball.common.EntityGrenade;
import com.slatebit.paintball.common.EntityPellet;
import com.slatebit.paintball.common.ItemGrenade;
import com.slatebit.paintball.common.ItemGun;
import com.slatebit.paintball.common.NetworkHelper;
import com.slatebit.paintball.common.Paintball;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;

public class PacketHandler
implements NetworkHelper.IPacket {
    private String username;
    private int packetType;

    public PacketHandler() {
    }

    public PacketHandler(String username, int packetType) {
        this.username = username;
        this.packetType = packetType;
    }

    @Override
    public void writeBytes(ChannelHandlerContext channelHandlerContext, ByteBuf data) {
        data.writeShort(this.username.length());
        for (char character : this.username.toCharArray()) {
            data.writeChar((int)character);
        }
        data.writeByte(this.packetType);
    }

    @Override
    public void readBytes(ChannelHandlerContext channelHandlerContext, ByteBuf data) {
        int length = data.readShort();
        char[] characters = new char[length];
        for (int i = 0; i < length; ++i) {
            characters[i] = data.readChar();
        }
        this.username = String.valueOf(characters);
        this.packetType = data.readByte();
        if (this.packetType == 1) {
            EntityPlayerMP entityPlayer = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(this.username);
            InventoryPlayer inventory = entityPlayer.field_71071_by;
            World world = entityPlayer.field_70170_p;
            int color = inventory.func_70448_g().func_77952_i();
            ItemStack grenadeItemStack = new ItemStack(Paintball.grenade, 1, color);
            if (inventory.func_70448_g() != null && inventory.func_70448_g().func_77973_b() instanceof ItemGun) {
                ItemGun gun = (ItemGun)inventory.func_70448_g().func_77973_b();
                ItemStack pelletItemStack = new ItemStack(Paintball.pellet, 1, color);
                if (gun.type != "Launcher" && inventory.func_70431_c(pelletItemStack)) {
                    if (!entityPlayer.field_71075_bZ.field_75098_d) {
                        Paintball.consumeInventoryItemStack(inventory, pelletItemStack, 1);
                    }
                    world.func_72956_a((Entity)entityPlayer, Paintball.GUN_SHOOT, 1.0f, 1.0f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                    for (int i = 0; i < (gun.type != "Shotgun" ? 1 : 6); ++i) {
                        world.func_72838_d((Entity)new EntityPellet(world, (EntityPlayer)entityPlayer, gun.damage, gun.distance, color));
                    }
                } else if (gun.type == "Launcher" && inventory.func_70431_c(grenadeItemStack)) {
                    if (!entityPlayer.field_71075_bZ.field_75098_d) {
                        Paintball.consumeInventoryItemStack(inventory, grenadeItemStack, 1);
                    }
                    world.func_72956_a((Entity)entityPlayer, Paintball.GRENADE_PIN, 1.0f, 1.0f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                    world.func_72838_d((Entity)new EntityGrenade(world, (EntityPlayer)entityPlayer, 0.035, color));
                }
            } else if (inventory.func_70448_g() != null && inventory.func_70448_g().func_77973_b() instanceof ItemGrenade && inventory.func_70431_c(grenadeItemStack)) {
                if (!entityPlayer.field_71075_bZ.field_75098_d) {
                    Paintball.consumeInventoryItemStack(inventory, grenadeItemStack, 1);
                }
                world.func_72956_a((Entity)entityPlayer, Paintball.GRENADE_PIN, 1.0f, 1.0f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                world.func_72838_d((Entity)new EntityGrenade(world, (EntityPlayer)entityPlayer, 0.07, color));
            }
        } else if (this.packetType == 2) {
            Paintball.hitMarker = 20;
        }
    }
}

