/*
 * Decompiled with CFR 0.152.
 */
package zotmc.tomahawk;

import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.eventhandler.ASMEventHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventBus;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.IEventListener;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import zotmc.tomahawk.TomahawkRegistry;
import zotmc.tomahawk.projectile.TomahawkDamage;
import zotmc.tomahawk.util.ListenerArrayList;
import zotmc.tomahawk.util.Refls;

public class DamageFaker
extends EventBus {
    private final Predicate<ASMEventHandler> isTarget = new Predicate<ASMEventHandler>(){
        final Field OWNER = Refls.getDeclaredField(ASMEventHandler.class, "owner");

        public boolean apply(ASMEventHandler input) {
            return TomahawkRegistry.fakeDamages((ModContainer)Refls.get(this.OWNER, input));
        }
    };
    private final Iterable<ASMEventHandler> livingAttackListeners = this.getListeners(LivingAttackEvent.class);
    private final Iterable<ASMEventHandler> livingHurtListeners = this.getListeners(LivingHurtEvent.class);

    private Iterable<ASMEventHandler> getListeners(Class<? extends Event> clz) {
        try {
            Constructor<? extends Event> ctr = clz.getConstructor(new Class[0]);
            ctr.setAccessible(true);
            Event event = ctr.newInstance(new Object[0]);
            return FluentIterable.from((Iterable)new ListenerArrayList(event, MinecraftForge.EVENT_BUS)).filter(ASMEventHandler.class).filter(this.isTarget);
        }
        catch (Throwable e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingAttack(LivingAttackEvent event) {
        if (event.entityLiving.field_70170_p instanceof WorldServer && event.source.getClass() == TomahawkDamage.class) {
            LivingAttackEvent fakingEvent = new LivingAttackEvent(event.entityLiving, ((TomahawkDamage)event.source).faking((WorldServer)event.entityLiving.field_70170_p), event.ammount);
            for (IEventListener iEventListener : this.livingAttackListeners) {
                iEventListener.invoke((Event)fakingEvent);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingHurt(LivingHurtEvent event) {
        if (event.entityLiving.field_70170_p instanceof WorldServer && event.source.getClass() == TomahawkDamage.class) {
            LivingHurtEvent fakingEvent = new LivingHurtEvent(event.entityLiving, ((TomahawkDamage)event.source).faking((WorldServer)event.entityLiving.field_70170_p), event.ammount);
            for (IEventListener iEventListener : this.livingHurtListeners) {
                iEventListener.invoke((Event)fakingEvent);
            }
            event.ammount = fakingEvent.ammount;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingDrops(LivingDropsEvent event) {
        if (event.entityLiving.field_70170_p instanceof WorldServer && event.source.getClass() == TomahawkDamage.class) {
            this.post((Event)new LivingDropsEvent(event.entityLiving, ((TomahawkDamage)event.source).faking((WorldServer)event.entityLiving.field_70170_p), event.drops, event.lootingLevel, event.recentlyHit, event.specialDropValue));
        }
    }
}

