/*
 * Decompiled with CFR 0.152.
 */
package zotmc.tomahawk;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import zotmc.onlysilver.api.OnlySilverRegistry;
import zotmc.tomahawk.projectile.EntityTomahawk;

public class OnlySilverHandler {
    static void init() {
        OnlySilverRegistry.registerWeaponFunction((String)"thrown", (Function)new Function<DamageSource, OnlySilverRegistry.InUseWeapon>(){

            public OnlySilverRegistry.InUseWeapon apply(DamageSource input) {
                Entity projectile = input.func_76364_f();
                if (projectile instanceof EntityTomahawk) {
                    final EntityTomahawk hawk = (EntityTomahawk)projectile;
                    return new OnlySilverRegistry.InUseWeapon(){

                        public Optional<EntityLivingBase> getUser() {
                            Entity thrower = hawk.getThrower();
                            return Optional.fromNullable((Object)(thrower instanceof EntityLivingBase ? (EntityLivingBase)thrower : null));
                        }

                        public Optional<ItemStack> getItem() {
                            return Optional.fromNullable((Object)hawk.getItem());
                        }

                        public void update(ItemStack item) {
                            if (item == null) {
                                hawk.func_70106_y();
                                hawk.func_85030_a("random.break", 0.8f, 0.8f + hawk.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                            }
                            if (item != hawk.getItem()) {
                                hawk.setItem(item);
                            }
                        }

                        public String toString() {
                            return String.format("[Tomahawk %s thrown by %s]", this.getItem().orNull(), this.getUser().orNull());
                        }
                    };
                }
                return null;
            }
        });
    }
}

